/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.memory;

import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.apache.spark.unsafe.memory.MemoryBlock;

public class UnsafeMemoryAllocator
implements MemoryAllocator {
    @Override
    public MemoryBlock allocate(long size) throws OutOfMemoryError {
        if (size % 8L != 0L) {
            throw new IllegalArgumentException("Size " + size + " was not a multiple of 8");
        }
        long address = Platform.allocateMemory(size);
        return new MemoryBlock(null, address, size);
    }

    @Override
    public void free(MemoryBlock memory) {
        assert (memory.obj == null) : "baseObject not null; are you trying to use the off-heap allocator to free on-heap memory?";
        Platform.freeMemory(memory.offset);
    }
}

