/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.memory;

import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.apache.spark.unsafe.memory.MemoryBlock;

public class HeapMemoryAllocator
implements MemoryAllocator {
    @Override
    public MemoryBlock allocate(long size) throws OutOfMemoryError {
        if (size % 8L != 0L) {
            throw new IllegalArgumentException("Size " + size + " was not a multiple of 8");
        }
        long[] array = new long[(int)(size / 8L)];
        return MemoryBlock.fromLongArray(array);
    }

    @Override
    public void free(MemoryBlock memory) {
    }
}

