/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.types;

import junit.framework.Assert;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.junit.Test;

public class CalendarIntervalSuite {
    @Test
    public void equalsTest() {
        CalendarInterval i1 = new CalendarInterval(3, 123L);
        CalendarInterval i2 = new CalendarInterval(3, 321L);
        CalendarInterval i3 = new CalendarInterval(1, 123L);
        CalendarInterval i4 = new CalendarInterval(3, 123L);
        Assert.assertNotSame((Object)i1, (Object)i2);
        Assert.assertNotSame((Object)i1, (Object)i3);
        Assert.assertNotSame((Object)i2, (Object)i3);
        Assert.assertEquals((Object)i1, (Object)i4);
    }

    @Test
    public void toStringTest() {
        CalendarInterval i = new CalendarInterval(34, 0L);
        Assert.assertEquals((String)i.toString(), (String)"interval 2 years 10 months");
        i = new CalendarInterval(-34, 0L);
        Assert.assertEquals((String)i.toString(), (String)"interval -2 years -10 months");
        i = new CalendarInterval(0, 1861200000123L);
        Assert.assertEquals((String)i.toString(), (String)"interval 3 weeks 13 hours 123 microseconds");
        i = new CalendarInterval(0, -1861200000123L);
        Assert.assertEquals((String)i.toString(), (String)"interval -3 weeks -13 hours -123 microseconds");
        i = new CalendarInterval(34, 1861200000123L);
        Assert.assertEquals((String)i.toString(), (String)"interval 2 years 10 months 3 weeks 13 hours 123 microseconds");
    }

    @Test
    public void fromStringTest() {
        this.testSingleUnit("year", 3, 36, 0L);
        this.testSingleUnit("month", 3, 3, 0L);
        this.testSingleUnit("week", 3, 0, 1814400000000L);
        this.testSingleUnit("day", 3, 0, 259200000000L);
        this.testSingleUnit("hour", 3, 0, 10800000000L);
        this.testSingleUnit("minute", 3, 0, 180000000L);
        this.testSingleUnit("second", 3, 0, 3000000L);
        this.testSingleUnit("millisecond", 3, 0, 3000L);
        this.testSingleUnit("microsecond", 3, 0, 3L);
        String input = "interval   -5  years  23   month";
        CalendarInterval result = new CalendarInterval(-37, 0L);
        Assert.assertEquals((Object)CalendarInterval.fromString((String)input), (Object)result);
        input = "interval   -5  years  23   month   ";
        Assert.assertEquals((Object)CalendarInterval.fromString((String)input), (Object)result);
        input = "  interval   -5  years  23   month   ";
        Assert.assertEquals((Object)CalendarInterval.fromString((String)input), (Object)result);
        input = "interval   3month 1 hour";
        Assert.assertEquals((Object)CalendarInterval.fromString((String)input), null);
        input = "interval 3 moth 1 hour";
        Assert.assertEquals((Object)CalendarInterval.fromString((String)input), null);
        input = "interval";
        Assert.assertEquals((Object)CalendarInterval.fromString((String)input), null);
        input = "int";
        Assert.assertEquals((Object)CalendarInterval.fromString((String)input), null);
        input = "";
        Assert.assertEquals((Object)CalendarInterval.fromString((String)input), null);
        input = null;
        Assert.assertEquals((Object)CalendarInterval.fromString((String)input), null);
    }

    @Test
    public void fromYearMonthStringTest() {
        String input = "99-10";
        CalendarInterval i = new CalendarInterval(1198, 0L);
        Assert.assertEquals((Object)CalendarInterval.fromYearMonthString((String)input), (Object)i);
        input = "-8-10";
        i = new CalendarInterval(-106, 0L);
        Assert.assertEquals((Object)CalendarInterval.fromYearMonthString((String)input), (Object)i);
        try {
            input = "99-15";
            CalendarInterval.fromYearMonthString((String)input);
            Assert.fail((String)"Expected to throw an exception for the invalid input");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("month 15 outside range"));
        }
    }

    @Test
    public void fromDayTimeStringTest() {
        String input = "5 12:40:30.999999999";
        CalendarInterval i = new CalendarInterval(0, 477630999999L);
        Assert.assertEquals((Object)CalendarInterval.fromDayTimeString((String)input), (Object)i);
        input = "10 0:12:0.888";
        i = new CalendarInterval(0, 864720000000L);
        Assert.assertEquals((Object)CalendarInterval.fromDayTimeString((String)input), (Object)i);
        input = "-3 0:0:0";
        i = new CalendarInterval(0, -259200000000L);
        Assert.assertEquals((Object)CalendarInterval.fromDayTimeString((String)input), (Object)i);
        try {
            input = "5 30:12:20";
            CalendarInterval.fromDayTimeString((String)input);
            Assert.fail((String)"Expected to throw an exception for the invalid input");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("hour 30 outside range"));
        }
        try {
            input = "5 30-12";
            CalendarInterval.fromDayTimeString((String)input);
            Assert.fail((String)"Expected to throw an exception for the invalid input");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("not match day-time format"));
        }
    }

    @Test
    public void fromSingleUnitStringTest() {
        String input = "12";
        CalendarInterval i = new CalendarInterval(144, 0L);
        Assert.assertEquals((Object)CalendarInterval.fromSingleUnitString((String)"year", (String)input), (Object)i);
        input = "100";
        i = new CalendarInterval(0, 8640000000000L);
        Assert.assertEquals((Object)CalendarInterval.fromSingleUnitString((String)"day", (String)input), (Object)i);
        input = "1999.38888";
        i = new CalendarInterval(0, 1999000038L);
        Assert.assertEquals((Object)CalendarInterval.fromSingleUnitString((String)"second", (String)input), (Object)i);
        try {
            input = String.valueOf(Integer.MAX_VALUE);
            CalendarInterval.fromSingleUnitString((String)"year", (String)input);
            Assert.fail((String)"Expected to throw an exception for the invalid input");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("outside range"));
        }
        try {
            input = String.valueOf(2562047789L);
            CalendarInterval.fromSingleUnitString((String)"hour", (String)input);
            Assert.fail((String)"Expected to throw an exception for the invalid input");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("outside range"));
        }
    }

    @Test
    public void addTest() {
        String input = "interval 3 month 1 hour";
        String input2 = "interval 2 month 100 hour";
        CalendarInterval interval = CalendarInterval.fromString((String)input);
        CalendarInterval interval2 = CalendarInterval.fromString((String)input2);
        Assert.assertEquals((Object)interval.add(interval2), (Object)new CalendarInterval(5, 363600000000L));
        input = "interval -10 month -81 hour";
        input2 = "interval 75 month 200 hour";
        interval = CalendarInterval.fromString((String)input);
        interval2 = CalendarInterval.fromString((String)input2);
        Assert.assertEquals((Object)interval.add(interval2), (Object)new CalendarInterval(65, 428400000000L));
    }

    @Test
    public void subtractTest() {
        String input = "interval 3 month 1 hour";
        String input2 = "interval 2 month 100 hour";
        CalendarInterval interval = CalendarInterval.fromString((String)input);
        CalendarInterval interval2 = CalendarInterval.fromString((String)input2);
        Assert.assertEquals((Object)interval.subtract(interval2), (Object)new CalendarInterval(1, -356400000000L));
        input = "interval -10 month -81 hour";
        input2 = "interval 75 month 200 hour";
        interval = CalendarInterval.fromString((String)input);
        interval2 = CalendarInterval.fromString((String)input2);
        Assert.assertEquals((Object)interval.subtract(interval2), (Object)new CalendarInterval(-85, -1011600000000L));
    }

    private void testSingleUnit(String unit, int number, int months, long microseconds) {
        String input1 = "interval " + number + " " + unit;
        String input2 = "interval " + number + " " + unit + "s";
        CalendarInterval result = new CalendarInterval(months, microseconds);
        Assert.assertEquals((Object)CalendarInterval.fromString((String)input1), (Object)result);
        Assert.assertEquals((Object)CalendarInterval.fromString((String)input2), (Object)result);
    }
}

