/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.memory;

import org.apache.spark.unsafe.memory.ExecutorMemoryManager;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.unsafe.memory.TaskMemoryManager;
import org.junit.Assert;
import org.junit.Test;

public class TaskMemoryManagerSuite {
    @Test
    public void leakedNonPageMemoryIsDetected() {
        TaskMemoryManager manager = new TaskMemoryManager(new ExecutorMemoryManager(MemoryAllocator.HEAP));
        manager.allocate(1024L);
        Assert.assertEquals((long)1024L, (long)manager.cleanUpAllAllocatedMemory());
    }

    @Test
    public void leakedPageMemoryIsDetected() {
        TaskMemoryManager manager = new TaskMemoryManager(new ExecutorMemoryManager(MemoryAllocator.HEAP));
        manager.allocatePage(4096L);
        Assert.assertEquals((long)4096L, (long)manager.cleanUpAllAllocatedMemory());
    }

    @Test
    public void encodePageNumberAndOffsetOffHeap() {
        TaskMemoryManager manager = new TaskMemoryManager(new ExecutorMemoryManager(MemoryAllocator.UNSAFE));
        MemoryBlock dataPage = manager.allocatePage(256L);
        long offset = 0x800000000000AL;
        long encodedAddress = manager.encodePageNumberAndOffset(dataPage, 0x800000000000AL);
        Assert.assertEquals(null, (Object)manager.getPage(encodedAddress));
        Assert.assertEquals((long)0x800000000000AL, (long)manager.getOffsetInPage(encodedAddress));
    }

    @Test
    public void encodePageNumberAndOffsetOnHeap() {
        TaskMemoryManager manager = new TaskMemoryManager(new ExecutorMemoryManager(MemoryAllocator.HEAP));
        MemoryBlock dataPage = manager.allocatePage(256L);
        long encodedAddress = manager.encodePageNumberAndOffset(dataPage, 64L);
        Assert.assertEquals((Object)dataPage.getBaseObject(), (Object)manager.getPage(encodedAddress));
        Assert.assertEquals((long)64L, (long)manager.getOffsetInPage(encodedAddress));
    }
}

