/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.hash;

import java.util.HashSet;
import java.util.Random;
import junit.framework.Assert;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.junit.Test;

public class Murmur3_x86_32Suite {
    private static final Murmur3_x86_32 hasher = new Murmur3_x86_32(0);

    @Test
    public void testKnownIntegerInputs() {
        Assert.assertEquals((int)593689054, (int)hasher.hashInt(0));
        Assert.assertEquals((int)-189366624, (int)hasher.hashInt(-42));
        Assert.assertEquals((int)-1134849565, (int)hasher.hashInt(42));
        Assert.assertEquals((int)-1718298732, (int)hasher.hashInt(Integer.MIN_VALUE));
        Assert.assertEquals((int)-1653689534, (int)hasher.hashInt(Integer.MAX_VALUE));
    }

    @Test
    public void testKnownLongInputs() {
        Assert.assertEquals((int)1669671676, (int)hasher.hashLong(0L));
        Assert.assertEquals((int)-846261623, (int)hasher.hashLong(-42L));
        Assert.assertEquals((int)1871679806, (int)hasher.hashLong(42L));
        Assert.assertEquals((int)1366273829, (int)hasher.hashLong(Long.MIN_VALUE));
        Assert.assertEquals((int)-2106506049, (int)hasher.hashLong(Long.MAX_VALUE));
    }

    @Test
    public void randomizedStressTest() {
        int size = 65536;
        Random rand = new Random();
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            int vint = rand.nextInt();
            long lint = rand.nextLong();
            Assert.assertEquals((int)hasher.hashInt(vint), (int)hasher.hashInt(vint));
            Assert.assertEquals((int)hasher.hashLong(lint), (int)hasher.hashLong(lint));
            hashcodes.add(hasher.hashLong(lint));
        }
        Assert.assertTrue(((double)hashcodes.size() > (double)size * 0.95 ? 1 : 0) != 0);
    }

    @Test
    public void randomizedStressTestBytes() {
        int size = 65536;
        Random rand = new Random();
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            int byteArrSize = rand.nextInt(100) * 8;
            byte[] bytes = new byte[byteArrSize];
            rand.nextBytes(bytes);
            Assert.assertEquals((int)hasher.hashUnsafeWords((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize), (int)hasher.hashUnsafeWords((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize));
            hashcodes.add(hasher.hashUnsafeWords((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize));
        }
        Assert.assertTrue(((double)hashcodes.size() > (double)size * 0.95 ? 1 : 0) != 0);
    }

    @Test
    public void randomizedStressTestPaddedStrings() {
        int size = 64000;
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            int byteArrSize = 8;
            byte[] strBytes = ("" + i).getBytes();
            byte[] paddedBytes = new byte[byteArrSize];
            System.arraycopy(strBytes, 0, paddedBytes, 0, strBytes.length);
            Assert.assertEquals((int)hasher.hashUnsafeWords((Object)paddedBytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize), (int)hasher.hashUnsafeWords((Object)paddedBytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize));
            hashcodes.add(hasher.hashUnsafeWords((Object)paddedBytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize));
        }
        Assert.assertTrue(((double)hashcodes.size() > (double)size * 0.95 ? 1 : 0) != 0);
    }
}

