/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.kafka010;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.kafka010.KafkaTokenClusterConf;
import org.apache.spark.kafka010.KafkaTokenSparkConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001I4AAI\u0012\u0001Y!)q\u0007\u0001C\u0001q!91\b\u0001b\u0001\n\u0013a\u0004BB#\u0001A\u0003%Q\bC\u0004G\u0001\t\u0007I\u0011\u0002\u001f\t\r\u001d\u0003\u0001\u0015!\u0003>\u0011\u001dA\u0005A1A\u0005\nqBa!\u0013\u0001!\u0002\u0013i\u0004b\u0002&\u0001\u0005\u0004%I\u0001\u0010\u0005\u0007\u0017\u0002\u0001\u000b\u0011B\u001f\t\u000f1\u0003!\u0019!C\u0005y!1Q\n\u0001Q\u0001\nuBqA\u0014\u0001C\u0002\u0013%A\b\u0003\u0004P\u0001\u0001\u0006I!\u0010\u0005\b!\u0002\u0011\r\u0011\"\u0003=\u0011\u0019\t\u0006\u0001)A\u0005{!9!\u000b\u0001b\u0001\n\u0013a\u0004BB*\u0001A\u0003%Q\bC\u0004U\u0001\t\u0007I\u0011\u0002\u001f\t\rU\u0003\u0001\u0015!\u0003>\u0011\u001d1\u0006A1A\u0005\nqBaa\u0016\u0001!\u0002\u0013i\u0004b\u0002-\u0001\u0005\u0004%I\u0001\u0010\u0005\u00073\u0002\u0001\u000b\u0011B\u001f\t\u000fi\u0003!\u0019!C\u0005y!11\f\u0001Q\u0001\nuBq\u0001\u0018\u0001C\u0002\u0013%A\b\u0003\u0004^\u0001\u0001\u0006I!\u0010\u0005\b=\u0002\u0011\r\u0011\"\u0003=\u0011\u0019y\u0006\u0001)A\u0005{!9\u0001\r\u0001a\u0001\n\u0013\t\u0007bB3\u0001\u0001\u0004%IA\u001a\u0005\u0007_\u0002\u0001\u000b\u0015\u00022\t\u000bA\u0004A\u0011I9\u00031-\u000bgm[1U_.,gn\u00159be.\u001cuN\u001c4Tk&$XM\u0003\u0002%K\u0005A1.\u00194lCB\n\u0004G\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u00192\u0001A\u00172!\tqs&D\u0001&\u0013\t\u0001TEA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003eUj\u0011a\r\u0006\u0003i%\n\u0011b]2bY\u0006$Xm\u001d;\n\u0005Y\u001a$A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"\fa\u0001P5oSRtD#A\u001d\u0011\u0005i\u0002Q\"A\u0012\u0002\u0017%$WM\u001c;jM&,'/M\u000b\u0002{A\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005Y\u0006twMC\u0001C\u0003\u0011Q\u0017M^1\n\u0005\u0011{$AB*ue&tw-\u0001\u0007jI\u0016tG/\u001b4jKJ\f\u0004%A\u0006jI\u0016tG/\u001b4jKJ\u0014\u0014\u0001D5eK:$\u0018NZ5feJ\u0002\u0013\u0001F1vi\"\u0014un\u001c;TiJ\f\u0007oU3sm\u0016\u00148/A\u000bbkRD'i\\8u'R\u0014\u0018\r]*feZ,'o\u001d\u0011\u0002%Q\f'oZ3u'\u0016\u0014h/\u001a:t%\u0016<W\r_\u0001\u0014i\u0006\u0014x-\u001a;TKJ4XM]:SK\u001e,\u0007\u0010I\u0001\u0011g\u0016\u001cWO]5usB\u0013x\u000e^8d_2\f\u0011c]3dkJLG/\u001f)s_R|7m\u001c7!\u0003MYWM\u001d2fe>\u001c8+\u001a:wS\u000e,g*Y7f\u0003QYWM\u001d2fe>\u001c8+\u001a:wS\u000e,g*Y7fA\u0005qAO];tiN#xN]3UsB,\u0017a\u0004;skN$8\u000b^8sKRK\b/\u001a\u0011\u0002%Q\u0014Xo\u001d;Ti>\u0014X\rT8dCRLwN\\\u0001\u0014iJ,8\u000f^*u_J,Gj\\2bi&|g\u000eI\u0001\u0013iJ,8\u000f^*u_J,\u0007+Y:to>\u0014H-A\nueV\u001cHo\u0015;pe\u0016\u0004\u0016m]:x_J$\u0007%\u0001\u0007lKf\u001cFo\u001c:f)f\u0004X-A\u0007lKf\u001cFo\u001c:f)f\u0004X\rI\u0001\u0011W\u0016L8\u000b^8sK2{7-\u0019;j_:\f\u0011c[3z'R|'/\u001a'pG\u0006$\u0018n\u001c8!\u0003AYW-_*u_J,\u0007+Y:to>\u0014H-A\tlKf\u001cFo\u001c:f!\u0006\u001c8o^8sI\u0002\n1b[3z!\u0006\u001c8o^8sI\u0006a1.Z=QCN\u001cxo\u001c:eA\u0005qAo\\6f]6+7\r[1oSNl\u0017a\u0004;pW\u0016tW*Z2iC:L7/\u001c\u0011\u0002\u0013M\u0004\u0018M]6D_:4W#\u00012\u0011\u00059\u001a\u0017B\u00013&\u0005%\u0019\u0006/\u0019:l\u0007>tg-A\u0007ta\u0006\u00148nQ8oM~#S-\u001d\u000b\u0003O6\u0004\"\u0001[6\u000e\u0003%T\u0011A[\u0001\u0006g\u000e\fG.Y\u0005\u0003Y&\u0014A!\u00168ji\"9anHA\u0001\u0002\u0004\u0011\u0017a\u0001=%c\u0005Q1\u000f]1sW\u000e{gN\u001a\u0011\u0002\u0015\t,gm\u001c:f\u000b\u0006\u001c\u0007\u000eF\u0001h\u0001")
public class KafkaTokenSparkConfSuite
extends SparkFunSuite {
    private final String identifier1;
    private final String identifier2;
    private final String authBootStrapServers;
    private final String targetServersRegex;
    private final String securityProtocol;
    private final String kerberosServiceName;
    private final String trustStoreType;
    private final String trustStoreLocation;
    private final String trustStorePassword;
    private final String keyStoreType;
    private final String keyStoreLocation;
    private final String keyStorePassword;
    private final String keyPassword;
    private final String tokenMechanism;
    private SparkConf sparkConf;

    private String identifier1() {
        return this.identifier1;
    }

    private String identifier2() {
        return this.identifier2;
    }

    private String authBootStrapServers() {
        return this.authBootStrapServers;
    }

    private String targetServersRegex() {
        return this.targetServersRegex;
    }

    private String securityProtocol() {
        return this.securityProtocol;
    }

    private String kerberosServiceName() {
        return this.kerberosServiceName;
    }

    private String trustStoreType() {
        return this.trustStoreType;
    }

    private String trustStoreLocation() {
        return this.trustStoreLocation;
    }

    private String trustStorePassword() {
        return this.trustStorePassword;
    }

    private String keyStoreType() {
        return this.keyStoreType;
    }

    private String keyStoreLocation() {
        return this.keyStoreLocation;
    }

    private String keyStorePassword() {
        return this.keyStorePassword;
    }

    private String keyPassword() {
        return this.keyPassword;
    }

    private String tokenMechanism() {
        return this.tokenMechanism;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private void sparkConf_$eq(SparkConf x$1) {
        this.sparkConf = x$1;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.sparkConf_$eq(new SparkConf());
    }

    public KafkaTokenSparkConfSuite() {
        this.identifier1 = "cluster1";
        this.identifier2 = "cluster2";
        this.authBootStrapServers = "127.0.0.1:0";
        this.targetServersRegex = "127.0.0.*:0";
        this.securityProtocol = SecurityProtocol.SSL.name;
        this.kerberosServiceName = "kafka1";
        this.trustStoreType = "customTrustStoreType";
        this.trustStoreLocation = "/path/to/trustStore";
        this.trustStorePassword = "trustStoreSecret";
        this.keyStoreType = "customKeyStoreType";
        this.keyStoreLocation = "/path/to/keyStore";
        this.keyStorePassword = "keyStoreSecret";
        this.keyPassword = "keySecret";
        this.tokenMechanism = "SCRAM-SHA-256";
        this.sparkConf = null;
        this.test("getClusterConfig should trow exception when not exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            NoSuchElementException thrown = (NoSuchElementException)this.intercept((Function0 & Serializable & scala.Serializable)() -> KafkaTokenSparkConf$.MODULE$.getClusterConfig(this.sparkConf(), "invalid"), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            String $org_scalatest_assert_macro_left = thrown.getMessage();
            String $org_scalatest_assert_macro_right = "spark.kafka.clusters.invalid.auth.bootstrap.servers";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("getClusterConfig should return entry with defaults", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sparkConf().set(new StringBuilder(44).append("spark.kafka.clusters.").append(this.identifier1()).append(".auth.bootstrap.servers").toString(), this.authBootStrapServers());
            KafkaTokenClusterConf clusterConfig = KafkaTokenSparkConf$.MODULE$.getClusterConfig(this.sparkConf(), this.identifier1());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(clusterConfig.identifier());
            String $org_scalatest_assert_macro_right = this.identifier1();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(clusterConfig.authBootstrapServers());
            String $org_scalatest_assert_macro_right2 = this.authBootStrapServers();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(clusterConfig.targetServersRegex());
            String $org_scalatest_assert_macro_right3 = KafkaTokenSparkConf$.MODULE$.DEFAULT_TARGET_SERVERS_REGEX();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(clusterConfig.securityProtocol());
            String $org_scalatest_assert_macro_right4 = SecurityProtocol.SASL_SSL.name;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(clusterConfig.kerberosServiceName());
            String $org_scalatest_assert_macro_right5 = KafkaTokenSparkConf$.MODULE$.DEFAULT_SASL_KERBEROS_SERVICE_NAME();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(clusterConfig.trustStoreType());
            None$ $org_scalatest_assert_macro_right6 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(clusterConfig.trustStoreLocation());
            None$ $org_scalatest_assert_macro_right7 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(clusterConfig.trustStorePassword());
            None$ $org_scalatest_assert_macro_right8 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(clusterConfig.keyStoreType());
            None$ $org_scalatest_assert_macro_right9 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(clusterConfig.keyStoreLocation());
            None$ $org_scalatest_assert_macro_right10 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(clusterConfig.keyStorePassword());
            None$ $org_scalatest_assert_macro_right11 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(clusterConfig.keyPassword());
            None$ $org_scalatest_assert_macro_right12 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(clusterConfig.tokenMechanism());
            String $org_scalatest_assert_macro_right13 = KafkaTokenSparkConf$.MODULE$.DEFAULT_SASL_TOKEN_MECHANISM();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("getClusterConfig should return entry overwrite defaults", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sparkConf().set(new StringBuilder(44).append("spark.kafka.clusters.").append(this.identifier1()).append(".auth.bootstrap.servers").toString(), this.authBootStrapServers());
            this.sparkConf().set(new StringBuilder(52).append("spark.kafka.clusters.").append(this.identifier1()).append(".target.bootstrap.servers.regex").toString(), this.targetServersRegex());
            this.sparkConf().set(new StringBuilder(39).append("spark.kafka.clusters.").append(this.identifier1()).append(".security.protocol").toString(), this.securityProtocol());
            this.sparkConf().set(new StringBuilder(48).append("spark.kafka.clusters.").append(this.identifier1()).append(".sasl.kerberos.service.name").toString(), this.kerberosServiceName());
            this.sparkConf().set(new StringBuilder(41).append("spark.kafka.clusters.").append(this.identifier1()).append(".ssl.truststore.type").toString(), this.trustStoreType());
            this.sparkConf().set(new StringBuilder(45).append("spark.kafka.clusters.").append(this.identifier1()).append(".ssl.truststore.location").toString(), this.trustStoreLocation());
            this.sparkConf().set(new StringBuilder(45).append("spark.kafka.clusters.").append(this.identifier1()).append(".ssl.truststore.password").toString(), this.trustStorePassword());
            this.sparkConf().set(new StringBuilder(39).append("spark.kafka.clusters.").append(this.identifier1()).append(".ssl.keystore.type").toString(), this.keyStoreType());
            this.sparkConf().set(new StringBuilder(43).append("spark.kafka.clusters.").append(this.identifier1()).append(".ssl.keystore.location").toString(), this.keyStoreLocation());
            this.sparkConf().set(new StringBuilder(43).append("spark.kafka.clusters.").append(this.identifier1()).append(".ssl.keystore.password").toString(), this.keyStorePassword());
            this.sparkConf().set(new StringBuilder(38).append("spark.kafka.clusters.").append(this.identifier1()).append(".ssl.key.password").toString(), this.keyPassword());
            this.sparkConf().set(new StringBuilder(42).append("spark.kafka.clusters.").append(this.identifier1()).append(".sasl.token.mechanism").toString(), this.tokenMechanism());
            KafkaTokenClusterConf clusterConfig = KafkaTokenSparkConf$.MODULE$.getClusterConfig(this.sparkConf(), this.identifier1());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(clusterConfig.identifier());
            String $org_scalatest_assert_macro_right = this.identifier1();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(clusterConfig.authBootstrapServers());
            String $org_scalatest_assert_macro_right2 = this.authBootStrapServers();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(clusterConfig.targetServersRegex());
            String $org_scalatest_assert_macro_right3 = this.targetServersRegex();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(clusterConfig.securityProtocol());
            String $org_scalatest_assert_macro_right4 = this.securityProtocol();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(clusterConfig.kerberosServiceName());
            String $org_scalatest_assert_macro_right5 = this.kerberosServiceName();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(clusterConfig.trustStoreType());
            Some $org_scalatest_assert_macro_right6 = new Some((Object)this.trustStoreType());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(clusterConfig.trustStoreLocation());
            Some $org_scalatest_assert_macro_right7 = new Some((Object)this.trustStoreLocation());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(clusterConfig.trustStorePassword());
            Some $org_scalatest_assert_macro_right8 = new Some((Object)this.trustStorePassword());
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(clusterConfig.keyStoreType());
            Some $org_scalatest_assert_macro_right9 = new Some((Object)this.keyStoreType());
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(clusterConfig.keyStoreLocation());
            Some $org_scalatest_assert_macro_right10 = new Some((Object)this.keyStoreLocation());
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(clusterConfig.keyStorePassword());
            Some $org_scalatest_assert_macro_right11 = new Some((Object)this.keyStorePassword());
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(clusterConfig.keyPassword());
            Some $org_scalatest_assert_macro_right12 = new Some((Object)this.keyPassword());
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(clusterConfig.tokenMechanism());
            String $org_scalatest_assert_macro_right13 = this.tokenMechanism();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("getClusterConfig should return specified kafka params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sparkConf().set(new StringBuilder(44).append("spark.kafka.clusters.").append(this.identifier1()).append(".auth.bootstrap.servers").toString(), this.authBootStrapServers());
            this.sparkConf().set(new StringBuilder(37).append("spark.kafka.clusters.").append(this.identifier1()).append(".kafka.customKey").toString(), "customValue");
            KafkaTokenClusterConf clusterConfig = KafkaTokenSparkConf$.MODULE$.getClusterConfig(this.sparkConf(), this.identifier1());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(clusterConfig.identifier());
            String $org_scalatest_assert_macro_right = this.identifier1();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(clusterConfig.authBootstrapServers());
            String $org_scalatest_assert_macro_right2 = this.authBootStrapServers();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(clusterConfig.specifiedKafkaParams());
            Map $org_scalatest_assert_macro_right3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customKey"), (Object)"customValue")}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("getAllClusterConfigs should return empty list when nothing configured", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Set $org_scalatest_assert_macro_left = KafkaTokenSparkConf$.MODULE$.getAllClusterConfigs(this.sparkConf());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("getAllClusterConfigs should return empty list with malformed configuration", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sparkConf().set("spark.kafka.clusters.", this.authBootStrapServers());
            Set $org_scalatest_assert_macro_left = KafkaTokenSparkConf$.MODULE$.getAllClusterConfigs(this.sparkConf());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("getAllClusterConfigs should return multiple entries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sparkConf().set(new StringBuilder(44).append("spark.kafka.clusters.").append(this.identifier1()).append(".auth.bootstrap.servers").toString(), this.authBootStrapServers());
            this.sparkConf().set(new StringBuilder(44).append("spark.kafka.clusters.").append(this.identifier2()).append(".auth.bootstrap.servers").toString(), this.authBootStrapServers());
            Set clusterConfigs = KafkaTokenSparkConf$.MODULE$.getAllClusterConfigs(this.sparkConf());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)clusterConfigs.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            clusterConfigs.foreach((Function1 & Serializable & scala.Serializable)clusterConfig -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(clusterConfig.authBootstrapServers());
                String $org_scalatest_assert_macro_right = this.authBootStrapServers();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(clusterConfig.targetServersRegex());
                String $org_scalatest_assert_macro_right2 = KafkaTokenSparkConf$.MODULE$.DEFAULT_TARGET_SERVERS_REGEX();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(clusterConfig.securityProtocol());
                String $org_scalatest_assert_macro_right3 = SecurityProtocol.SASL_SSL.name;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(clusterConfig.kerberosServiceName());
                String $org_scalatest_assert_macro_right4 = KafkaTokenSparkConf$.MODULE$.DEFAULT_SASL_KERBEROS_SERVICE_NAME();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(clusterConfig.trustStoreType());
                None$ $org_scalatest_assert_macro_right5 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(clusterConfig.trustStoreLocation());
                None$ $org_scalatest_assert_macro_right6 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(clusterConfig.trustStorePassword());
                None$ $org_scalatest_assert_macro_right7 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(clusterConfig.keyStoreType());
                None$ $org_scalatest_assert_macro_right8 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(clusterConfig.keyStoreLocation());
                None$ $org_scalatest_assert_macro_right9 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(clusterConfig.keyStorePassword());
                None$ $org_scalatest_assert_macro_right10 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(clusterConfig.keyPassword());
                None$ $org_scalatest_assert_macro_right11 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(clusterConfig.tokenMechanism());
                String $org_scalatest_assert_macro_right12 = KafkaTokenSparkConf$.MODULE$.DEFAULT_SASL_TOKEN_MECHANISM();
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            });
        }, new Position("KafkaTokenSparkConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
    }
}

