/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka;

import kafka.common.TopicAndPartition;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.streaming.kafka.KafkaCluster;
import org.apache.spark.streaming.kafka.KafkaTestUtils;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u001b\t\t2*\u00194lC\u000ecWo\u001d;feN+\u0018\u000e^3\u000b\u0005\r!\u0011!B6bM.\f'BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0013!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+)\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005]!\"!\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]!mY\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\b=\u0001\u0011\r\u0011\"\u0003 \u0003\u0015!x\u000e]5d+\u0005\u0001\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\nAA[1wC&\u0011qE\t\u0002\u0007'R\u0014\u0018N\\4\t\r%\u0002\u0001\u0015!\u0003!\u0003\u0019!x\u000e]5dA!91\u0006\u0001b\u0001\n\u0013a\u0013!\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]V\tQ\u0006\u0005\u0002/e5\tqF\u0003\u00021c\u000511m\\7n_:T\u0011aA\u0005\u0003g=\u0012\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u0019)\u0004\u0001)A\u0005[\u0005\u0011Bo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8!\u0011\u001d9\u0004\u00011A\u0005\na\n!a[2\u0016\u0003e\u0002\"\u0001\b\u001e\n\u0005m\u0012!\u0001D&bM.\f7\t\\;ti\u0016\u0014\bbB\u001f\u0001\u0001\u0004%IAP\u0001\u0007W\u000e|F%Z9\u0015\u0005}*\u0005C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%\u0001B+oSRDqA\u0012\u001f\u0002\u0002\u0003\u0007\u0011(A\u0002yIEBa\u0001\u0013\u0001!B\u0013I\u0014aA6dA!I!\n\u0001a\u0001\u0002\u0004%IaS\u0001\u000fW\u000647.\u0019+fgR,F/\u001b7t+\u0005a\u0005C\u0001\u000fN\u0013\tq%A\u0001\bLC\u001a\\\u0017\rV3tiV#\u0018\u000e\\:\t\u0013A\u0003\u0001\u0019!a\u0001\n\u0013\t\u0016AE6bM.\fG+Z:u+RLGn]0%KF$\"a\u0010*\t\u000f\u0019{\u0015\u0011!a\u0001\u0019\"1A\u000b\u0001Q!\n1\u000bqb[1gW\u0006$Vm\u001d;Vi&d7\u000f\t\u0005\u0006-\u0002!\teV\u0001\nE\u00164wN]3BY2$\u0012a\u0010\u0005\u00063\u0002!\teV\u0001\tC\u001a$XM]!mY\u0002")
public class KafkaClusterSuite
extends SparkFunSuite
implements BeforeAndAfterAll {
    private final String org$apache$spark$streaming$kafka$KafkaClusterSuite$$topic;
    private final TopicAndPartition org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition;
    private KafkaCluster org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc;
    private KafkaTestUtils org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public String org$apache$spark$streaming$kafka$KafkaClusterSuite$$topic() {
        return this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topic;
    }

    public TopicAndPartition org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition() {
        return this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition;
    }

    public KafkaCluster org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc() {
        return this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc;
    }

    private void org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc_$eq(KafkaCluster x$1) {
        this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc = x$1;
    }

    public KafkaTestUtils org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils() {
        return this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils;
    }

    private void org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils_$eq(KafkaTestUtils x$1) {
        this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils = x$1;
    }

    public void beforeAll() {
        this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils_$eq(new KafkaTestUtils());
        this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils().setup();
        this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils().createTopic(this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topic());
        this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils().sendMessages(this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))})));
        this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc_$eq(new KafkaCluster((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"metadata.broker.list"), (Object)this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils().brokerAddress())}))));
    }

    public void afterAll() {
        if (this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils() != null) {
            this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils().teardown();
            this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils_$eq(null);
        }
    }

    public KafkaClusterSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topic = new StringBuilder().append((Object)"kcsuitetopic").append((Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(10000))).toString();
        this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition = new TopicAndPartition(this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topic(), 0);
        this.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc = null;
        this.test("metadata apis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2 leader = (Tuple2)((MapLike)this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc().findLeaders((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition()}))).right().get()).apply((Object)this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition());
                String leaderAddress = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leader._1(), BoxesRunTime.boxToInteger((int)leader._2$mcI$sp())}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(leaderAddress);
                String $org_scalatest_assert_macro_right = this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kafkaTestUtils().brokerAddress();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"didn't get leader");
                Set parts = (Set)this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc().getPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topic()}))).right().get();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(parts.apply((Object)this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition()), "parts.apply(KafkaClusterSuite.this.topicAndPartition)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"didn't get partitions");
                Either err = this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc().getPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topic()).append((Object)"BAD").toString()})));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(err.isLeft(), "err.isLeft");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"getPartitions for a nonexistant topic should be an error");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("leader offset apis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map earliest = (Map)this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc().getEarliestLeaderOffsets((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition()}))).right().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((KafkaCluster.LeaderOffset)earliest.apply((Object)this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition())).offset()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"didn't get earliest");
                Map latest = (Map)this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc().getLatestLeaderOffsets((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition()}))).right().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((KafkaCluster.LeaderOffset)latest.apply((Object)this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition())).offset()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"didn't get latest");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("consumer offset apis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaClusterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String group = new StringBuilder().append((Object)"kcsuitegroup").append((Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(10000))).toString();
                int offset = Random$.MODULE$.nextInt(10000);
                Either set = this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc().setConsumerOffsets(group, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition()), (Object)BoxesRunTime.boxToLong((long)offset))})));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(set.isRight(), "set.isRight");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"didn't set consumer offsets");
                Map get = (Map)this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$kc().getConsumerOffsets(group, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition()}))).right().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(get.apply((Object)this.$outer.org$apache$spark$streaming$kafka$KafkaClusterSuite$$topicAndPartition()));
                int $org_scalatest_assert_macro_right = offset;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"didn't get consumer offsets");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

