/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka.producer.utils;

import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.spark.streaming.kafka.producer.utils.EmbeddedKafka;
import org.apache.spark.streaming.kafka.producer.utils.EmbeddedKafka$;
import org.apache.spark.streaming.kafka.producer.utils.EmbeddedZookeeper;
import org.apache.spark.streaming.kafka.producer.utils.EmbeddedZookeeper$;
import org.apache.spark.streaming.kafka.producer.utils.KafkaServerUtil;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;

public abstract class KafkaServerUtil$class {
    public static void beforeAll(KafkaServerUtil $this) {
        $this.zookeeper_$eq(new EmbeddedZookeeper(EmbeddedZookeeper$.MODULE$.$lessinit$greater$default$1(), EmbeddedZookeeper$.MODULE$.$lessinit$greater$default$2()));
        $this.zookeeper().setup();
        $this.zookeeper().start();
        TimeUnit.SECONDS.sleep($this.ServiceStartTimeout());
        Predef$.MODULE$.require($this.zookeeper().server().isRunning(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper should be running on that step";
            }
        });
        $this.kafka_$eq(new EmbeddedKafka($this.zookeeper().zkConnect(), EmbeddedKafka$.MODULE$.$lessinit$greater$default$2()));
        $this.kafka().setup();
        $this.kafka().start();
        TimeUnit.SECONDS.sleep($this.ServiceStartTimeout());
        ZkClient zkClient = ZkUtils$.MODULE$.createZkClient($this.zookeeper().zkConnect(), $this.ZkConnTimeout(), $this.ZkConnTimeout());
        $this.zkUtils_$eq(ZkUtils$.MODULE$.apply(zkClient, false));
    }

    public static void afterAll(KafkaServerUtil $this) {
        Option$.MODULE$.apply((Object)$this.kafka()).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(EmbeddedKafka x$1) {
                x$1.shutdown();
            }
        });
        Option$.MODULE$.apply((Object)$this.zookeeper()).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(EmbeddedZookeeper x$2) {
                x$2.shutdown();
            }
        });
        $this.org$apache$spark$streaming$kafka$producer$utils$KafkaServerUtil$$super$afterAll();
    }

    public static String createTestTopic(KafkaServerUtil $this, String topicId, int nPartitions, int replicationFactor) {
        String topic = new StringBuilder().append((Object)topicId).append((Object)UUID.randomUUID()).toString();
        AdminUtils$.MODULE$.createTopic($this.zkUtils(), topic, nPartitions, replicationFactor, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        TimeUnit.SECONDS.sleep($this.TopicCreateTimeout());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(AdminUtils$.MODULE$.topicExists($this.zkUtils(), topic), "kafka.admin.AdminUtils.topicExists(KafkaServerUtil.this.zkUtils, topic)", Prettifier$.MODULE$.default());
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), Prettifier$.MODULE$.default(), new Position("KafkaServerUtil.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        return topic;
    }

    public static int createTestTopic$default$2(KafkaServerUtil $this) {
        return 1;
    }

    public static int createTestTopic$default$3(KafkaServerUtil $this) {
        return 1;
    }

    public static KafkaConsumer consumerForTopic(KafkaServerUtil $this, String topicId) {
        Properties props = new Properties();
        $this.org$apache$spark$streaming$kafka$producer$utils$KafkaServerUtil$$consumerProperties().foreach((Function1)new Serializable($this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(Tuple2<String, String> prop) {
                return this.props$1.put(prop._1(), prop._2());
            }
            {
                this.props$1 = props$1;
            }
        });
        return new KafkaConsumer(props);
    }

    public static void $init$(KafkaServerUtil $this) {
        $this.zookeeper_$eq(null);
        $this.kafka_$eq(null);
        $this.zkUtils_$eq(null);
        $this.org$apache$spark$streaming$kafka$producer$utils$KafkaServerUtil$_setter_$ZkConnTimeout_$eq(10000);
        $this.org$apache$spark$streaming$kafka$producer$utils$KafkaServerUtil$_setter_$ServiceStartTimeout_$eq(1);
        $this.org$apache$spark$streaming$kafka$producer$utils$KafkaServerUtil$_setter_$TopicCreateTimeout_$eq(1);
        $this.org$apache$spark$streaming$kafka$producer$utils$KafkaServerUtil$_setter_$org$apache$spark$streaming$kafka$producer$utils$KafkaServerUtil$$consumerProperties_$eq((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:9092"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key.deserializer"), (Object)StringDeserializer.class.getCanonicalName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value.deserializer"), (Object)StringDeserializer.class.getCanonicalName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.id"), (Object)"test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"auto.offset.reset"), (Object)"earliest")})));
    }
}

