/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka09;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.python.SerDeUtil;
import org.apache.spark.api.python.SerDeUtil$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.kafka09.ConsumerStrategy;
import org.apache.spark.streaming.kafka09.KafkaRDD;
import org.apache.spark.streaming.kafka09.KafkaUtils$;
import org.apache.spark.streaming.kafka09.KafkaUtilsPythonHelper;
import org.apache.spark.streaming.kafka09.LocationStrategy;
import org.apache.spark.streaming.kafka09.OffsetRange;
import org.apache.spark.streaming.kafka09.OffsetRange$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class KafkaUtilsPythonHelper$ {
    public static KafkaUtilsPythonHelper$ MODULE$;
    private boolean initialized;

    static {
        new KafkaUtilsPythonHelper$();
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    public void initialize() {
        SerDeUtil$.MODULE$.initialize();
        KafkaUtilsPythonHelper$ kafkaUtilsPythonHelper$ = this;
        synchronized (kafkaUtilsPythonHelper$) {
            if (!this.initialized()) {
                new KafkaUtilsPythonHelper.PythonMessageAndMetadataPickler().register();
                this.initialized_$eq(true);
            }
        }
    }

    public Iterator<byte[]> picklerIterator(Iterator<ConsumerRecord<byte[], byte[]>> iter) {
        return new SerDeUtil.AutoBatchedPickler(iter);
    }

    @Experimental
    public JavaDStream<Tuple2<byte[], byte[]>> createDirectStream(JavaStreamingContext jssc, LocationStrategy locationStrategy, ConsumerStrategy<byte[], byte[]> consumerStrategy) {
        DStream dStream = KafkaUtils$.MODULE$.createDirectStream(jssc.ssc(), locationStrategy, consumerStrategy).map((Function1 & Serializable & scala.Serializable)cm -> new Tuple2(cm.key(), cm.value()), ClassTag$.MODULE$.apply(Tuple2.class));
        return new JavaDStream(dStream, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    @Experimental
    public JavaRDD<Tuple2<byte[], byte[]>> createRDDWithoutMessageHandler(JavaSparkContext jsc, Map<String, Object> kafkaParams, List<OffsetRange> offsetRanges, LocationStrategy locationStrategy) {
        RDD rdd = KafkaUtils$.MODULE$.createRDD(jsc.sc(), kafkaParams, (OffsetRange[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(offsetRanges).asScala()).toArray(ClassTag$.MODULE$.apply(OffsetRange.class)), locationStrategy).map((Function1 & Serializable & scala.Serializable)cm -> new Tuple2(cm.key(), cm.value()), ClassTag$.MODULE$.apply(Tuple2.class));
        return new JavaRDD(rdd, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    @Experimental
    public OffsetRange createOffsetRange(String topic, Integer partition, Long fromOffset, Long untilOffset) {
        return OffsetRange$.MODULE$.apply(topic, Predef$.MODULE$.Integer2int(partition), Predef$.MODULE$.Long2long(fromOffset), Predef$.MODULE$.Long2long(untilOffset));
    }

    @Experimental
    public TopicPartition createTopicAndPartition(String topic, Integer partition) {
        return new TopicPartition(topic, Predef$.MODULE$.Integer2int(partition));
    }

    @Experimental
    public List<OffsetRange> offsetRangesOfKafkaRDD(RDD<?> rdd2) {
        Seq parentRDDs = rdd2.getNarrowAncestors();
        Seq kafkaRDDs = (Seq)parentRDDs.filter((Function1 & Serializable & scala.Serializable)rdd -> BoxesRunTime.boxToBoolean((boolean)KafkaUtilsPythonHelper$.$anonfun$offsetRangesOfKafkaRDD$1(rdd)));
        Predef$.MODULE$.require(kafkaRDDs.length() == 1, (Function0 & Serializable & scala.Serializable)() -> "Cannot get offset ranges, as there may be multiple Kafka RDDs or no Kafka RDD associatedwith this RDD, please call this method only on a Kafka RDD.");
        KafkaRDD kafkaRDD = (KafkaRDD)kafkaRDDs.head();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kafkaRDD.offsetRanges())).toSeq()).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$offsetRangesOfKafkaRDD$1(RDD rdd) {
        return rdd instanceof KafkaRDD;
    }

    private KafkaUtilsPythonHelper$() {
        MODULE$ = this;
        this.initialized = false;
        this.initialize();
    }
}

