/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka09;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import kafka.admin.AdminUtils$;
import kafka.api.Request$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.requests.BasePartitionState;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Time;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t%f!B%K\u0001)#\u0006\"B1\u0001\t\u0003\u0019\u0007b\u00024\u0001\u0005\u0004%Ia\u001a\u0005\u0007a\u0002\u0001\u000b\u0011\u00025\t\u000fE\u0004\u0001\u0019!C\u0005e\"9a\u000f\u0001a\u0001\n\u00139\bBB?\u0001A\u0003&1\u000fC\u0004\u007f\u0001\t\u0007I\u0011\u0002:\t\r}\u0004\u0001\u0015!\u0003t\u0011!\t\t\u0001\u0001b\u0001\n\u0013\u0011\bbBA\u0002\u0001\u0001\u0006Ia\u001d\u0005\f\u0003\u000b\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0001C\u0006\u0002|\u0001\u0001\r\u00111A\u0005\n\u0005u\u0004bCA+\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0013A1\"!!\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0004\"Y\u0011Q\u0013\u0001A\u0002\u0003\u0007I\u0011BAL\u0011-\tY\n\u0001a\u0001\u0002\u0003\u0006K!!\"\t\u0011\u0005u\u0005A1A\u0005\n\u001dDq!a(\u0001A\u0003%\u0001\u000e\u0003\u0005\u0002\"\u0002\u0001\r\u0011\"\u0003s\u0011%\t\u0019\u000b\u0001a\u0001\n\u0013\t)\u000bC\u0004\u0002*\u0002\u0001\u000b\u0015B:\t\u0017\u0005-\u0006\u00011AA\u0002\u0013%\u0011Q\u0016\u0005\f\u0003s\u0003\u0001\u0019!a\u0001\n\u0013\tY\fC\u0006\u0002@\u0002\u0001\r\u0011!Q!\n\u0005=\u0006bCA'\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0003D1\"!3\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L\"Y\u0011q\u001a\u0001A\u0002\u0003\u0005\u000b\u0015BAb\u0011-\t\t\u000e\u0001a\u0001\u0002\u0004%I!a5\t\u0017\u0005\u0015\b\u00011AA\u0002\u0013%\u0011q\u001d\u0005\f\u0003W\u0004\u0001\u0019!A!B\u0013\t)\u000eC\u0005\u0002n\u0002\u0001\r\u0011\"\u0003\u0002p\"I\u0011q\u001f\u0001A\u0002\u0013%\u0011\u0011 \u0005\t\u0003{\u0004\u0001\u0015)\u0003\u0002r\"I\u0011q \u0001A\u0002\u0013%\u0011q\u001e\u0005\n\u0005\u0003\u0001\u0001\u0019!C\u0005\u0005\u0007A\u0001Ba\u0002\u0001A\u0003&\u0011\u0011\u001f\u0005\b\u0005\u0013\u0001A\u0011AA\n\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003'AqA!\u0004\u0001\t\u0003\t\u0019\tC\u0004\u0003\u0010\u0001!I!!\u001f\t\u000f\tE\u0001\u0001\"\u0003\u0002z!9!1\u0003\u0001\u0005\u0002\u0005e\u0004b\u0002B\u000b\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0011\u001d\u00119\u0002\u0001C\u0001\u0005GAqAa\n\u0001\t\u0003\u0011I\u0003C\u0004\u0003(\u0001!\tAa\u0011\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003N!9!1\f\u0001\u0005\n\tu\u0003b\u0002B3\u0001\u0011%!Q\f\u0005\b\u0005O\u0002A\u0011\u0001B5\u0011\u001d\u0011y\n\u0001C\u0005\u0005C3a!!\u0004\u0001\t\u0005=\u0001BCA\tk\t\u0015\r\u0011\"\u0001\u0002\u0014!Q\u0011\u0011F\u001b\u0003\u0002\u0003\u0006I!!\u0006\t\r\u0005,D\u0011AA\u0016\u0011%\ty#\u000eb\u0001\n\u0003\t\t\u0004\u0003\u0005\u0002@U\u0002\u000b\u0011BA\u001a\u0011%\t\t%\u000eb\u0001\n\u0003\t\t\u0004\u0003\u0005\u0002DU\u0002\u000b\u0011BA\u001a\u0011%\t)!\u000eb\u0001\n\u0003\t)\u0005\u0003\u0005\u0002VU\u0002\u000b\u0011BA$\u00111\t9&\u000eI\u0001\u0002\u0007\u0005\u000b\u0011BA-\u0011!\ty&\u000eb\u0001\n\u00039\u0007bBA1k\u0001\u0006I\u0001\u001b\u0005\t\u0003G*$\u0019!C\u0001e\"9\u0011QM\u001b!\u0002\u0013\u0019\b\"CA4k\t\u0007I\u0011AA5\u0011!\t\t(\u000eQ\u0001\n\u0005-\u0004\u0002CA:k\t\u0007I\u0011\u0001:\t\u000f\u0005UT\u0007)A\u0005g\"9\u0011qO\u001b\u0005\u0002\u0005e$AD&bM.\fG+Z:u+RLGn\u001d\u0006\u0003\u00172\u000bqa[1gW\u0006\u0004\u0014H\u0003\u0002N\u001d\u0006I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u001fB\u000bQa\u001d9be.T!!\u0015*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0016aA8sON\u0019\u0001!V.\u0011\u0005YKV\"A,\u000b\u0003a\u000bQa]2bY\u0006L!AW,\u0003\r\u0005s\u0017PU3g!\tav,D\u0001^\u0015\tqf*\u0001\u0005j]R,'O\\1m\u0013\t\u0001WLA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\u001a\t\u0003K\u0002i\u0011AS\u0001\u0007u.Dun\u001d;\u0016\u0003!\u0004\"!\u001b8\u000e\u0003)T!a\u001b7\u0002\t1\fgn\u001a\u0006\u0002[\u0006!!.\u0019<b\u0013\ty'N\u0001\u0004TiJLgnZ\u0001\bu.Dun\u001d;!\u0003\u0019Q8\u000eU8siV\t1\u000f\u0005\u0002Wi&\u0011Qo\u0016\u0002\u0004\u0013:$\u0018A\u0003>l!>\u0014Ho\u0018\u0013fcR\u0011\u0001p\u001f\t\u0003-fL!A_,\u0003\tUs\u0017\u000e\u001e\u0005\by\u0016\t\t\u00111\u0001t\u0003\rAH%M\u0001\bu.\u0004vN\u001d;!\u0003MQ8nQ8o]\u0016\u001cG/[8o)&lWm\\;u\u0003QQ8nQ8o]\u0016\u001cG/[8o)&lWm\\;uA\u0005\u0001\"p[*fgNLwN\u001c+j[\u0016|W\u000f^\u0001\u0012u.\u001cVm]:j_:$\u0016.\\3pkR\u0004\u0013!\u0003>p_.,W\r]3s+\t\tI\u0001E\u0002\u0002\fUj\u0011\u0001\u0001\u0002\u0012\u000b6\u0014W\r\u001a3fIj{wn[3fa\u0016\u00148CA\u001bV\u0003%Q8nQ8o]\u0016\u001cG/\u0006\u0002\u0002\u0016A!\u0011qCA\u0013\u001d\u0011\tI\"!\t\u0011\u0007\u0005mq+\u0004\u0002\u0002\u001e)\u0019\u0011q\u00042\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019cV\u0001\u0007!J,G-\u001a4\n\u0007=\f9CC\u0002\u0002$]\u000b!B_6D_:tWm\u0019;!)\u0011\tI!!\f\t\u000f\u0005E\u0001\b1\u0001\u0002\u0016\u0005Y1O\\1qg\"|G\u000fR5s+\t\t\u0019\u0004\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tI\u0004\\\u0001\u0003S>LA!!\u0010\u00028\t!a)\u001b7f\u00031\u0019h.\u00199tQ>$H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004SCAA$!\u0011\tI%!\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\naa]3sm\u0016\u0014(bAA\u0003!&!\u00111KA&\u0005=Qvn\\&fKB,'oU3sm\u0016\u0014\u0018A\u0003>p_.,W\r]3sA\u0005\u0019\u0001\u0010\n\u001a\u0011\u000bY\u000bY\u0006[:\n\u0007\u0005usK\u0001\u0004UkBdWMM\u0001\u0003SB\f1!\u001b9!\u0003\u0011\u0001xN\u001d;\u0002\u000bA|'\u000f\u001e\u0011\u0002\u000f\u0019\f7\r^8ssV\u0011\u00111\u000e\t\u0005\u0003\u0013\ni'\u0003\u0003\u0002p\u0005-#\u0001\u0006(J\u001fN+'O^3s\u0007:DhNR1di>\u0014\u00180\u0001\u0005gC\u000e$xN]=!\u0003)\t7\r^;bYB{'\u000f^\u0001\fC\u000e$X/\u00197Q_J$\b%\u0001\u0005tQV$Hm\\<o)\u0005A\u0018!\u0004>p_.,W\r]3s?\u0012*\u0017\u000fF\u0002y\u0003\u007fB\u0001\u0002 \u0007\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\bu.,F/\u001b7t+\t\t)\t\u0005\u0003\u0002\b\u0006EUBAAE\u0015\u0011\tY)!$\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u0005=\u0015!B6bM.\f\u0017\u0002BAJ\u0003\u0013\u0013qAW6Vi&d7/A\u0006{WV#\u0018\u000e\\:`I\u0015\fHc\u0001=\u0002\u001a\"AApDA\u0001\u0002\u0004\t))\u0001\u0005{WV#\u0018\u000e\\:!\u0003)\u0011'o\\6fe\"{7\u000f^\u0001\fEJ|7.\u001a:I_N$\b%\u0001\u0006ce>\\WM\u001d)peR\faB\u0019:pW\u0016\u0014\bk\u001c:u?\u0012*\u0017\u000fF\u0002y\u0003OCq\u0001 \u000b\u0002\u0002\u0003\u00071/A\u0006ce>\\WM\u001d)peR\u0004\u0013A\u00032s_.,'oQ8oMV\u0011\u0011q\u0016\t\u0005\u0003c\u000b),\u0004\u0002\u00024*!\u0011QJAG\u0013\u0011\t9,a-\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000fEJ|7.\u001a:D_:4w\fJ3r)\rA\u0018Q\u0018\u0005\ty^\t\t\u00111\u0001\u00020\u0006Y!M]8lKJ\u001cuN\u001c4!+\t\t\u0019\r\u0005\u0003\u00022\u0006\u0015\u0017\u0002BAd\u0003g\u00131bS1gW\u0006\u001cVM\u001d<fe\u0006Q1/\u001a:wKJ|F%Z9\u0015\u0007a\fi\r\u0003\u0005}5\u0005\u0005\t\u0019AAb\u0003\u001d\u0019XM\u001d<fe\u0002\n\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0003\u0003+\u0004\u0002\"a6\u0002b\u0006U\u0011QC\u0007\u0003\u00033TA!!5\u0002\\*!\u0011Q\\Ap\u0003\u001d\u0019G.[3oiNT1!a$Q\u0013\u0011\t\u0019/!7\u0003\u001b-\u000bgm[1Qe>$WoY3s\u00031\u0001(o\u001c3vG\u0016\u0014x\fJ3r)\rA\u0018\u0011\u001e\u0005\tyv\t\t\u00111\u0001\u0002V\u0006I\u0001O]8ek\u000e,'\u000fI\u0001\bu.\u0014V-\u00193z+\t\t\t\u0010E\u0002W\u0003gL1!!>X\u0005\u001d\u0011un\u001c7fC:\f1B_6SK\u0006$\u0017p\u0018\u0013fcR\u0019\u00010a?\t\u0011q\u0004\u0013\u0011!a\u0001\u0003c\f\u0001B_6SK\u0006$\u0017\u0010I\u0001\fEJ|7.\u001a:SK\u0006$\u00170A\bce>\\WM\u001d*fC\u0012Lx\fJ3r)\rA(Q\u0001\u0005\ty\u000e\n\t\u00111\u0001\u0002r\u0006a!M]8lKJ\u0014V-\u00193zA\u0005I!p[!eIJ,7o]\u0001\u000eEJ|7.\u001a:BI\u0012\u0014Xm]:\u0002\u001fi|wn[3fa\u0016\u00148\t\\5f]R\fac]3ukB,UNY3eI\u0016$'l\\8lK\u0016\u0004XM]\u0001\u0019g\u0016$X\u000f]#nE\u0016$G-\u001a3LC\u001a\\\u0017mU3sm\u0016\u0014\u0018!B:fiV\u0004\u0018\u0001\u0003;fCJ$wn\u001e8\u0002\u0017\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u000b\u0006q\nm!q\u0004\u0005\b\u0005;a\u0003\u0019AA\u000b\u0003\u0015!x\u000e]5d\u0011\u0019\u0011\t\u0003\fa\u0001g\u0006Q\u0001/\u0019:uSRLwN\\:\u0015\u0007a\u0014)\u0003C\u0004\u0003\u001e5\u0002\r!!\u0006\u0002\u0019M,g\u000eZ'fgN\fw-Z:\u0015\u000ba\u0014YC!\f\t\u000f\tua\u00061\u0001\u0002\u0016!9!q\u0006\u0018A\u0002\tE\u0012!D7fgN\fw-\u001a+p\rJ,\u0017\u000f\u0005\u0005\u00034\te\u0012Q\u0003B\u001f\u001b\t\u0011)DC\u0002\u000381\fA!\u001e;jY&!!1\bB\u001b\u0005\ri\u0015\r\u001d\t\u0004S\n}\u0012b\u0001B!U\n9\u0011J\u001c;fO\u0016\u0014H#\u0002=\u0003F\t\u001d\u0003b\u0002B\u000f_\u0001\u0007\u0011Q\u0003\u0005\b\u0005_y\u0003\u0019\u0001B%!\u001d\t9Ba\u0013\u0002\u0016MLAAa\u000f\u0002(Q)\u0001Pa\u0014\u0003R!9!Q\u0004\u0019A\u0002\u0005U\u0001b\u0002B*a\u0001\u0007!QK\u0001\t[\u0016\u001c8/Y4fgB)aKa\u0016\u0002\u0016%\u0019!\u0011L,\u0003\u000b\u0005\u0013(/Y=\u0002'\t\u0014xn[3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0005\t}\u0003\u0003\u0002B\u001a\u0005CJAAa\u0019\u00036\tQ\u0001K]8qKJ$\u0018.Z:\u0002+A\u0014x\u000eZ;dKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006QQM^3oiV\fG\u000e\\=\u0016\t\t-$1\u000f\u000b\u0007\u0005[\u0012yIa'\u0015\t\t=$Q\u0011\t\u0005\u0005c\u0012\u0019\b\u0004\u0001\u0005\u000f\tU4G1\u0001\u0003x\t\tA+\u0005\u0003\u0003z\t}\u0004c\u0001,\u0003|%\u0019!QP,\u0003\u000f9{G\u000f[5oOB\u0019aK!!\n\u0007\t\ruKA\u0002B]fD\u0001Ba\"4\t\u0003\u0007!\u0011R\u0001\u0005MVt7\rE\u0003W\u0005\u0017\u0013y'C\u0002\u0003\u000e^\u0013\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0005#\u001b\u0004\u0019\u0001BJ\u0003\u001d!\u0018.\\3pkR\u0004BA!&\u0003\u00186\tA*C\u0002\u0003\u001a2\u0013A\u0001V5nK\"9!QT\u001aA\u0002\tM\u0015\u0001C5oi\u0016\u0014h/\u00197\u0002;]\f\u0017\u000e^+oi&dW*\u001a;bI\u0006$\u0018-S:Qe>\u0004\u0018mZ1uK\u0012$R\u0001\u001fBR\u0005KCqA!\b5\u0001\u0004\t)\u0002\u0003\u0004\u0003(R\u0002\ra]\u0001\na\u0006\u0014H/\u001b;j_:\u0004")
public class KafkaTestUtils
implements Logging {
    private final String zkHost;
    private int zkPort;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private EmbeddedZookeeper zookeeper;
    private ZkUtils zkUtils;
    private final String brokerHost;
    private int brokerPort;
    private KafkaConfig brokerConf;
    private KafkaServer server;
    private KafkaProducer<String, String> producer;
    private boolean zkReady;
    private boolean brokerReady;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String zkHost() {
        return this.zkHost;
    }

    private int zkPort() {
        return this.zkPort;
    }

    private void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    private int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    private int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    private EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    private void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    private int brokerPort() {
        return this.brokerPort;
    }

    private void brokerPort_$eq(int x$1) {
        this.brokerPort = x$1;
    }

    private KafkaConfig brokerConf() {
        return this.brokerConf;
    }

    private void brokerConf_$eq(KafkaConfig x$1) {
        this.brokerConf = x$1;
    }

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    private KafkaProducer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<String, String> x$1) {
        this.producer = x$1;
    }

    private boolean zkReady() {
        return this.zkReady;
    }

    private void zkReady_$eq(boolean x$1) {
        this.zkReady = x$1;
    }

    private boolean brokerReady() {
        return this.brokerReady;
    }

    private void brokerReady_$eq(boolean x$1) {
        this.brokerReady = x$1;
    }

    public String zkAddress() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0 & Serializable & scala.Serializable)() -> "Zookeeper not setup yet or already torn down, cannot get zookeeper address");
        return new StringBuilder(1).append(this.zkHost()).append(":").append(this.zkPort()).toString();
    }

    public String brokerAddress() {
        Predef$.MODULE$.assert(this.brokerReady(), (Function0 & Serializable & scala.Serializable)() -> "Kafka not setup yet or already torn down, cannot get broker address");
        return new StringBuilder(1).append(this.brokerHost()).append(":").append(this.brokerPort()).toString();
    }

    public ZkUtils zookeeperClient() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0 & Serializable & scala.Serializable)() -> "Zookeeper not setup yet or already torn down, cannot get zookeeper client");
        return (ZkUtils)Option$.MODULE$.apply((Object)this.zkUtils()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Zookeeper client is not yet initialized");
        });
    }

    private void setupEmbeddedZookeeper() {
        this.zookeeper_$eq(new EmbeddedZookeeper(this, new StringBuilder(1).append(this.zkHost()).append(":").append(this.zkPort()).toString()));
        this.zkPort_$eq(this.zookeeper().actualPort());
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(new StringBuilder(1).append(this.zkHost()).append(":").append(this.zkPort()).toString(), this.zkSessionTimeout(), this.zkConnectionTimeout(), false));
        this.zkReady_$eq(true);
    }

    private void setupEmbeddedKafkaServer() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0 & Serializable & scala.Serializable)() -> "Zookeeper should be set up beforehand");
        Utils$.MODULE$.startServiceOnPort(this.brokerPort(), (Function1 & Serializable & scala.Serializable)port -> KafkaTestUtils.$anonfun$setupEmbeddedKafkaServer$2(this, BoxesRunTime.unboxToInt((Object)port)), new SparkConf(), "KafkaBroker");
        this.brokerReady_$eq(true);
    }

    public void setup() {
        this.setupEmbeddedZookeeper();
        this.setupEmbeddedKafkaServer();
    }

    public void teardown() {
        block3: {
            this.brokerReady_$eq(false);
            this.zkReady_$eq(false);
            if (this.producer() != null) {
                this.producer().close();
                this.producer_$eq(null);
            }
            if (this.server() != null) {
                this.server().shutdown();
                this.server().awaitShutdown();
                this.server_$eq(null);
            }
            this.brokerConf().logDirs().foreach((Function1 & Serializable & scala.Serializable)f -> {
                KafkaTestUtils.$anonfun$teardown$1(this, f);
                return BoxedUnit.UNIT;
            });
            if (this.zkUtils() != null) {
                this.zkUtils().close();
                this.zkUtils_$eq(null);
            }
            if (this.zookeeper() == null) break block3;
            this.zookeeper().shutdown();
            this.zookeeper_$eq(null);
        }
    }

    public void createTopic(String topic, int partitions) {
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, partitions, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)p -> this.waitUntilMetadataIsPropagated(topic, p));
    }

    public void createTopic(String topic) {
        this.createTopic(topic, 1);
    }

    public void sendMessages(String topic, Map<String, Integer> messageToFreq) {
        this.sendMessages(topic, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(messageToFreq).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1)).toSeq())));
    }

    public void sendMessages(String topic, scala.collection.immutable.Map<String, Object> messageToFreq) {
        String[] messages = (String[])((TraversableOnce)messageToFreq.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String s = (String)tuple2._1();
            int freq = tuple2._2$mcI$sp();
            Seq seq = (Seq)Seq$.MODULE$.fill(freq, (Function0 & Serializable & scala.Serializable)() -> s);
            return seq;
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        this.sendMessages(topic, messages);
    }

    public void sendMessages(String topic, String[] messages) {
        this.producer_$eq((KafkaProducer<String, String>)new KafkaProducer(this.producerConfiguration()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).foreach((Function1 & Serializable & scala.Serializable)message -> this.producer().send(new ProducerRecord(topic, message)));
        this.producer().close();
        this.producer_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    private Properties brokerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("broker.id", "0");
        props.put("host.name", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)this.brokerPort())).toString());
        props.put("log.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath());
        props.put("zookeeper.connect", this.zkAddress());
        props.put("log.flush.interval.messages", "1");
        props.put("replica.socket.timeout.ms", "1500");
        props.put("offsets.topic.replication.factor", "1");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties producerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerAddress());
        props.put("value.serializer", StringSerializer.class.getName());
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("acks", "all");
        return var1_1;
    }

    public <T> T eventually(Time timeout, Time interval, Function0<T> func) {
        long startTime = System.currentTimeMillis();
        return (T)this.tryAgain$1(1, startTime, timeout, interval, func);
    }

    private void waitUntilMetadataIsPropagated(String topic, int partition) {
        this.eventually(new Time(10000L), new Time(100L), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.assert(this.isPropagated$1(topic, partition), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Partition [").append(topic).append(", ").append(partition).append("] metadata not propagated after timeout").toString()));
    }

    public static final /* synthetic */ Tuple2 $anonfun$setupEmbeddedKafkaServer$2(KafkaTestUtils $this, int port) {
        $this.brokerPort_$eq(port);
        $this.brokerConf_$eq(new KafkaConfig((Map)$this.brokerConfiguration(), false));
        $this.server_$eq(new KafkaServer($this.brokerConf(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4()));
        $this.server().startup();
        $this.brokerPort_$eq($this.server().boundPort($this.brokerConf().interBrokerListenerName()));
        return new Tuple2((Object)$this.server(), (Object)BoxesRunTime.boxToInteger((int)$this.brokerPort()));
    }

    public static final /* synthetic */ void $anonfun$teardown$1(KafkaTestUtils $this, String f) {
        try {
            Utils$.MODULE$.deleteRecursively(new File(f));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                if (Utils$.MODULE$.isWindows()) {
                    $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> iOException.getMessage());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            throw throwable;
        }
    }

    private static final Either makeAttempt$1(Function0 func$1) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply(func$1.apply());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!NonFatal$.MODULE$.apply(throwable2)) {
                throw throwable;
            }
            Left left = package$.MODULE$.Left().apply((Object)throwable2);
            right = left;
        }
        return right;
    }

    private final Object tryAgain$1(int attempt, long startTime$1, Time timeout$1, Time interval$1, Function0 func$1) {
        Object result;
        Either either;
        block2: {
            while (true) {
                if ((either = KafkaTestUtils.makeAttempt$1(func$1)) instanceof Right) break block2;
                if (!(either instanceof Left)) break;
                Left left = (Left)either;
                Throwable e = (Throwable)left.value();
                long duration = System.currentTimeMillis() - startTime$1;
                if (duration >= timeout$1.milliseconds()) {
                    throw new TimeoutException(e.getMessage());
                }
                Thread.sleep(interval$1.milliseconds());
                ++attempt;
            }
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        Object object = result = right.value();
        return object;
    }

    private final boolean isPropagated$1(String topic$3, int partition$1) {
        boolean bl;
        Option option = this.server().apis().metadataCache().getPartitionInfo(topic$3, partition$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)some.value();
            BasePartitionState leaderAndInSyncReplicas = partitionState.basePartitionState;
            bl = this.zkUtils().getLeaderForPartition(topic$3, partition$1).isDefined() && Request$.MODULE$.isValidBrokerId(leaderAndInSyncReplicas.leader) && leaderAndInSyncReplicas.isr.size() >= 1;
        } else {
            bl = false;
        }
        return bl;
    }

    public KafkaTestUtils() {
        Logging.$init$((Logging)this);
        this.zkHost = "localhost";
        this.zkPort = 0;
        this.zkConnectionTimeout = 60000;
        this.zkSessionTimeout = 6000;
        this.brokerHost = "localhost";
        this.brokerPort = 0;
        this.zkReady = false;
        this.brokerReady = false;
    }

    public class EmbeddedZookeeper {
        private final String zkConnect;
        private final File snapshotDir;
        private final File logDir;
        private final ZooKeeperServer zookeeper;
        private final /* synthetic */ Tuple2 x$2;
        private final String ip;
        private final int port;
        private final NIOServerCnxnFactory factory;
        private final int actualPort;
        public final /* synthetic */ KafkaTestUtils $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public File snapshotDir() {
            return this.snapshotDir;
        }

        public File logDir() {
            return this.logDir;
        }

        public ZooKeeperServer zookeeper() {
            return this.zookeeper;
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public NIOServerCnxnFactory factory() {
            return this.factory;
        }

        public int actualPort() {
            return this.actualPort;
        }

        public void shutdown() {
            this.factory().shutdown();
            try {
                Utils$.MODULE$.deleteRecursively(this.snapshotDir());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException) {
                    IOException iOException = (IOException)throwable2;
                    if (Utils$.MODULE$.isWindows()) {
                        this.org$apache$spark$streaming$kafka09$KafkaTestUtils$EmbeddedZookeeper$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> iOException.getMessage());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
            try {
                Utils$.MODULE$.deleteRecursively(this.logDir());
            }
            catch (Throwable throwable) {
                Throwable throwable3 = throwable;
                if (throwable3 instanceof IOException) {
                    IOException iOException = (IOException)throwable3;
                    if (Utils$.MODULE$.isWindows()) {
                        this.org$apache$spark$streaming$kafka09$KafkaTestUtils$EmbeddedZookeeper$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> iOException.getMessage());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
        }

        public /* synthetic */ KafkaTestUtils org$apache$spark$streaming$kafka09$KafkaTestUtils$EmbeddedZookeeper$$$outer() {
            return this.$outer;
        }

        public EmbeddedZookeeper(KafkaTestUtils $outer, String zkConnect) {
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.snapshotDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), 500);
            String[] splits = zkConnect.split(":");
            Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String ip = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port));
            this.x$2 = tuple22;
            this.ip = (String)this.x$2._1();
            this.port = this.x$2._2$mcI$sp();
            this.factory = new NIOServerCnxnFactory();
            this.factory().configure(new InetSocketAddress(this.ip(), this.port()), 16);
            this.factory().startup(this.zookeeper());
            this.actualPort = this.factory().getLocalPort();
        }
    }
}

