/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka09;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka09.CanCommitOffsets;
import org.apache.spark.streaming.kafka09.ConsumerStrategy;
import org.apache.spark.streaming.kafka09.KafkaRDD;
import org.apache.spark.streaming.kafka09.KafkaUtils$;
import org.apache.spark.streaming.kafka09.LocationStrategy;
import org.apache.spark.streaming.kafka09.OffsetRange;
import org.apache.spark.streaming.kafka09.OffsetRange$;
import org.apache.spark.streaming.kafka09.PerPartitionConfig;
import org.apache.spark.streaming.kafka09.PreferBrokers$;
import org.apache.spark.streaming.kafka09.PreferConsistent$;
import org.apache.spark.streaming.kafka09.PreferFixed;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r=a!B\u001b7\u0001i\u0002\u0005\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u0011M\u0004!\u0011!Q\u0001\nQD\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\tw\u0002\u0011\t\u0011)A\u0005y\"1q\u0010\u0001C\u0001\u0003\u0003A\u0011\"!\u0004\u0001\u0005\u0004%\t!a\u0004\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003#A\u0011\"!\u0012\u0001\u0001\u0004%\t\"a\u0012\t\u0013\u0005-\u0004\u00011A\u0005\u0012\u00055\u0004\u0002CA=\u0001\u0001\u0006K!!\u0013\t\u0013\u0005m\u0004\u00011A\u0005\n\u0005u\u0004\"CAC\u0001\u0001\u0007I\u0011BAD\u0011!\tY\t\u0001Q!\n\u0005}\u0004BB&\u0001\t\u0003\t)\nC\u0005\u0002\u0018\u0002\u0001\r\u0011\"\u0003\u0002~!I\u0011\u0011\u0014\u0001A\u0002\u0013%\u00111\u0014\u0005\t\u0003?\u0003\u0001\u0015)\u0003\u0002\u0000!9\u00111\u0015\u0001\u0005\u0002\u0005u\u0004bBAS\u0001\u0011\u0005\u0013q\u0015\u0005\b\u0003\u007f\u0003A\u0011CAa\u0011\u001d\t)\r\u0001C\t\u0003\u000fD\u0001\"!4\u0001\t\u0003B\u0014q\u001a\u0005\u000b\u0003#\u0004!\u0019!C)q\u0005M\u0007\u0002\u0003B\u000f\u0001\u0001\u0006I!!6\t\u0015\t}\u0001A1A\u0005Ra\u0012\t\u0003\u0003\u0005\u00036\u0001\u0001\u000b\u0011\u0002B\u0012\u0011!\u00119\u0004\u0001C\tq\te\u0002b\u0002B#\u0001\u0011%!q\t\u0005\b\u0005\u001b\u0002A\u0011\u0002B(\u0011\u001d\u00119\b\u0001C\t\u0005sBqAa\u001f\u0001\t#\u0011i\bC\u0004\u0003\u0002\u0002!\tEa!\t\u000f\tE\u0005\u0001\"\u0011\u0003\u001c!9!1\u0013\u0001\u0005B\tm\u0001\"\u0003BK\u0001\t\u0007I\u0011\u0003BL\u0011!\u0011Y\u000b\u0001Q\u0001\n\te\u0005\"\u0003BW\u0001\t\u0007I\u0011\u0003BX\u0011!\u0011\u0019\r\u0001Q\u0001\n\tE\u0006b\u0002Bc\u0001\u0011\u0005!q\u0019\u0005\b\u0005\u000b\u0004A\u0011\u0001Bh\u0011\u001d\u00119\u000e\u0001C\t\u000571q!!7\u0001\u0001a\nY\u000e\u0003\u0004\u0000U\u0011\u0005\u00111\u001d\u0005\b\u0003KTC\u0011AAt\u0011\u001d\u0011YA\u000bC!\u0005\u001bAqAa\u0005+\t\u0003\u0012)\u0002C\u0004\u0003\u001a)\"\tEa\u0007\u0007\u000f\te\u0007\u0001\u0001\u001d\u0003\\\"a!Q\u001c\u0019\u0003\u0002\u0003\u0006IA!\u0002\u0003`\"Q!1\u001d\u0019\u0003\u0002\u0003\u0006IA!:\t\r}\u0004D\u0011\u0001By\u0011\u001d\u0011I\u0010\rC!\u0005w\u0014q\u0003R5sK\u000e$8*\u00194lC&s\u0007/\u001e;E'R\u0014X-Y7\u000b\u0005]B\u0014aB6bM.\f\u0007'\u000f\u0006\u0003si\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005mb\u0014!B:qCJ\\'BA\u001f?\u0003\u0019\t\u0007/Y2iK*\tq(A\u0002pe\u001e,2!\u0011+c'\u0011\u0001!\t\u001a6\u0011\u0007\r3\u0005*D\u0001E\u0015\t)\u0005(A\u0004egR\u0014X-Y7\n\u0005\u001d#%\u0001D%oaV$Hi\u0015;sK\u0006l\u0007\u0003B%Q%\u0006l\u0011A\u0013\u0006\u0003\u00172\u000b\u0001bY8ogVlWM\u001d\u0006\u0003\u001b:\u000bqa\u00197jK:$8O\u0003\u0002Py\u0005)1.\u00194lC&\u0011\u0011K\u0013\u0002\u000f\u0007>t7/^7feJ+7m\u001c:e!\t\u0019F\u000b\u0004\u0001\u0005\u000bU\u0003!\u0019A,\u0003\u0003-\u001b\u0001!\u0005\u0002Y=B\u0011\u0011\fX\u0007\u00025*\t1,A\u0003tG\u0006d\u0017-\u0003\u0002^5\n9aj\u001c;iS:<\u0007CA-`\u0013\t\u0001'LA\u0002B]f\u0004\"a\u00152\u0005\u000b\r\u0004!\u0019A,\u0003\u0003Y\u0003\"!\u001a5\u000e\u0003\u0019T!a\u001a\u001e\u0002\u0011%tG/\u001a:oC2L!!\u001b4\u0003\u000f1{wmZ5oOB\u00111\u000e\\\u0007\u0002m%\u0011QN\u000e\u0002\u0011\u0007\u0006t7i\\7nSR|eMZ:fiN\fAaX:tGB\u0011\u0001/]\u0007\u0002q%\u0011!\u000f\u000f\u0002\u0011'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqR\f\u0001\u0003\\8dCRLwN\\*ue\u0006$XmZ=\u0011\u0005-,\u0018B\u0001<7\u0005AaunY1uS>t7\u000b\u001e:bi\u0016<\u00170\u0001\td_:\u001cX/\\3s'R\u0014\u0018\r^3hsB!1.\u001f*b\u0013\tQhG\u0001\tD_:\u001cX/\\3s'R\u0014\u0018\r^3hs\u0006\u0019\u0001\u000f]2\u0011\u0005-l\u0018B\u0001@7\u0005I\u0001VM\u001d)beRLG/[8o\u0007>tg-[4\u0002\rqJg.\u001b;?))\t\u0019!!\u0002\u0002\b\u0005%\u00111\u0002\t\u0005W\u0002\u0011\u0016\rC\u0003o\u000b\u0001\u0007q\u000eC\u0003t\u000b\u0001\u0007A\u000fC\u0003x\u000b\u0001\u0007\u0001\u0010C\u0003|\u000b\u0001\u0007A0A\nfq\u0016\u001cW\u000f^8s\u0017\u000647.\u0019)be\u0006l7/\u0006\u0002\u0002\u0012AA\u00111CA\u000f\u0003C\t9$\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u0011)H/\u001b7\u000b\u0005\u0005m\u0011\u0001\u00026bm\u0006LA!a\b\u0002\u0016\t9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA\u0012\u0003cqA!!\n\u0002.A\u0019\u0011q\u0005.\u000e\u0005\u0005%\"bAA\u0016-\u00061AH]8pizJ1!a\f[\u0003\u0019\u0001&/\u001a3fM&!\u00111GA\u001b\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0006.\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQA!!\u0010\u0002\u001a\u0005!A.\u00198h\u0013\u0011\t\t%a\u000f\u0003\r=\u0013'.Z2u\u0003Q)\u00070Z2vi>\u00148*\u00194lCB\u000b'/Y7tA\u0005q1-\u001e:sK:$xJ\u001a4tKR\u001cXCAA%!!\tY%!\u0016\u0002Z\u0005\u0015TBAA'\u0015\u0011\ty%!\u0015\u0002\u0013%lW.\u001e;bE2,'bAA*5\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0013Q\n\u0002\u0004\u001b\u0006\u0004\b\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}c*\u0001\u0004d_6lwN\\\u0005\u0005\u0003G\niF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0007e\u000b9'C\u0002\u0002ji\u0013A\u0001T8oO\u0006\u00112-\u001e:sK:$xJ\u001a4tKR\u001cx\fJ3r)\u0011\ty'!\u001e\u0011\u0007e\u000b\t(C\u0002\u0002ti\u0013A!\u00168ji\"I\u0011qO\u0005\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u0004q\u0012\n\u0014aD2veJ,g\u000e^(gMN,Go\u001d\u0011\u0002\u0005-\u001cWCAA@!\u0015I\u0015\u0011\u0011*b\u0013\r\t\u0019I\u0013\u0002\t\u0007>t7/^7fe\u000611nY0%KF$B!a\u001c\u0002\n\"I\u0011q\u000f\u0007\u0002\u0002\u0003\u0007\u0011qP\u0001\u0004W\u000e\u0004\u0003fA\u0007\u0002\u0010B\u0019\u0011,!%\n\u0007\u0005M%LA\u0005ue\u0006t7/[3oiR\u0011\u0011qP\u0001\u0003g\u000e\faa]2`I\u0015\fH\u0003BA8\u0003;C\u0011\"a\u001e\u0011\u0003\u0003\u0005\r!a \u0002\u0007M\u001c\u0007\u0005K\u0002\u0012\u0003\u001f\u000bqb]3sm&\u001cWmQ8ogVlWM]\u0001\ba\u0016\u00148/[:u)\u0011\tI+a,\u0011\t\r\u000bY\u000bS\u0005\u0004\u0003[#%a\u0002#TiJ,\u0017-\u001c\u0005\b\u0003c\u001b\u0002\u0019AAZ\u0003!qWm\u001e'fm\u0016d\u0007\u0003BA[\u0003wk!!a.\u000b\u0007\u0005e&(A\u0004ti>\u0014\u0018mZ3\n\t\u0005u\u0016q\u0017\u0002\r'R|'/Y4f\u0019\u00164X\r\\\u0001\u000bO\u0016$(I]8lKJ\u001cXCAAb!!\t\u0019\"!\b\u0002Z\u0005\u0005\u0012!E4fiB\u0013XMZ3se\u0016$\u0007j\\:ugV\u0011\u0011\u0011\u001a\t\t\u0003'\tY-!\u0017\u0002\"%!\u0011qKA\u000b\u0003\u0011q\u0017-\\3\u0016\u0005\u0005\u0005\u0012AD2iK\u000e\\\u0007o\\5oi\u0012\u000bG/Y\u000b\u0003\u0003+\u00042!a6+\u001b\u0005\u0001!!\n#je\u0016\u001cGoS1gW\u0006Le\u000e];u\tN#(/Z1n\u0007\",7m\u001b9pS:$H)\u0019;b'\rQ\u0013Q\u001c\t\u0005\u0007\u0006}\u0007*C\u0002\u0002b\u0012\u0013Q\u0003R*ue\u0016\fWn\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018\r\u0006\u0002\u0002V\u0006a!-\u0019;dQ\u001a{'\u000fV5nKV\u0011\u0011\u0011\u001e\t\t\u0003W\f\t0a=\u0002z6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f\t&A\u0004nkR\f'\r\\3\n\t\u0005}\u0011Q\u001e\t\u0004a\u0006U\u0018bAA|q\t!A+[7f!\u0015I\u00161`A\u0000\u0013\r\tiP\u0017\u0002\u0006\u0003J\u0014\u0018-\u001f\t\f3\n\u0005\u0011\u0011\u0005B\u0003\u0003K\n)'C\u0002\u0003\u0004i\u0013a\u0001V;qY\u0016$\u0004cA-\u0003\b%\u0019!\u0011\u0002.\u0003\u0007%sG/\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003_\u0012y\u0001C\u0004\u0003\u00125\u0002\r!a=\u0002\tQLW.Z\u0001\bG2,\u0017M\\;q)\u0011\tyGa\u0006\t\u000f\tEa\u00061\u0001\u0002t\u00069!/Z:u_J,GCAA8\u0003=\u0019\u0007.Z2la>Lg\u000e\u001e#bi\u0006\u0004\u0013A\u0004:bi\u0016\u001cuN\u001c;s_2dWM]\u000b\u0003\u0005G\u0001R!\u0017B\u0013\u0005SI1Aa\n[\u0005\u0019y\u0005\u000f^5p]B!!1\u0006B\u0019\u001b\t\u0011iCC\u0002\u00030a\n\u0011b]2iK\u0012,H.\u001a:\n\t\tM\"Q\u0006\u0002\u000f%\u0006$XmQ8oiJ|G\u000e\\3s\u0003=\u0011\u0018\r^3D_:$(o\u001c7mKJ\u0004\u0013aF7bq6+7o]1hKN\u0004VM\u001d)beRLG/[8o)\u0011\u0011YD!\u0011\u0011\u000be\u0013)C!\u0010\u0011\u0011\u0005\r\"qHA-\u0003KJA!a\u0016\u00026!9!1I\u000eA\u0002\tu\u0012aB8gMN,Go]\u0001\ra\u0006\u0014\u0018M\\8jIB{G\u000e\u001c\u000b\u0005\u0003_\u0012I\u0005C\u0004\u0003Lq\u0001\r!a \u0002\u0003\r\f1b^5uQJ+GO]5fgV!!\u0011\u000bB,)\u0011\u0011\u0019F!\u001a\u0015\t\tU#1\f\t\u0004'\n]CA\u0002B-;\t\u0007qKA\u0001U\u0011!\u0011i&\bCA\u0002\t}\u0013!\u00014\u0011\u000be\u0013\tG!\u0016\n\u0007\t\r$L\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\u00119'\ba\u0001\u0003K\n\u0011\u0001\u001e\u0015\u0004;\t-\u0004\u0003\u0002B7\u0005gj!Aa\u001c\u000b\u0007\tE$,\u0001\u0006b]:|G/\u0019;j_:LAA!\u001e\u0003p\t9A/Y5me\u0016\u001c\u0017!\u00047bi\u0016\u001cHo\u00144gg\u0016$8\u000f\u0006\u0002\u0003>\u0005)1\r\\1naR!!Q\bB@\u0011\u001d\u0011\u0019e\ba\u0001\u0005{\tqaY8naV$X\r\u0006\u0003\u0003\u0006\n5\u0005#B-\u0003&\t\u001d\u0005#B6\u0003\nJ\u000b\u0017b\u0001BFm\tA1*\u00194lCJ#E\tC\u0004\u0003\u0010\u0002\u0002\r!a=\u0002\u0013Y\fG.\u001b3US6,\u0017!B:uCJ$\u0018\u0001B:u_B\f1bY8n[&$\u0018+^3vKV\u0011!\u0011\u0014\t\u0007\u00057\u0013\tK!*\u000e\u0005\tu%\u0002\u0002BP\u0003+\t!bY8oGV\u0014(/\u001a8u\u0013\u0011\u0011\u0019K!(\u0003+\r{gnY;se\u0016tG\u000fT5oW\u0016$\u0017+^3vKB\u00191Na*\n\u0007\t%fGA\u0006PM\u001a\u001cX\r\u001e*b]\u001e,\u0017\u0001D2p[6LG/U;fk\u0016\u0004\u0013AD2p[6LGoQ1mY\n\f7m[\u000b\u0003\u0005c\u0003bAa-\u0003:\nuVB\u0001B[\u0015\u0011\u00119L!(\u0002\r\u0005$x.\\5d\u0013\u0011\u0011YL!.\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u00042!\u0013B`\u0013\r\u0011\tM\u0013\u0002\u0015\u001f\u001a47/\u001a;D_6l\u0017\u000e^\"bY2\u0014\u0017mY6\u0002\u001f\r|W.\\5u\u0007\u0006dGNY1dW\u0002\n1bY8n[&$\u0018i]=oGR!\u0011q\u000eBe\u0011\u001d\u0011Ym\na\u0001\u0005\u001b\fAb\u001c4gg\u0016$(+\u00198hKN\u0004R!WA~\u0005K#b!a\u001c\u0003R\nM\u0007b\u0002BfQ\u0001\u0007!Q\u001a\u0005\b\u0005+D\u0003\u0019\u0001B_\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0017!C2p[6LG/\u00117m\u0005e!\u0015N]3di.\u000bgm[1SCR,7i\u001c8ue>dG.\u001a:\u0014\u0007A\u0012I#\u0001\u0002jI&!!\u0011\u001dB\u0019\u0003%\u0019HO]3b[VKE)A\u0005fgRLW.\u0019;peB!!q\u001dBw\u001b\t\u0011IO\u0003\u0003\u0003l\n5\u0012\u0001\u0002:bi\u0016LAAa<\u0003j\ni!+\u0019;f\u000bN$\u0018.\\1u_J$bAa=\u0003v\n]\bcAAla!9!Q\\\u001aA\u0002\t\u0015\u0001b\u0002Brg\u0001\u0007!Q]\u0001\baV\u0014G.[:i)\u0011\tyG!@\t\u000f\t-H\u00071\u0001\u0002f!:\u0001a!\u0001\u0004\b\r-\u0001cA-\u0004\u0004%\u00191Q\u0001.\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0004\n\u00051Sk]3!W\u000647.Y\u00191AA\f7m[1hK\u0002Jgn\u001d;fC\u0012\u0004sN\u001a\u0011lC\u001a\\\u0017\rM\u001d\"\u0005\r5\u0011\u0001E'baJ\u00033\u000b]1sW6\u0012df\r\u00183\u0001")
public class DirectKafkaInputDStream<K, V>
extends InputDStream<ConsumerRecord<K, V>>
implements CanCommitOffsets {
    private final LocationStrategy locationStrategy;
    private final ConsumerStrategy<K, V> consumerStrategy;
    private final PerPartitionConfig ppc;
    private final HashMap<String, Object> executorKafkaParams;
    private scala.collection.immutable.Map<TopicPartition, Object> currentOffsets;
    private transient Consumer<K, V> kc;
    private transient Consumer<K, V> sc;
    private final DirectKafkaInputDStreamCheckpointData checkpointData;
    private final Option<RateController> rateController;
    private final ConcurrentLinkedQueue<OffsetRange> commitQueue;
    private final AtomicReference<OffsetCommitCallback> commitCallback;

    public HashMap<String, Object> executorKafkaParams() {
        return this.executorKafkaParams;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> currentOffsets() {
        return this.currentOffsets;
    }

    public void currentOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.currentOffsets = x$1;
    }

    private Consumer<K, V> kc() {
        return this.kc;
    }

    private void kc_$eq(Consumer<K, V> x$1) {
        this.kc = x$1;
    }

    public synchronized Consumer<K, V> consumer() {
        block0: {
            if (this.kc() != null) break block0;
            this.kc_$eq(this.consumerStrategy.onStart((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.currentOffsets().mapValues((Function1 & Serializable & scala.Serializable)l -> DirectKafkaInputDStream.$anonfun$consumer$1(BoxesRunTime.unboxToLong((Object)l)))).asJava()));
        }
        return this.kc();
    }

    private Consumer<K, V> sc() {
        return this.sc;
    }

    private void sc_$eq(Consumer<K, V> x$1) {
        this.sc = x$1;
    }

    public synchronized Consumer<K, V> serviceConsumer() {
        block0: {
            if (this.sc() != null) break block0;
            this.sc_$eq(this.consumerStrategy.serviceConsumer());
        }
        return this.sc();
    }

    public DStream<ConsumerRecord<K, V>> persist(StorageLevel newLevel) {
        this.logError((Function0 & Serializable & scala.Serializable)() -> "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window");
        return super.persist(newLevel);
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<TopicPartition, String> getBrokers() {
        void var2_2;
        Consumer<K, V> c = this.consumer();
        HashMap result = new HashMap();
        HashMap<TopicPartition, String> hosts = new HashMap<TopicPartition, String>();
        for (TopicPartition tp : c.assignment()) {
            if (hosts.get(tp) == null) {
                for (PartitionInfo i : c.partitionsFor(tp.topic())) {
                    hosts.put(new TopicPartition(i.topic(), i.partition()), i.leader().host());
                }
            }
            result.put(tp, hosts.get(tp));
        }
        return var2_2;
    }

    public java.util.Map<TopicPartition, String> getPreferredHosts() {
        java.util.Map<Object, String> map;
        LocationStrategy locationStrategy = this.locationStrategy;
        if (PreferBrokers$.MODULE$.equals(locationStrategy)) {
            map = this.getBrokers();
        } else if (PreferConsistent$.MODULE$.equals(locationStrategy)) {
            map = Collections.emptyMap();
        } else if (locationStrategy instanceof PreferFixed) {
            PreferFixed preferFixed = (PreferFixed)locationStrategy;
            java.util.Map<TopicPartition, String> hostMap = preferFixed.hostMap();
            map = hostMap;
        } else {
            throw new MatchError((Object)locationStrategy);
        }
        return map;
    }

    public String name() {
        return new StringBuilder(26).append("Kafka 0.9 direct stream [").append(this.id()).append("]").toString();
    }

    public DirectKafkaInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    public Option<RateController> rateController() {
        return this.rateController;
    }

    public Option<scala.collection.immutable.Map<TopicPartition, Object>> maxMessagesPerPartition(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        None$ none$;
        scala.collection.immutable.Map map;
        Option estimatedRateLimit = this.rateController().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getLatestRate()));
        Option option = estimatedRateLimit.filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 > 0L);
        if (option instanceof Some) {
            Some some = (Some)option;
            long rate = BoxesRunTime.unboxToLong((Object)some.value());
            scala.collection.immutable.Map lagPerPartition = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long offset = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max(offset - BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp)), 0L)));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            long totalLag = BoxesRunTime.unboxToLong((Object)lagPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            map = (scala.collection.immutable.Map)lagPerPartition.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long lag = tuple2._2$mcJ$sp();
                long maxRateLimitPerPartition = $this.ppc.maxRatePerPartition(tp);
                int backpressureRate = Math.round((float)((double)lag / (double)totalLag) * (float)rate);
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)(maxRateLimitPerPartition > 0L ? BoxesRunTime.boxToLong((long)Math.min((long)backpressureRate, maxRateLimitPerPartition)) : BoxesRunTime.boxToLong((long)backpressureRate)));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            map = (scala.collection.immutable.Map)offsets.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)$this.ppc.maxRatePerPartition(tp)));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)option);
        }
        scala.collection.immutable.Map effectiveRateLimitPerPartition = map;
        if (BoxesRunTime.unboxToLong((Object)effectiveRateLimitPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) > 0L) {
            double secsPerBatch = (double)this.context().graph().batchDuration().milliseconds() / (double)1000;
            none$ = new Some(effectiveRateLimitPerPartition.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long limit = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)((long)(secsPerBatch * (double)limit))));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void paranoidPoll(Consumer<K, V> c) {
        block1: {
            java.util.Set parts;
            ConsumerRecords msgs = c.poll(0L);
            java.util.Set newAssignment = c.assignment();
            java.util.Set set = parts = this.currentOffsets().size() < newAssignment.size() ? newAssignment : (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava();
            if (this.serviceConsumer().assignment().size() < parts.size()) {
                this.serviceConsumer().assign((Collection)parts);
            }
            if (msgs.isEmpty()) break block1;
            long waitingForAssigmentTimeout = SparkEnv$.MODULE$.get().conf().getLong("spark.mapr.WaitingForAssignmentTimeout", 600000L);
            ((IterableLike)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)msgs).asScala()).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(acc, m) -> {
                TopicPartition tp = new TopicPartition(m.topic(), m.partition());
                long off = BoxesRunTime.unboxToLong((Object)acc.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)o -> Math.min(o, m.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> m.offset()));
                return acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)off)));
            })).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DirectKafkaInputDStream.$anonfun$paranoidPoll$4(this, waitingForAssigmentTimeout, c, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private <T> T withRetries(long t, Function0<T> f) {
        Object v;
        Try try_;
        block2: {
            while (true) {
                if ((try_ = Try$.MODULE$.apply(f)) instanceof Success) break block2;
                if (t <= 0L) break;
                Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(500L));
                t -= 500L;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Object object = v = success.value();
        return (T)object;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> latestOffsets() {
        scala.collection.mutable.Set parts;
        block2: {
            Consumer<K, V> c = this.consumer();
            this.paranoidPoll(c);
            parts = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala();
            if (parts.size() < this.currentOffsets().keySet().size()) {
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Assignment() returned fewer partitions than the previous call");
            }
            if (this.serviceConsumer().assignment().size() < parts.size()) {
                this.serviceConsumer().assign((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(parts).asJava());
            }
            scala.collection.mutable.Set newPartitions = (scala.collection.mutable.Set)parts.diff((GenSet)this.currentOffsets().keySet());
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)this.currentOffsets().$plus$plus((GenTraversableOnce)((TraversableOnce)newPartitions.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)this.serviceConsumer().position(tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
            c.pause((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(newPartitions).asJava());
            if (this.serviceConsumer().assignment().isEmpty()) break block2;
            this.serviceConsumer().seekToEnd((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
        }
        return ((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)this.serviceConsumer().position(tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, Object> clamp(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        return (scala.collection.immutable.Map)this.maxMessagesPerPartition(offsets).map((Function1 & Serializable & scala.Serializable)mmp -> (scala.collection.immutable.Map)mmp.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long messages = tuple2._2$mcJ$sp();
            long uo = BoxesRunTime.unboxToLong((Object)offsets.apply((Object)tp));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.min(BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp)) + messages, uo)));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> offsets);
    }

    public Option<KafkaRDD<K, V>> compute(Time validTime) {
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = this.clamp(this.latestOffsets());
        Iterable offsetRanges = (Iterable)untilOffsets.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long uo = tuple2._2$mcJ$sp();
            long fo = BoxesRunTime.unboxToLong((Object)this.currentOffsets().apply((Object)tp));
            OffsetRange offsetRange = OffsetRange$.MODULE$.apply(tp.topic(), tp.partition(), fo, uo);
            return offsetRange;
        }, Iterable$.MODULE$.canBuildFrom());
        boolean useConsumerCache = this.context().conf().getBoolean("spark.streaming.kafka.consumer.cache.enabled", true);
        KafkaRDD rdd = new KafkaRDD(this.context().sparkContext(), this.executorKafkaParams(), (OffsetRange[])offsetRanges.toArray(ClassTag$.MODULE$.apply(OffsetRange.class)), this.getPreferredHosts(), useConsumerCache);
        String description = ((TraversableOnce)((TraversableLike)offsetRanges.filter((Function1 & Serializable & scala.Serializable)offsetRange -> BoxesRunTime.boxToBoolean((boolean)DirectKafkaInputDStream.$anonfun$compute$2(offsetRange)))).map((Function1 & Serializable & scala.Serializable)offsetRange -> new StringBuilder(33).append("topic: ").append(offsetRange.topic()).append("\tpartition: ").append(offsetRange.partition()).append("\t").append("offsets: ").append(offsetRange.fromOffset()).append(" to ").append(offsetRange.untilOffset()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString("\n");
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsets"), (Object)offsetRanges.toList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), (Object)description)}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), rdd.count(), metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        this.currentOffsets_$eq(untilOffsets);
        this.commitAll();
        return new Some(rdd);
    }

    public void start() {
        Consumer c = this.consumer();
        this.paranoidPoll(c);
        if (this.currentOffsets().isEmpty()) {
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToLong((long)c.position(tp))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        c.pause((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
    }

    public synchronized void stop() {
        if (this.kc() != null) {
            this.kc().close();
        }
        this.serviceConsumer().close();
    }

    public ConcurrentLinkedQueue<OffsetRange> commitQueue() {
        return this.commitQueue;
    }

    public AtomicReference<OffsetCommitCallback> commitCallback() {
        return this.commitCallback;
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges) {
        this.commitAsync(offsetRanges, null);
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges, OffsetCommitCallback callback) {
        this.commitCallback().set(callback);
        this.commitQueue().addAll(Arrays.asList((Object[])offsetRanges));
    }

    public void commitAll() {
        block3: {
            HashMap<TopicPartition, OffsetAndMetadata> m = new HashMap<TopicPartition, OffsetAndMetadata>();
            OffsetRange osr = this.commitQueue().poll();
            while (osr != null) {
                TopicPartition tp = osr.topicPartition();
                OffsetAndMetadata x = (OffsetAndMetadata)m.get(tp);
                long offset = x == null ? osr.untilOffset() : Math.max(x.offset(), osr.untilOffset());
                m.put(tp, new OffsetAndMetadata(offset));
                osr = this.commitQueue().poll();
            }
            if (m.isEmpty()) break block3;
            if (KafkaUtils$.MODULE$.isStreams(this.currentOffsets())) {
                this.serviceConsumer().commitAsync(m, this.commitCallback().get());
            } else {
                this.consumer().commitAsync(m, this.commitCallback().get());
            }
        }
    }

    public static final /* synthetic */ Long $anonfun$consumer$1(long l) {
        return new Long(l);
    }

    public static final /* synthetic */ void $anonfun$paranoidPoll$4(DirectKafkaInputDStream $this, long waitingForAssigmentTimeout$1, Consumer c$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        long off = tuple2._2$mcJ$sp();
        $this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("poll(0) returned messages, seeking ").append(tp).append(" to ").append(off).append(" to compensate").toString());
        $this.serviceConsumer().seek(tp, off);
        BoxedUnit boxedUnit = (BoxedUnit)$this.withRetries(waitingForAssigmentTimeout$1, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> c$1.seek(tp, off));
    }

    public static final /* synthetic */ boolean $anonfun$compute$2(OffsetRange offsetRange) {
        return offsetRange.fromOffset() != offsetRange.untilOffset();
    }

    public DirectKafkaInputDStream(StreamingContext _ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy, PerPartitionConfig ppc) {
        this.locationStrategy = locationStrategy;
        this.consumerStrategy = consumerStrategy;
        this.ppc = ppc;
        super(_ssc, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        HashMap<String, Object> ekp = new HashMap<String, Object>(consumerStrategy.executorKafkaParams());
        KafkaUtils$.MODULE$.fixKafkaParams(ekp);
        this.executorKafkaParams = ekp;
        this.currentOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.kc = null;
        this.sc = null;
        this.checkpointData = new DirectKafkaInputDStreamCheckpointData();
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some((Object)new DirectKafkaRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.context().graph().batchDuration()))) : None$.MODULE$;
        this.commitQueue = new ConcurrentLinkedQueue();
        this.commitCallback = new AtomicReference();
    }

    public class DirectKafkaInputDStreamCheckpointData
    extends DStreamCheckpointData<ConsumerRecord<K, V>> {
        public scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> batchForTime() {
            return this.data();
        }

        public void update(Time time) {
            this.batchForTime().clear();
            this.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().foreach((Function1 & Serializable & scala.Serializable)kv -> {
                Tuple4[] a = (Tuple4[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((KafkaRDD)kv._2()).offsetRanges())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toTuple(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class))))).toArray(ClassTag$.MODULE$.apply(Tuple4.class));
                return this.batchForTime().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)a));
            });
        }

        public void cleanup(Time time) {
        }

        public void restore() {
            ((IterableLike)this.batchForTime().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$4 -> (Time)x$4._1(), Time$.MODULE$.ordering())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Time t = (Time)tuple2._1();
                Tuple4[] b = (Tuple4[])tuple2._2();
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Restoring KafkaRDD for time ").append(t).append(" ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).mkString("[", ", ", "]")).toString());
                scala.collection.mutable.HashMap hashMap = this.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), new KafkaRDD(this.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().context().sparkContext(), this.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().executorKafkaParams(), (OffsetRange[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).map((Function1 & Serializable & scala.Serializable)x$5 -> OffsetRange$.MODULE$.apply((Tuple4<String, Object, Object, Object>)x$5), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OffsetRange.class))), this.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().getPreferredHosts(), false)));
                return hashMap;
            });
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaInputDStreamCheckpointData() {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super((DStream)DirectKafkaInputDStream.this, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        }
    }

    public class DirectKafkaRateController
    extends RateController {
        public void publish(long rate) {
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaRateController$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaRateController(int id, RateEstimator estimator) {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }
}

