/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka09;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.streaming.kafka09.HasOffsetRanges;
import org.apache.spark.streaming.kafka09.KafkaRDD;
import org.apache.spark.streaming.kafka09.KafkaTestUtils;
import org.apache.spark.streaming.kafka09.KafkaUtils$;
import org.apache.spark.streaming.kafka09.LocationStrategies$;
import org.apache.spark.streaming.kafka09.LocationStrategy;
import org.apache.spark.streaming.kafka09.OffsetRange;
import org.apache.spark.streaming.kafka09.OffsetRange$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u000154Aa\u0004\t\u00017!)a\u0005\u0001C\u0001O!I!\u0006\u0001a\u0001\u0002\u0004%Ia\u000b\u0005\n_\u0001\u0001\r\u00111A\u0005\nAB\u0011\"\u000f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0017\t\u000fi\u0002!\u0019!C\u0005w!1q\b\u0001Q\u0001\nqB\u0011\u0002\u0011\u0001A\u0002\u0003\u0007I\u0011B!\t\u0013\u0015\u0003\u0001\u0019!a\u0001\n\u00131\u0005\"\u0003%\u0001\u0001\u0004\u0005\t\u0015)\u0003C\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u0015Y\u0005\u0001\"\u0011K\u0011\u0015a\u0005\u0001\"\u0003N\u0011\u001d9\u0007A1A\u0005\n!Da\u0001\u001c\u0001!\u0002\u0013I'!D&bM.\f'\u000b\u0012#Tk&$XM\u0003\u0002\u0012%\u000591.\u00194lCBJ$BA\n\u0015\u0003%\u0019HO]3b[&twM\u0003\u0002\u0016-\u0005)1\u000f]1sW*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u000f!!\tib$D\u0001\u0015\u0013\tyBCA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003C\u0011j\u0011A\t\u0006\u0003Ga\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005\u0015\u0012#!\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]!mY\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011\u0001E\u0001\u000fW\u000647.\u0019+fgR,F/\u001b7t+\u0005a\u0003CA\u0015.\u0013\tq\u0003C\u0001\bLC\u001a\\\u0017\rV3tiV#\u0018\u000e\\:\u0002%-\fgm[1UKN$X\u000b^5mg~#S-\u001d\u000b\u0003c]\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012A!\u00168ji\"9\u0001hAA\u0001\u0002\u0004a\u0013a\u0001=%c\u0005y1.\u00194lCR+7\u000f^+uS2\u001c\b%A\u0005ta\u0006\u00148nQ8oMV\tA\b\u0005\u0002\u001e{%\u0011a\b\u0006\u0002\n'B\f'o[\"p]\u001a\f!b\u001d9be.\u001cuN\u001c4!\u0003\t\u00198-F\u0001C!\ti2)\u0003\u0002E)\ta1\u000b]1sW\u000e{g\u000e^3yi\u000611oY0%KF$\"!M$\t\u000faB\u0011\u0011!a\u0001\u0005\u0006\u00191o\u0019\u0011\u0002\u0013\t,gm\u001c:f\u00032dG#A\u0019\u0002\u0011\u00054G/\u001a:BY2\fabZ3u\u0017\u000647.\u0019)be\u0006l7\u000fF\u0001O!\u0011yEKV1\u000e\u0003AS!!\u0015*\u0002\tU$\u0018\u000e\u001c\u0006\u0002'\u0006!!.\u0019<b\u0013\t)\u0006KA\u0002NCB\u0004\"a\u00160\u000f\u0005ac\u0006CA-4\u001b\u0005Q&BA.\u001b\u0003\u0019a$o\\8u}%\u0011QlM\u0001\u0007!J,G-\u001a4\n\u0005}\u0003'AB*ue&twM\u0003\u0002^gA\u0011!-Z\u0007\u0002G*\u0011AMU\u0001\u0005Y\u0006tw-\u0003\u0002gG\n1qJ\u00196fGR\fa\u0002\u001d:fM\u0016\u0014(/\u001a3I_N$8/F\u0001j!\tI#.\u0003\u0002l!\t\u0001Bj\\2bi&|gn\u0015;sCR,w-_\u0001\u0010aJ,g-\u001a:sK\u0012Dun\u001d;tA\u0001")
public class KafkaRDDSuite
extends SparkFunSuite {
    private KafkaTestUtils kafkaTestUtils;
    private final SparkConf sparkConf = new SparkConf().setMaster("local[4]").setAppName(this.getClass().getSimpleName());
    private SparkContext sc;
    private final LocationStrategy preferredHosts = LocationStrategies$.MODULE$.PreferConsistent();

    private KafkaTestUtils kafkaTestUtils() {
        return this.kafkaTestUtils;
    }

    private void kafkaTestUtils_$eq(KafkaTestUtils x$1) {
        this.kafkaTestUtils = x$1;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public void beforeAll() {
        this.sc_$eq(new SparkContext(this.sparkConf()));
        this.kafkaTestUtils_$eq(new KafkaTestUtils());
        this.kafkaTestUtils().setup();
    }

    public void afterAll() {
        block1: {
            if (this.sc() != null) {
                this.sc().stop();
                this.sc_$eq(null);
            }
            if (this.kafkaTestUtils() == null) break block1;
            this.kafkaTestUtils().teardown();
            this.kafkaTestUtils_$eq(null);
        }
    }

    private java.util.Map<String, Object> getKafkaParams() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.kafkaTestUtils().brokerAddress()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key.deserializer"), StringDeserializer.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value.deserializer"), StringDeserializer.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.id"), (Object)new StringBuilder(15).append("test-consumer-").append(Random$.MODULE$.nextInt()).append("-").append(System.currentTimeMillis()).toString())}))).asJava();
    }

    private LocationStrategy preferredHosts() {
        return this.preferredHosts;
    }

    public static final /* synthetic */ long $anonfun$new$6(OffsetRange o) {
        return o.untilOffset() - o.fromOffset();
    }

    public KafkaRDDSuite() {
        this.test("basic usage", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD emptyRdd;
            String topic = new StringBuilder(12).append("topicbasic-").append(Random$.MODULE$.nextInt()).append("-").append(System.currentTimeMillis()).toString();
            this.kafkaTestUtils().createTopic(topic);
            String[] messages = (String[])((Object[])new String[]{"the", "quick", "brown", "fox"});
            this.kafkaTestUtils().sendMessages(topic, messages);
            java.util.Map<String, Object> kafkaParams = this.getKafkaParams();
            OffsetRange[] offsetRanges = (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, 0L, (long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size())});
            RDD rdd = KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, offsetRanges, this.preferredHosts()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.value(), ClassTag$.MODULE$.apply(String.class));
            Set received = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.collect())).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(received);
            Set $org_scalatest_assert_macro_right = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count()));
            int $org_scalatest_assert_macro_right2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((BoundedDouble)rdd.countApprox(0L, rdd.countApprox$default$2()).getFinalValue()).mean()));
            int $org_scalatest_assert_macro_right3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            RDD $org_scalatest_assert_macro_left4 = rdd;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.take(1))).size()));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.take(1))).head());
            String $org_scalatest_assert_macro_right5 = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.take(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size() + 10))).size()));
            int $org_scalatest_assert_macro_right6 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            RDD $org_scalatest_assert_macro_left8 = emptyRdd = KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, 0L, 0L)}), this.preferredHosts());
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            OffsetRange[] badRanges = (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, 0L, (long)(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])messages)).size() + 1))});
            return (SparkException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String[] stringArray = (String[])KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, badRanges, this.preferredHosts()).map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.value(), ClassTag$.MODULE$.apply(String.class)).collect();
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        }, new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("iterator boundary conditions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String topic = new StringBuilder(15).append("topicboundary-").append(Random$.MODULE$.nextInt()).append("-").append(System.currentTimeMillis()).toString();
            scala.collection.immutable.Map sent = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)10))}));
            this.kafkaTestUtils().createTopic(topic);
            java.util.Map<String, Object> kafkaParams = this.getKafkaParams();
            this.kafkaTestUtils().sendMessages(topic, sent);
            int sentCount = BoxesRunTime.unboxToInt((Object)sent.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            RDD rdd = KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, 0L, (long)sentCount)}), this.preferredHosts());
            OffsetRange[] ranges = ((HasOffsetRanges)rdd).offsetRanges();
            long rangeCount = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ranges)).map((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToLong((long)KafkaRDDSuite.$anonfun$new$6(o)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)rangeCount));
            int $org_scalatest_assert_macro_right = sentCount;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"offset range didn't include all sent messages", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])rdd.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.offset()), ClassTag$.MODULE$.Long()).collect())).sorted((Ordering)Ordering.Long$.MODULE$));
            int[] $org_scalatest_assert_macro_right2 = (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sentCount).toArray(ClassTag$.MODULE$.Int());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"didn't get all sent messages", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            RDD rdd2 = KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, (long)sentCount, (long)sentCount)}), this.preferredHosts());
            scala.collection.immutable.Map sentOnlyOne = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            this.kafkaTestUtils().sendMessages(topic, sentOnlyOne);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd2.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.value(), ClassTag$.MODULE$.apply(String.class)).collect())).size()));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"got messages when there shouldn't be any", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            RDD rdd3 = KafkaUtils$.MODULE$.createRDD(this.sc(), kafkaParams, (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply(topic, 0, (long)sentCount, (long)(sentCount + 1))}), this.preferredHosts());
            this.kafkaTestUtils().sendMessages(topic, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"extra"), (Object)BoxesRunTime.boxToInteger((int)22))})));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd3.map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.value(), ClassTag$.MODULE$.apply(String.class)).collect())).head());
            String $org_scalatest_assert_macro_right4 = (String)sentOnlyOne.keys().head();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"didn't get exactly one message", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }, new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("executor sorting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            HashMap<String, Object> kafkaParams = new HashMap<String, Object>(this.getKafkaParams());
            kafkaParams.put("auto.offset.reset", "none");
            KafkaRDD rdd = new KafkaRDD(this.sc(), kafkaParams, (OffsetRange[])((Object[])new OffsetRange[]{OffsetRange$.MODULE$.apply("unused", 0, 1L, 2L)}), Collections.emptyMap(), true);
            ExecutorCacheTaskLocation a3 = new ExecutorCacheTaskLocation("a", "3");
            ExecutorCacheTaskLocation a4 = new ExecutorCacheTaskLocation("a", "4");
            ExecutorCacheTaskLocation b1 = new ExecutorCacheTaskLocation("b", "1");
            ExecutorCacheTaskLocation b2 = new ExecutorCacheTaskLocation("b", "2");
            ExecutorCacheTaskLocation[] correct = (ExecutorCacheTaskLocation[])((Object[])new ExecutorCacheTaskLocation[]{b2, b1, a4, a3});
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])correct)).permutations().foreach((Function1 & Serializable & scala.Serializable)p -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p)).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)rdd.compareExecutors(a, b))));
                ExecutorCacheTaskLocation[] $org_scalatest_assert_macro_right = correct;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            });
        }, new Position("KafkaRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
    }
}

