/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka09;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka09.CanCommitOffsets;
import org.apache.spark.streaming.kafka09.ConsumerStrategy;
import org.apache.spark.streaming.kafka09.DirectKafkaInputDStream$;
import org.apache.spark.streaming.kafka09.KafkaRDD;
import org.apache.spark.streaming.kafka09.KafkaUtils$;
import org.apache.spark.streaming.kafka09.LocationStrategy;
import org.apache.spark.streaming.kafka09.OffsetRange;
import org.apache.spark.streaming.kafka09.OffsetRange$;
import org.apache.spark.streaming.kafka09.PerPartitionConfig;
import org.apache.spark.streaming.kafka09.PreferBrokers$;
import org.apache.spark.streaming.kafka09.PreferConsistent$;
import org.apache.spark.streaming.kafka09.PreferFixed;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t}f!B\u0001\u0003\u0001\u0019a!a\u0006#je\u0016\u001cGoS1gW\u0006Le\u000e];u\tN#(/Z1n\u0015\t\u0019A!A\u0004lC\u001a\\\u0017\rM\u001d\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<WcA\u0007!]M!\u0001A\u0004\u00197!\ry!\u0003F\u0007\u0002!)\u0011\u0011\u0003B\u0001\bIN$(/Z1n\u0013\t\u0019\u0002C\u0001\u0007J]B,H\u000fR*ue\u0016\fW\u000e\u0005\u0003\u00169yiS\"\u0001\f\u000b\u0005]A\u0012\u0001C2p]N,X.\u001a:\u000b\u0005eQ\u0012aB2mS\u0016tGo\u001d\u0006\u00037!\tQa[1gW\u0006L!!\b\f\u0003\u001d\r{gn];nKJ\u0014VmY8sIB\u0011q\u0004\t\u0007\u0001\t\u0015\t\u0003A1\u0001$\u0005\u0005Y5\u0001A\t\u0003I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012qAT8uQ&tw\r\u0005\u0002&W%\u0011AF\n\u0002\u0004\u0003:L\bCA\u0010/\t\u0015y\u0003A1\u0001$\u0005\u00051\u0006CA\u00195\u001b\u0005\u0011$BA\u001a\u0007\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001b3\u0005\u001daunZ4j]\u001e\u0004\"a\u000e\u001d\u000e\u0003\tI!!\u000f\u0002\u0003!\r\u000bgnQ8n[&$xJ\u001a4tKR\u001c\b\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\t}\u001b8o\u0019\t\u0003{yj\u0011\u0001B\u0005\u0003\u007f\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011\u0005\u0003!\u0011!Q\u0001\n\t\u000b\u0001\u0003\\8dCRLwN\\*ue\u0006$XmZ=\u0011\u0005]\u001a\u0015B\u0001#\u0003\u0005AaunY1uS>t7\u000b\u001e:bi\u0016<\u0017\u0010\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0003A\u0019wN\\:v[\u0016\u00148\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u00038\u0011zi\u0013BA%\u0003\u0005A\u0019uN\\:v[\u0016\u00148\u000b\u001e:bi\u0016<\u0017\u0010\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0003\r\u0001\bo\u0019\t\u0003o5K!A\u0014\u0002\u0003%A+'\u000fU1si&$\u0018n\u001c8D_:4\u0017n\u001a\u0005\u0006!\u0002!\t!U\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bI\u001bF+\u0016,\u0011\t]\u0002a$\f\u0005\u0006w=\u0003\r\u0001\u0010\u0005\u0006\u0003>\u0003\rA\u0011\u0005\u0006\r>\u0003\ra\u0012\u0005\u0006\u0017>\u0003\r\u0001\u0014\u0005\b1\u0002\u0011\r\u0011\"\u0001Z\u0003M)\u00070Z2vi>\u00148*\u00194lCB\u000b'/Y7t+\u0005Q\u0006\u0003B.aE&l\u0011\u0001\u0018\u0006\u0003;z\u000bA!\u001e;jY*\tq,\u0001\u0003kCZ\f\u0017BA1]\u0005\u001dA\u0015m\u001d5NCB\u0004\"a\u00194\u000f\u0005\u0015\"\u0017BA3'\u0003\u0019\u0001&/\u001a3fM&\u0011q\r\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u00154\u0003C\u00016n\u001b\u0005Y'B\u00017_\u0003\u0011a\u0017M\\4\n\u00059\\'AB(cU\u0016\u001cG\u000f\u0003\u0004q\u0001\u0001\u0006IAW\u0001\u0015Kb,7-\u001e;pe.\u000bgm[1QCJ\fWn\u001d\u0011\t\u000fI\u0004\u0001\u0019!C\tg\u0006q1-\u001e:sK:$xJ\u001a4tKR\u001cX#\u0001;\u0011\u000bUTH0!\u0002\u000e\u0003YT!a\u001e=\u0002\u0013%lW.\u001e;bE2,'BA='\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003wZ\u00141!T1q!\ri\u0018\u0011A\u0007\u0002}*\u0011qPG\u0001\u0007G>lWn\u001c8\n\u0007\u0005\raP\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0007\u0015\n9!C\u0002\u0002\n\u0019\u0012A\u0001T8oO\"I\u0011Q\u0002\u0001A\u0002\u0013E\u0011qB\u0001\u0013GV\u0014(/\u001a8u\u001f\u001a47/\u001a;t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0012\u0005]\u0001cA\u0013\u0002\u0014%\u0019\u0011Q\u0003\u0014\u0003\tUs\u0017\u000e\u001e\u0005\n\u00033\tY!!AA\u0002Q\f1\u0001\u001f\u00132\u0011\u001d\ti\u0002\u0001Q!\nQ\fqbY;se\u0016tGo\u00144gg\u0016$8\u000f\t\u0005\n\u0003C\u0001\u0001\u0019!C\u0005\u0003G\t!a[2\u0016\u0005\u0005\u0015\u0002#B\u000b\u0002(yi\u0013bAA\u0015-\tA1i\u001c8tk6,'\u000fC\u0005\u0002.\u0001\u0001\r\u0011\"\u0003\u00020\u000511nY0%KF$B!!\u0005\u00022!Q\u0011\u0011DA\u0016\u0003\u0003\u0005\r!!\n\t\u0011\u0005U\u0002\u0001)Q\u0005\u0003K\t1a[2!Q\u0011\t\u0019$!\u000f\u0011\u0007\u0015\nY$C\u0002\u0002>\u0019\u0012\u0011\u0002\u001e:b]NLWM\u001c;\t\r]\u0001A\u0011AA!)\t\t)\u0003C\u0004\u0002F\u0001!\t%a\u0012\u0002\u000fA,'o]5tiR!\u0011\u0011JA(!\u0011y\u00111\n\u000b\n\u0007\u00055\u0003CA\u0004E'R\u0014X-Y7\t\u0011\u0005E\u00131\ta\u0001\u0003'\n\u0001B\\3x\u0019\u00164X\r\u001c\t\u0005\u0003+\nY&\u0004\u0002\u0002X)\u0019\u0011\u0011\f\u0004\u0002\u000fM$xN]1hK&!\u0011QLA,\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0011\u001d\t\t\u0007\u0001C\t\u0003G\n!bZ3u\u0005J|7.\u001a:t+\t\t)\u0007\u0005\u0003\\Ar\u0014\u0007bBA5\u0001\u0011E\u00111N\u0001\u0012O\u0016$\bK]3gKJ\u0014X\r\u001a%pgR\u001cXCAA7!\u0015Y\u0016q\u000e?c\u0013\tYH\f\u0003\u0005\u0002t\u0001!\t\u0005BA;\u0003\u0011q\u0017-\\3\u0016\u0003\tD!\"!\u001f\u0001\u0005\u0004%\t\u0006BA>\u00039\u0019\u0007.Z2la>Lg\u000e\u001e#bi\u0006,\"!! \u0011\t\u0005}\u0014\u0011Q\u0007\u0002\u0001\u00199\u00111\u0011\u0001\u0001\t\u0005\u0015%!\n#je\u0016\u001cGoS1gW\u0006Le\u000e];u\tN#(/Z1n\u0007\",7m\u001b9pS:$H)\u0019;b'\u0011\t\t)a\"\u0011\t=\tI\tF\u0005\u0004\u0003\u0017\u0003\"!\u0006#TiJ,\u0017-\\\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u0005\b!\u0006\u0005E\u0011AAH)\t\ti\b\u0003\u0005\u0002\u0014\u0006\u0005E\u0011AAK\u00031\u0011\u0017\r^2i\r>\u0014H+[7f+\t\t9\n\u0005\u0005\u0002\u001a\u0006}\u0015\u0011UAT\u001b\t\tYJC\u0002\u0002\u001eb\fq!\\;uC\ndW-C\u0002b\u00037\u00032!PAR\u0013\r\t)\u000b\u0002\u0002\u0005)&lW\rE\u0003&\u0003S\u000bi+C\u0002\u0002,\u001a\u0012Q!\u0011:sCf\u0004\"\"JAXE\u0006M\u0016QAA\u0003\u0013\r\t\tL\n\u0002\u0007)V\u0004H.\u001a\u001b\u0011\u0007\u0015\n),C\u0002\u00028\u001a\u00121!\u00138u\u0011!\tY,!!\u0005B\u0005u\u0016AB;qI\u0006$X\r\u0006\u0003\u0002\u0012\u0005}\u0006\u0002CAa\u0003s\u0003\r!!)\u0002\tQLW.\u001a\u0005\t\u0003\u000b\f\t\t\"\u0011\u0002H\u000691\r\\3b]V\u0004H\u0003BA\t\u0003\u0013D\u0001\"!1\u0002D\u0002\u0007\u0011\u0011\u0015\u0005\t\u0003\u001b\f\t\t\"\u0011\u0002P\u00069!/Z:u_J,GCAA\t\u0011!\t\u0019\u000e\u0001Q\u0001\n\u0005u\u0014aD2iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u0011\t\u0015\u0005]\u0007A1A\u0005R\u0011\tI.\u0001\bsCR,7i\u001c8ue>dG.\u001a:\u0016\u0005\u0005m\u0007#B\u0013\u0002^\u0006\u0005\u0018bAApM\t1q\n\u001d;j_:\u0004B!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0004\u0003O$\u0011!C:dQ\u0016$W\u000f\\3s\u0013\u0011\tY/!:\u0003\u001dI\u000bG/Z\"p]R\u0014x\u000e\u001c7fe\"A\u0011q\u001e\u0001!\u0002\u0013\tY.A\bsCR,7i\u001c8ue>dG.\u001a:!\u0011!\t\u0019\u0010\u0001C\t\t\u0005U\u0018aF7bq6+7o]1hKN\u0004VM\u001d)beRLG/[8o)\u0011\t90!@\u0011\u000b\u0015\ni.!?\u0011\r\r\fY\u0010`A\u0003\u0013\tY\b\u000e\u0003\u0005\u0002\u0000\u0006E\b\u0019AA}\u0003\u001dygMZ:fiNDqAa\u0001\u0001\t\u0013\u0011)!\u0001\bbI*,8\u000f\u001e)pg&$\u0018n\u001c8\u0015\t\u0005\u0015!q\u0001\u0005\b\u0005\u0013\u0011\t\u00011\u0001}\u0003\t!\b\u000fC\u0004\u0003\u000e\u0001!IAa\u0004\u0002\u0019A\f'/\u00198pS\u0012\u0004v\u000e\u001c7\u0015\t\u0005E!\u0011\u0003\u0005\t\u0005'\u0011Y\u00011\u0001\u0002&\u0005\t1\rC\u0004\u0003\u0018\u0001!\tB!\u0007\u0002\u001b1\fG/Z:u\u001f\u001a47/\u001a;t)\t\tI\u0010C\u0004\u0003\u001e\u0001!\tBa\b\u0002\u000b\rd\u0017-\u001c9\u0015\t\u0005e(\u0011\u0005\u0005\t\u0003\u007f\u0014Y\u00021\u0001\u0002z\"9!Q\u0005\u0001\u0005B\t\u001d\u0012aB2p[B,H/\u001a\u000b\u0005\u0005S\u0011\t\u0004E\u0003&\u0003;\u0014Y\u0003E\u00038\u0005[qR&C\u0002\u00030\t\u0011\u0001bS1gW\u0006\u0014F\t\u0012\u0005\t\u0005g\u0011\u0019\u00031\u0001\u0002\"\u0006Ia/\u00197jIRKW.\u001a\u0005\b\u0005o\u0001A\u0011IAh\u0003\u0015\u0019H/\u0019:u\u0011\u001d\u0011Y\u0004\u0001C!\u0003\u001f\fAa\u001d;pa\"I!q\b\u0001C\u0002\u0013E!\u0011I\u0001\fG>lW.\u001b;Rk\u0016,X-\u0006\u0002\u0003DA1!Q\tB&\u0005\u001fj!Aa\u0012\u000b\u0007\t%C,\u0001\u0006d_:\u001cWO\u001d:f]RLAA!\u0014\u0003H\t)2i\u001c8dkJ\u0014XM\u001c;MS:\\W\rZ)vKV,\u0007cA\u001c\u0003R%\u0019!1\u000b\u0002\u0003\u0017=3gm]3u%\u0006tw-\u001a\u0005\t\u0005/\u0002\u0001\u0015!\u0003\u0003D\u0005a1m\\7nSR\fV/Z;fA!I!1\f\u0001C\u0002\u0013E!QL\u0001\u000fG>lW.\u001b;DC2d'-Y2l+\t\u0011y\u0006\u0005\u0004\u0003b\t\u001d$1N\u0007\u0003\u0005GRAA!\u001a\u0003H\u00051\u0011\r^8nS\u000eLAA!\u001b\u0003d\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\rE\u0002\u0016\u0005[J1Aa\u001c\u0017\u0005QyeMZ:fi\u000e{W.\\5u\u0007\u0006dGNY1dW\"A!1\u000f\u0001!\u0002\u0013\u0011y&A\bd_6l\u0017\u000e^\"bY2\u0014\u0017mY6!\u0011\u001d\u00119\b\u0001C\u0001\u0005s\n1bY8n[&$\u0018i]=oGR!\u0011\u0011\u0003B>\u0011!\u0011iH!\u001eA\u0002\t}\u0014\u0001D8gMN,GOU1oO\u0016\u001c\b#B\u0013\u0002*\n=\u0003b\u0002B<\u0001\u0011\u0005!1\u0011\u000b\u0007\u0003#\u0011)Ia\"\t\u0011\tu$\u0011\u0011a\u0001\u0005\u007fB\u0001B!#\u0003\u0002\u0002\u0007!1N\u0001\tG\u0006dGNY1dW\"9!Q\u0012\u0001\u0005\u0012\u0005=\u0017!C2p[6LG/\u00117m\r\u001d\u0011\t\n\u0001\u0001\u0005\u0005'\u0013\u0011\u0004R5sK\u000e$8*\u00194lCJ\u000bG/Z\"p]R\u0014x\u000e\u001c7feN!!qRAq\u00115\u00119Ja$\u0003\u0002\u0003\u0006I!a-\u0003\u001a\u0006\u0011\u0011\u000eZ\u0005\u0005\u00057\u000bI/A\u0005tiJ,\u0017-\\+J\t\"Y!q\u0014BH\u0005\u0003\u0005\u000b\u0011\u0002BQ\u0003%)7\u000f^5nCR|'\u000f\u0005\u0003\u0003$\n%VB\u0001BS\u0015\u0011\u00119+!:\u0002\tI\fG/Z\u0005\u0005\u0005W\u0013)KA\u0007SCR,Wi\u001d;j[\u0006$xN\u001d\u0005\b!\n=E\u0011\u0001BX)\u0019\u0011\tLa-\u00036B!\u0011q\u0010BH\u0011!\u00119J!,A\u0002\u0005M\u0006\u0002\u0003BP\u0005[\u0003\rA!)\t\u0011\te&q\u0012C!\u0005w\u000bq\u0001];cY&\u001c\b\u000e\u0006\u0003\u0002\u0012\tu\u0006\u0002\u0003BT\u0005o\u0003\r!!\u0002")
public class DirectKafkaInputDStream<K, V>
extends InputDStream<ConsumerRecord<K, V>>
implements CanCommitOffsets {
    private final LocationStrategy locationStrategy;
    private final ConsumerStrategy<K, V> consumerStrategy;
    public final PerPartitionConfig org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$ppc;
    private final HashMap<String, Object> executorKafkaParams;
    private scala.collection.immutable.Map<TopicPartition, Object> currentOffsets;
    private transient Consumer<K, V> kc;
    private final DirectKafkaInputDStreamCheckpointData checkpointData;
    private final Option<RateController> rateController;
    private final ConcurrentLinkedQueue<OffsetRange> commitQueue;
    private final AtomicReference<OffsetCommitCallback> commitCallback;

    public HashMap<String, Object> executorKafkaParams() {
        return this.executorKafkaParams;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> currentOffsets() {
        return this.currentOffsets;
    }

    public void currentOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.currentOffsets = x$1;
    }

    private Consumer<K, V> kc() {
        return this.kc;
    }

    private void kc_$eq(Consumer<K, V> x$1) {
        this.kc = x$1;
    }

    public synchronized Consumer<K, V> consumer() {
        if (this.kc() == null) {
            this.kc_$eq(this.consumerStrategy.onStart((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.currentOffsets().mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Long apply(long l) {
                    return new Long(l);
                }
            })).asJava()));
        }
        return this.kc();
    }

    public DStream<ConsumerRecord<K, V>> persist(StorageLevel newLevel) {
        this.logError((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window";
            }
        });
        return super.persist(newLevel);
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<TopicPartition, String> getBrokers() {
        void var2_2;
        Consumer<K, V> c = this.consumer();
        HashMap result = new HashMap();
        HashMap<TopicPartition, String> hosts = new HashMap<TopicPartition, String>();
        for (TopicPartition tp : c.assignment()) {
            if (hosts.get(tp) == null) {
                for (PartitionInfo i : c.partitionsFor(tp.topic())) {
                    hosts.put(new TopicPartition(i.topic(), i.partition()), i.leader().host());
                }
            }
            result.put(tp, hosts.get(tp));
        }
        return var2_2;
    }

    public java.util.Map<TopicPartition, String> getPreferredHosts() {
        LocationStrategy locationStrategy;
        block5: {
            java.util.Map<Object, String> map;
            block3: {
                block4: {
                    block2: {
                        locationStrategy = this.locationStrategy;
                        if (!PreferBrokers$.MODULE$.equals(locationStrategy)) break block2;
                        map = this.getBrokers();
                        break block3;
                    }
                    if (!PreferConsistent$.MODULE$.equals(locationStrategy)) break block4;
                    map = Collections.emptyMap();
                    break block3;
                }
                if (!(locationStrategy instanceof PreferFixed)) break block5;
                PreferFixed preferFixed = (PreferFixed)locationStrategy;
                java.util.Map<TopicPartition, String> hostMap = preferFixed.hostMap();
                map = hostMap;
            }
            return map;
        }
        throw new MatchError((Object)locationStrategy);
    }

    public String name() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kafka 0.09 direct stream [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())}));
    }

    public DirectKafkaInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    public Option<RateController> rateController() {
        return this.rateController;
    }

    public Option<scala.collection.immutable.Map<TopicPartition, Object>> maxMessagesPerPartition(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        Option option;
        block7: {
            None$ none$;
            scala.collection.immutable.Map map;
            block6: {
                block5: {
                    Option estimatedRateLimit = this.rateController().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(RateController x$1) {
                            return x$1.getLatestRate();
                        }
                    });
                    option = estimatedRateLimit.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(long x$2) {
                            return this.apply$mcZJ$sp(x$2);
                        }

                        public boolean apply$mcZJ$sp(long x$2) {
                            return x$2 > 0L;
                        }
                    });
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    long rate = BoxesRunTime.unboxToLong((Object)some.x());
                    scala.collection.immutable.Map lagPerPartition = (scala.collection.immutable.Map)offsets.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;

                        public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$1) {
                            Tuple2<TopicPartition, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                TopicPartition tp = (TopicPartition)tuple2._1();
                                long offset = tuple2._2$mcJ$sp();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max(offset - BoxesRunTime.unboxToLong((Object)this.$outer.currentOffsets().apply((Object)tp)), 0L)));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    long totalLag = BoxesRunTime.unboxToLong((Object)lagPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    map = (scala.collection.immutable.Map)lagPerPartition.map((Function1)new Serializable(this, rate, totalLag){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;
                        private final long rate$1;
                        private final long totalLag$1;

                        public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$2) {
                            Tuple2<TopicPartition, Object> tuple2 = x0$2;
                            if (tuple2 != null) {
                                TopicPartition tp = (TopicPartition)tuple2._1();
                                long lag = tuple2._2$mcJ$sp();
                                long maxRateLimitPerPartition = this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$ppc.maxRatePerPartition(tp);
                                int backpressureRate = Math.round((float)((double)lag / (double)this.totalLag$1) * (float)this.rate$1);
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)(maxRateLimitPerPartition > 0L ? BoxesRunTime.boxToLong((long)Math.min((long)backpressureRate, maxRateLimitPerPartition)) : BoxesRunTime.boxToLong((long)backpressureRate)));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rate$1 = rate$1;
                            this.totalLag$1 = totalLag$1;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    break block6;
                }
                if (!None$.MODULE$.equals(option)) break block7;
                map = (scala.collection.immutable.Map)offsets.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DirectKafkaInputDStream $outer;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$3) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$ppc.maxRatePerPartition(tp)));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            scala.collection.immutable.Map effectiveRateLimitPerPartition = map;
            if (BoxesRunTime.unboxToLong((Object)effectiveRateLimitPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) > 0L) {
                double secsPerBatch = (double)this.context().graph().batchDuration().milliseconds() / (double)1000;
                none$ = new Some(effectiveRateLimitPerPartition.map((Function1)new Serializable(this, secsPerBatch){
                    public static final long serialVersionUID = 0L;
                    private final double secsPerBatch$1;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$4) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$4;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            long limit = tuple2._2$mcJ$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)((long)(this.secsPerBatch$1 * (double)limit))));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.secsPerBatch$1 = secsPerBatch$1;
                    }
                }, Map$.MODULE$.canBuildFrom()));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)option);
    }

    public long org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$adjustPosition(TopicPartition tp) {
        long l;
        Consumer<K, V> c = this.consumer();
        long pos = c.position(tp);
        if (pos == 0L) {
            boolean isStreams;
            boolean bl = isStreams = tp.topic().startsWith("/") || tp.topic().contains(":");
            l = isStreams ? 1L : 0L;
        } else {
            l = pos;
        }
        return l;
    }

    private void paranoidPoll(Consumer<K, V> c) {
        ConsumerRecords msgs = c.poll(1000L);
        if (!msgs.isEmpty()) {
            ((IterableLike)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)msgs).asScala()).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final scala.collection.immutable.Map<TopicPartition, Object> apply(scala.collection.immutable.Map<TopicPartition, Object> acc, ConsumerRecord<K, V> m) {
                    TopicPartition tp = new TopicPartition(m.topic(), m.partition());
                    long off = BoxesRunTime.unboxToLong((Object)acc.get((Object)tp).map((Function1)new Serializable(this, m){
                        public static final long serialVersionUID = 0L;
                        private final ConsumerRecord m$1;

                        public final long apply(long o) {
                            return this.apply$mcJJ$sp(o);
                        }

                        public long apply$mcJJ$sp(long o) {
                            return Math.min(o, this.m$1.offset());
                        }
                        {
                            this.m$1 = m$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, m){
                        public static final long serialVersionUID = 0L;
                        private final ConsumerRecord m$1;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return this.m$1.offset();
                        }
                        {
                            this.m$1 = m$1;
                        }
                    }));
                    return acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)off)));
                }
            })).foreach((Function1)new Serializable(this, c){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStream $outer;
                private final Consumer c$1;

                public final void apply(Tuple2<TopicPartition, Object> x0$5) {
                    Tuple2<TopicPartition, Object> tuple2 = x0$5;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        long off = tuple2._2$mcJ$sp();
                        this.$outer.logInfo((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final TopicPartition tp$1;
                            private final long off$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"poll(0) returned messages, seeking ", " to ", " to compensate"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1, BoxesRunTime.boxToLong((long)this.off$1)}));
                            }
                            {
                                this.tp$1 = tp$1;
                                this.off$1 = off$1;
                            }
                        });
                        this.c$1.seek(tp, off);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.c$1 = c$1;
                }
            });
        }
    }

    public scala.collection.immutable.Map<TopicPartition, Object> latestOffsets() {
        Consumer<K, V> c = this.consumer();
        this.paranoidPoll(c);
        Set parts = (Set)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala();
        Set newPartitions = (Set)parts.diff((GenSet)this.currentOffsets().keySet());
        this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)this.currentOffsets().$plus$plus((GenTraversableOnce)((TraversableOnce)newPartitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectKafkaInputDStream $outer;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$adjustPosition(tp)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
        c.pause((TopicPartition[])newPartitions.toArray(ClassTag$.MODULE$.apply(TopicPartition.class)));
        c.seekToEnd((TopicPartition[])this.currentOffsets().keySet().toArray(ClassTag$.MODULE$.apply(TopicPartition.class)));
        return ((TraversableOnce)parts.map((Function1)new Serializable(this, c){
            public static final long serialVersionUID = 0L;
            private final Consumer c$2;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.c$2.position(tp)));
            }
            {
                this.c$2 = c$2;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, Object> clamp(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        return (scala.collection.immutable.Map)this.maxMessagesPerPartition(offsets).map((Function1)new Serializable(this, offsets){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectKafkaInputDStream $outer;
            public final scala.collection.immutable.Map offsets$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply(scala.collection.immutable.Map<TopicPartition, Object> mmp) {
                return (scala.collection.immutable.Map)mmp.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$clamp$1 $outer;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$6) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$6;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            long messages = tuple2._2$mcJ$sp();
                            long uo = BoxesRunTime.unboxToLong((Object)this.$outer.offsets$1.apply((Object)tp));
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.min(BoxesRunTime.unboxToLong((Object)this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$anonfun$$$outer().currentOffsets().apply((Object)tp)) + messages, uo)));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsets$1 = offsets$1;
            }
        }).getOrElse((Function0)new Serializable(this, offsets){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map offsets$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply() {
                return this.offsets$1;
            }
            {
                this.offsets$1 = offsets$1;
            }
        });
    }

    public Option<KafkaRDD<K, V>> compute(Time validTime) {
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = this.clamp(this.latestOffsets());
        Iterable offsetRanges = (Iterable)untilOffsets.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectKafkaInputDStream $outer;

            public final OffsetRange apply(Tuple2<TopicPartition, Object> x0$7) {
                Tuple2<TopicPartition, Object> tuple2 = x0$7;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long uo = tuple2._2$mcJ$sp();
                    long fo = BoxesRunTime.unboxToLong((Object)this.$outer.currentOffsets().apply((Object)tp));
                    OffsetRange offsetRange = OffsetRange$.MODULE$.apply(tp.topic(), tp.partition(), fo, uo);
                    return offsetRange;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        KafkaRDD rdd = new KafkaRDD(this.context().sparkContext(), this.executorKafkaParams(), (OffsetRange[])offsetRanges.toArray(ClassTag$.MODULE$.apply(OffsetRange.class)), this.getPreferredHosts(), true);
        String description = ((TraversableOnce)((TraversableLike)offsetRanges.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(OffsetRange offsetRange) {
                return offsetRange.fromOffset() != offsetRange.untilOffset();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(OffsetRange offsetRange) {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic: ", "\\tpartition: ", "\\t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offsetRange.topic(), BoxesRunTime.boxToInteger((int)offsetRange.partition())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offsets: ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offsetRange.fromOffset()), BoxesRunTime.boxToLong((long)offsetRange.untilOffset())}))).toString();
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsets"), (Object)offsetRanges.toList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), (Object)description)}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), rdd.offsetCount(), metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        this.currentOffsets_$eq(untilOffsets);
        this.commitAll();
        return new Some(rdd);
    }

    public void start() {
        Consumer<K, V> c = this.consumer();
        this.paranoidPoll(c);
        if (this.currentOffsets().isEmpty()) {
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStream $outer;

                public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$adjustPosition(tp)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        c.pause((TopicPartition[])this.currentOffsets().keySet().toArray(ClassTag$.MODULE$.apply(TopicPartition.class)));
    }

    public synchronized void stop() {
        if (this.kc() != null) {
            this.kc().close();
        }
    }

    public ConcurrentLinkedQueue<OffsetRange> commitQueue() {
        return this.commitQueue;
    }

    public AtomicReference<OffsetCommitCallback> commitCallback() {
        return this.commitCallback;
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges) {
        this.commitAsync(offsetRanges, null);
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges, OffsetCommitCallback callback) {
        this.commitCallback().set(callback);
        this.commitQueue().addAll(Arrays.asList((Object[])offsetRanges));
    }

    public void commitAll() {
        HashMap<TopicPartition, OffsetAndMetadata> m = new HashMap<TopicPartition, OffsetAndMetadata>();
        OffsetRange osr = this.commitQueue().poll();
        while (true) {
            if (osr == null) {
                if (!m.isEmpty()) {
                    this.consumer().commitAsync(m, this.commitCallback().get());
                }
                return;
            }
            TopicPartition tp = osr.topicPartition();
            OffsetAndMetadata x = (OffsetAndMetadata)m.get(tp);
            long offset = x == null ? osr.untilOffset() : Math.max(x.offset(), osr.untilOffset());
            m.put(tp, new OffsetAndMetadata(offset));
            osr = this.commitQueue().poll();
        }
    }

    public DirectKafkaInputDStream(StreamingContext _ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy, PerPartitionConfig ppc) {
        this.locationStrategy = locationStrategy;
        this.consumerStrategy = consumerStrategy;
        this.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$ppc = ppc;
        super(_ssc, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        HashMap<String, Object> ekp = new HashMap<String, Object>(consumerStrategy.executorKafkaParams());
        KafkaUtils$.MODULE$.fixKafkaParams(ekp);
        this.executorKafkaParams = ekp;
        this.currentOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.kc = null;
        this.checkpointData = new DirectKafkaInputDStreamCheckpointData();
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some((Object)new DirectKafkaRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.context().graph().batchDuration()))) : None$.MODULE$;
        this.commitQueue = new ConcurrentLinkedQueue();
        this.commitCallback = new AtomicReference();
    }

    public class DirectKafkaRateController
    extends RateController {
        public void publish(long rate) {
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaRateController$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaRateController(int id, RateEstimator estimator) {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }

    public class DirectKafkaInputDStreamCheckpointData
    extends DStreamCheckpointData<ConsumerRecord<K, V>> {
        public scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> batchForTime() {
            return this.data();
        }

        public void update(Time time) {
            this.batchForTime().clear();
            this.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStreamCheckpointData $outer;

                public final scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> apply(Tuple2<Time, RDD<ConsumerRecord<K, V>>> kv) {
                    Tuple4[] a = (Tuple4[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((KafkaRDD)kv._2()).offsetRanges()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple4<String, Object, Object, Object> apply(OffsetRange x$3) {
                            return x$3.toTuple();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class)))).toArray(ClassTag$.MODULE$.apply(Tuple4.class));
                    return this.$outer.batchForTime().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)a));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public void cleanup(Time time) {
        }

        public void restore() {
            ((IterableLike)this.batchForTime().toSeq().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Time apply(Tuple2<Time, Tuple4<String, Object, Object, Object>[]> x$4) {
                    return (Time)x$4._1();
                }
            }, Time$.MODULE$.ordering())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStreamCheckpointData $outer;

                public final scala.collection.mutable.HashMap<Time, RDD<ConsumerRecord<K, V>>> apply(Tuple2<Time, Tuple4<String, Object, Object, Object>[]> x0$8) {
                    Tuple2<Time, Tuple4<String, Object, Object, Object>[]> tuple2 = x0$8;
                    if (tuple2 != null) {
                        Time t = (Time)tuple2._1();
                        Tuple4[] b = (Tuple4[])tuple2._2();
                        this.$outer.logInfo((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final Time t$1;
                            private final Tuple4[] b$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restoring KafkaRDD for time ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.t$1, Predef$.MODULE$.refArrayOps((Object[])this.b$1).mkString("[", ", ", "]")}));
                            }
                            {
                                this.t$1 = t$1;
                                this.b$1 = b$1;
                            }
                        });
                        scala.collection.mutable.HashMap hashMap = this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), new KafkaRDD<K, V>(this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().context().sparkContext(), this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().executorKafkaParams(), (OffsetRange[])Predef$.MODULE$.refArrayOps((Object[])b).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final OffsetRange apply(Tuple4<String, Object, Object, Object> x$5) {
                                return OffsetRange$.MODULE$.apply(x$5);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OffsetRange.class))), this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().getPreferredHosts(), false)));
                        return hashMap;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaInputDStreamCheckpointData() {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(DirectKafkaInputDStream.this, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        }
    }
}

