/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka09;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.PartitionStateInfo;
import kafka.api.Request$;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.kafka09.KafkaTestUtils$$anonfun$org$apache$spark$streaming$kafka09$KafkaTestUtils$;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tme!B\u0001\u0003\u0001\ta!AD&bM.\fG+Z:u+RLGn\u001d\u0006\u0003\u0007\u0011\tqa[1gW\u0006\u0004\u0014H\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!r#D\u0001\u0016\u0015\t1b!\u0001\u0005j]R,'O\\1m\u0013\tARCA\u0004M_\u001e<\u0017N\\4\t\u000bi\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0019Q8\u000eS8tiV\t!\u0005\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005!A.\u00198h\u0015\u00059\u0013\u0001\u00026bm\u0006L!!\u000b\u0013\u0003\rM#(/\u001b8h\u0011\u0019Y\u0003\u0001)A\u0005E\u00059!p\u001b%pgR\u0004\u0003bB\u0017\u0001\u0001\u0004%IAL\u0001\u0007u.\u0004vN\u001d;\u0016\u0003=\u0002\"A\u0004\u0019\n\u0005Ez!aA%oi\"91\u0007\u0001a\u0001\n\u0013!\u0014A\u0003>l!>\u0014Ho\u0018\u0013fcR\u0011Q\u0007\u000f\t\u0003\u001dYJ!aN\b\u0003\tUs\u0017\u000e\u001e\u0005\bsI\n\t\u00111\u00010\u0003\rAH%\r\u0005\u0007w\u0001\u0001\u000b\u0015B\u0018\u0002\u000fi\\\u0007k\u001c:uA!9Q\b\u0001b\u0001\n\u0013q\u0013a\u0005>l\u0007>tg.Z2uS>tG+[7f_V$\bBB \u0001A\u0003%q&\u0001\u000b{W\u000e{gN\\3di&|g\u000eV5nK>,H\u000f\t\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003/\u0003AQ8nU3tg&|g\u000eV5nK>,H\u000f\u0003\u0004D\u0001\u0001\u0006IaL\u0001\u0012u.\u001cVm]:j_:$\u0016.\\3pkR\u0004\u0003\"C#\u0001\u0001\u0004\u0005\r\u0011\"\u0003G\u0003%Qxn\\6fKB,'/F\u0001H!\tA\u0015*D\u0001\u0001\r\u0011Q\u0005\u0001B&\u0003#\u0015k'-\u001a3eK\u0012Tvn\\6fKB,'o\u0005\u0002J\u001b!AQ*\u0013BC\u0002\u0013\u0005a*A\u0005{W\u000e{gN\\3diV\tq\n\u0005\u0002Q':\u0011a\"U\u0005\u0003%>\ta\u0001\u0015:fI\u00164\u0017BA\u0015U\u0015\t\u0011v\u0002\u0003\u0005W\u0013\n\u0005\t\u0015!\u0003P\u0003)Q8nQ8o]\u0016\u001cG\u000f\t\u0005\u00065%#\t\u0001\u0017\u000b\u0003\u000ffCQ!T,A\u0002=CqaW%C\u0002\u0013\u0005A,A\u0006t]\u0006\u00048\u000f[8u\t&\u0014X#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u00014\u0013AA5p\u0013\t\u0011wL\u0001\u0003GS2,\u0007B\u00023JA\u0003%Q,\u0001\u0007t]\u0006\u00048\u000f[8u\t&\u0014\b\u0005C\u0004g\u0013\n\u0007I\u0011\u0001/\u0002\r1|w\rR5s\u0011\u0019A\u0017\n)A\u0005;\u00069An\\4ESJ\u0004\u0003bB#J\u0005\u0004%\tA[\u000b\u0002WB\u0011A\u000e]\u0007\u0002[*\u0011an\\\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u0015C\u0011BA9n\u0005=Qvn\\&fKB,'oU3sm\u0016\u0014\bBB:JA\u0003%1.\u0001\u0006{_>\\W-\u001a9fe\u0002B!\"^%\u0011\u0002\u0003\r\t\u0015!\u0003w\u0003\rAHe\r\t\u0005\u001d]\u0014s&\u0003\u0002y\u001f\t1A+\u001e9mKJBqA_%C\u0002\u0013\u0005\u0011%\u0001\u0002ja\"1A0\u0013Q\u0001\n\t\n1!\u001b9!\u0011\u001dq\u0018J1A\u0005\u00029\nA\u0001]8si\"9\u0011\u0011A%!\u0002\u0013y\u0013!\u00029peR\u0004\u0003\"CA\u0003\u0013\n\u0007I\u0011AA\u0004\u0003\u001d1\u0017m\u0019;pef,\"!!\u0003\u0011\u00071\fY!C\u0002\u0002\u000e5\u0014ACT%P'\u0016\u0014h/\u001a:D]btg)Y2u_JL\b\u0002CA\t\u0013\u0002\u0006I!!\u0003\u0002\u0011\u0019\f7\r^8ss\u0002B\u0001\"!\u0006J\u0005\u0004%\tAL\u0001\u000bC\u000e$X/\u00197Q_J$\bbBA\r\u0013\u0002\u0006IaL\u0001\fC\u000e$X/\u00197Q_J$\b\u0005C\u0004\u0002\u001e%#\t!a\b\u0002\u0011MDW\u000f\u001e3po:$\u0012!\u000e\u0005\f\u0003G\u0001\u0001\u0019!a\u0001\n\u0013\t)#A\u0007{_>\\W-\u001a9fe~#S-\u001d\u000b\u0004k\u0005\u001d\u0002\u0002C\u001d\u0002\"\u0005\u0005\t\u0019A$\t\rM\u0004\u0001\u0015)\u0003H\u0011-\ti\u0003\u0001a\u0001\u0002\u0004%I!a\f\u0002\u000fi\\W\u000b^5mgV\u0011\u0011\u0011\u0007\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u0015)H/\u001b7t\u0015\t\tY$A\u0003lC\u001a\\\u0017-\u0003\u0003\u0002@\u0005U\"a\u0002.l+RLGn\u001d\u0005\f\u0003\u0007\u0002\u0001\u0019!a\u0001\n\u0013\t)%A\u0006{WV#\u0018\u000e\\:`I\u0015\fHcA\u001b\u0002H!I\u0011(!\u0011\u0002\u0002\u0003\u0007\u0011\u0011\u0007\u0005\t\u0003\u0017\u0002\u0001\u0015)\u0003\u00022\u0005A!p[+uS2\u001c\b\u0005\u0003\u0005\u0002P\u0001\u0011\r\u0011\"\u0003\"\u0003)\u0011'o\\6fe\"{7\u000f\u001e\u0005\b\u0003'\u0002\u0001\u0015!\u0003#\u0003-\u0011'o\\6fe\"{7\u000f\u001e\u0011\t\u0011\u0005]\u0003\u00011A\u0005\n9\n!B\u0019:pW\u0016\u0014\bk\u001c:u\u0011%\tY\u0006\u0001a\u0001\n\u0013\ti&\u0001\bce>\\WM\u001d)peR|F%Z9\u0015\u0007U\ny\u0006\u0003\u0005:\u00033\n\t\u00111\u00010\u0011\u001d\t\u0019\u0007\u0001Q!\n=\n1B\u0019:pW\u0016\u0014\bk\u001c:uA!Y\u0011q\r\u0001A\u0002\u0003\u0007I\u0011BA5\u0003)\u0011'o\\6fe\u000e{gNZ\u000b\u0003\u0003W\u0002B!!\u001c\u0002r5\u0011\u0011q\u000e\u0006\u0004]\u0006e\u0012\u0002BA:\u0003_\u00121bS1gW\u0006\u001cuN\u001c4jO\"Y\u0011q\u000f\u0001A\u0002\u0003\u0007I\u0011BA=\u00039\u0011'o\\6fe\u000e{gNZ0%KF$2!NA>\u0011%I\u0014QOA\u0001\u0002\u0004\tY\u0007\u0003\u0005\u0002\u0000\u0001\u0001\u000b\u0015BA6\u0003-\u0011'o\\6fe\u000e{gN\u001a\u0011\t\u00159\u0004\u0001\u0019!a\u0001\n\u0013\t\u0019)\u0006\u0002\u0002\u0006B!\u0011QNAD\u0013\u0011\tI)a\u001c\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\f\u0003\u001b\u0003\u0001\u0019!a\u0001\n\u0013\ty)\u0001\u0006tKJ4XM]0%KF$2!NAI\u0011%I\u00141RA\u0001\u0002\u0004\t)\t\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0015BAC\u0003\u001d\u0019XM\u001d<fe\u0002B1\"!'\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001c\u0006A\u0001O]8ek\u000e,'/\u0006\u0002\u0002\u001eB1\u0011qTAR\u001f>k!!!)\u000b\t\u0005e\u0015\u0011H\u0005\u0005\u0003K\u000b\tK\u0001\u0005Qe>$WoY3s\u0011-\tI\u000b\u0001a\u0001\u0002\u0004%I!a+\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0007U\ni\u000bC\u0005:\u0003O\u000b\t\u00111\u0001\u0002\u001e\"A\u0011\u0011\u0017\u0001!B\u0013\ti*A\u0005qe>$WoY3sA!I\u0011Q\u0017\u0001A\u0002\u0013%\u0011qW\u0001\bu.\u0014V-\u00193z+\t\tI\fE\u0002\u000f\u0003wK1!!0\u0010\u0005\u001d\u0011un\u001c7fC:D\u0011\"!1\u0001\u0001\u0004%I!a1\u0002\u0017i\\'+Z1es~#S-\u001d\u000b\u0004k\u0005\u0015\u0007\"C\u001d\u0002@\u0006\u0005\t\u0019AA]\u0011!\tI\r\u0001Q!\n\u0005e\u0016\u0001\u0003>l%\u0016\fG-\u001f\u0011\t\u0013\u00055\u0007\u00011A\u0005\n\u0005]\u0016a\u00032s_.,'OU3bIfD\u0011\"!5\u0001\u0001\u0004%I!a5\u0002\u001f\t\u0014xn[3s%\u0016\fG-_0%KF$2!NAk\u0011%I\u0014qZA\u0001\u0002\u0004\tI\f\u0003\u0005\u0002Z\u0002\u0001\u000b\u0015BA]\u00031\u0011'o\\6feJ+\u0017\rZ=!\u0011\u0019\ti\u000e\u0001C\u0001\u001d\u0006I!p[!eIJ,7o\u001d\u0005\u0007\u0003C\u0004A\u0011\u0001(\u0002\u001b\t\u0014xn[3s\u0003\u0012$'/Z:t\u0011\u001d\t)\u000f\u0001C\u0001\u0003_\tqB_8pW\u0016,\u0007/\u001a:DY&,g\u000e\u001e\u0005\b\u0003S\u0004A\u0011BA\u0010\u0003Y\u0019X\r^;q\u000b6\u0014W\r\u001a3fIj{wn[3fa\u0016\u0014\bbBAw\u0001\u0011%\u0011qD\u0001\u0019g\u0016$X\u000f]#nE\u0016$G-\u001a3LC\u001a\\\u0017mU3sm\u0016\u0014\bbBAy\u0001\u0011\u0005\u0011qD\u0001\u0006g\u0016$X\u000f\u001d\u0005\b\u0003k\u0004A\u0011AA\u0010\u0003!!X-\u0019:e_^t\u0007bBA}\u0001\u0011\u0005\u00111`\u0001\fGJ,\u0017\r^3U_BL7\rF\u00036\u0003{\u0014\t\u0001C\u0004\u0002\u0000\u0006]\b\u0019A(\u0002\u000bQ|\u0007/[2\t\u000f\t\r\u0011q\u001fa\u0001_\u0005Q\u0001/\u0019:uSRLwN\\:\t\u000f\u0005e\b\u0001\"\u0001\u0003\bQ\u0019QG!\u0003\t\u000f\u0005}(Q\u0001a\u0001\u001f\"9!Q\u0002\u0001\u0005\u0002\t=\u0011\u0001D:f]\u0012lUm]:bO\u0016\u001cH#B\u001b\u0003\u0012\tM\u0001bBA\u0000\u0005\u0017\u0001\ra\u0014\u0005\t\u0005+\u0011Y\u00011\u0001\u0003\u0018\u0005iQ.Z:tC\u001e,Gk\u001c$sKF\u0004rA!\u0007\u0003 =\u0013\u0019#\u0004\u0002\u0003\u001c)\u0019!Q\u0004\u0014\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005C\u0011YBA\u0002NCB\u00042a\tB\u0013\u0013\r\u00119\u0003\n\u0002\b\u0013:$XmZ3s\u0011\u001d\u0011i\u0001\u0001C\u0001\u0005W!R!\u000eB\u0017\u0005_Aq!a@\u0003*\u0001\u0007q\n\u0003\u0005\u0003\u0016\t%\u0002\u0019\u0001B\u0019!\u0015\u0001&1G(0\u0013\r\u0011\t\u0003\u0016\u0005\b\u0005\u001b\u0001A\u0011\u0001B\u001c)\u0015)$\u0011\bB\u001e\u0011\u001d\tyP!\u000eA\u0002=C\u0001B!\u0010\u00036\u0001\u0007!qH\u0001\t[\u0016\u001c8/Y4fgB!aB!\u0011P\u0013\r\u0011\u0019e\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0003M\u0011'o\\6fe\u000e{gNZ5hkJ\fG/[8o+\t\u0011Y\u0005\u0005\u0003\u0003\u001a\t5\u0013\u0002\u0002B(\u00057\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0011\u0019\u0006\u0001C\u0005\u0005\u0013\nQ\u0003\u001d:pIV\u001cWM]\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u0003X\u0001!\tA!\u0017\u0002\u0015\u00154XM\u001c;vC2d\u00170\u0006\u0003\u0003\\\t\rDC\u0002B/\u0005\u007f\u0012Y\t\u0006\u0003\u0003`\tU\u0004\u0003\u0002B1\u0005Gb\u0001\u0001\u0002\u0005\u0003f\tU#\u0019\u0001B4\u0005\u0005!\u0016\u0003\u0002B5\u0005_\u00022A\u0004B6\u0013\r\u0011ig\u0004\u0002\b\u001d>$\b.\u001b8h!\rq!\u0011O\u0005\u0004\u0005gz!aA!os\"I!q\u000fB+\t\u0003\u0007!\u0011P\u0001\u0005MVt7\rE\u0003\u000f\u0005w\u0012y&C\u0002\u0003~=\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\t\u0005\u0003\u0013)\u00061\u0001\u0003\u0004\u00069A/[7f_V$\b\u0003\u0002BC\u0005\u000fk\u0011\u0001B\u0005\u0004\u0005\u0013#!\u0001\u0002+j[\u0016D\u0001B!$\u0003V\u0001\u0007!1Q\u0001\tS:$XM\u001d<bY\"9!\u0011\u0013\u0001\u0005\n\tM\u0015!H<bSR,f\u000e^5m\u001b\u0016$\u0018\rZ1uC&\u001b\bK]8qC\u001e\fG/\u001a3\u0015\u000bU\u0012)Ja&\t\u000f\u0005}(q\u0012a\u0001\u001f\"9!\u0011\u0014BH\u0001\u0004y\u0013!\u00039beRLG/[8o\u0001")
public class KafkaTestUtils
implements Logging {
    private final String zkHost;
    private int zkPort;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private EmbeddedZookeeper zookeeper;
    private ZkUtils zkUtils;
    private final String brokerHost;
    private int org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerPort;
    private KafkaConfig org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerConf;
    private KafkaServer org$apache$spark$streaming$kafka09$KafkaTestUtils$$server;
    private Producer<String, String> producer;
    private boolean zkReady;
    private boolean brokerReady;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private String zkHost() {
        return this.zkHost;
    }

    private int zkPort() {
        return this.zkPort;
    }

    private void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    private int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    private int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    private EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    private void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    public int org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerPort() {
        return this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerPort;
    }

    public void org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerPort_$eq(int x$1) {
        this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerPort = x$1;
    }

    public KafkaConfig org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerConf() {
        return this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerConf;
    }

    public void org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerConf_$eq(KafkaConfig x$1) {
        this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerConf = x$1;
    }

    public KafkaServer org$apache$spark$streaming$kafka09$KafkaTestUtils$$server() {
        return this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$server;
    }

    public void org$apache$spark$streaming$kafka09$KafkaTestUtils$$server_$eq(KafkaServer x$1) {
        this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$server = x$1;
    }

    private Producer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    private boolean zkReady() {
        return this.zkReady;
    }

    private void zkReady_$eq(boolean x$1) {
        this.zkReady = x$1;
    }

    private boolean brokerReady() {
        return this.brokerReady;
    }

    private void brokerReady_$eq(boolean x$1) {
        this.brokerReady = x$1;
    }

    public String zkAddress() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}));
    }

    public String brokerAddress() {
        Predef$.MODULE$.assert(this.brokerReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka not setup yet or already torn down, cannot get broker address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerHost(), BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerPort())}));
    }

    public ZkUtils zookeeperClient() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper client";
            }
        });
        return (ZkUtils)Option$.MODULE$.apply((Object)this.zkUtils()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Zookeeper client is not yet initialized");
            }
        });
    }

    private void setupEmbeddedZookeeper() {
        this.zookeeper_$eq(new EmbeddedZookeeper(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}))));
        this.zkPort_$eq(this.zookeeper().actualPort());
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())})), this.zkSessionTimeout(), this.zkConnectionTimeout(), false));
        this.zkReady_$eq(true);
    }

    private void setupEmbeddedKafkaServer() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper should be set up beforehand";
            }
        });
        Utils$.MODULE$.startServiceOnPort(this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerPort(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;

            public final Tuple2<KafkaServer, Object> apply(int port) {
                this.$outer.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerPort_$eq(port);
                this.$outer.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerConf_$eq(new KafkaConfig((Map)this.$outer.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerConfiguration()));
                this.$outer.org$apache$spark$streaming$kafka09$KafkaTestUtils$$server_$eq(new KafkaServer(this.$outer.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerConf(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3()));
                this.$outer.org$apache$spark$streaming$kafka09$KafkaTestUtils$$server().startup();
                KafkaServer qual$1 = this.$outer.org$apache$spark$streaming$kafka09$KafkaTestUtils$$server();
                SecurityProtocol x$4 = qual$1.boundPort$default$1();
                this.$outer.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerPort_$eq(qual$1.boundPort(x$4));
                return new Tuple2((Object)this.$outer.org$apache$spark$streaming$kafka09$KafkaTestUtils$$server(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerPort()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new SparkConf(), "KafkaBroker");
        this.brokerReady_$eq(true);
    }

    public void setup() {
        this.setupEmbeddedZookeeper();
        this.setupEmbeddedKafkaServer();
    }

    public void teardown() {
        this.brokerReady_$eq(false);
        this.zkReady_$eq(false);
        if (this.producer() != null) {
            this.producer().close();
            this.producer_$eq(null);
        }
        if (this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$server() != null) {
            this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$server().shutdown();
            this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$server_$eq(null);
        }
        this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerConf().logDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String f) {
                Utils$.MODULE$.deleteRecursively(new File(f));
            }
        });
        if (this.zkUtils() != null) {
            this.zkUtils().close();
            this.zkUtils_$eq(null);
        }
        if (this.zookeeper() != null) {
            this.zookeeper().shutdown();
            this.zookeeper_$eq(null);
        }
    }

    public void createTopic(String topic, int partitions) {
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, partitions, 1, AdminUtils$.MODULE$.createTopic$default$5());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions).foreach$mVc$sp((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            private final String topic$1;

            public final void apply(int p) {
                this.apply$mcVI$sp(p);
            }

            public void apply$mcVI$sp(int p) {
                this.$outer.org$apache$spark$streaming$kafka09$KafkaTestUtils$$waitUntilMetadataIsPropagated(this.topic$1, p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        });
    }

    public void createTopic(String topic) {
        this.createTopic(topic, 1);
    }

    public void sendMessages(String topic, Map<String, Integer> messageToFreq) {
        this.sendMessages(topic, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(messageToFreq).asScala()).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$1) {
                return x$1;
            }
        }).toSeq())));
    }

    public void sendMessages(String topic, scala.collection.immutable.Map<String, Object> messageToFreq) {
        String[] messages = (String[])((TraversableOnce)messageToFreq.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String s = (String)tuple2._1();
                    int freq = tuple2._2$mcI$sp();
                    Seq seq = (Seq)Seq$.MODULE$.fill(freq, (Function0)new Serializable(this, s){
                        public static final long serialVersionUID = 0L;
                        private final String s$1;

                        public final String apply() {
                            return this.s$1;
                        }
                        {
                            this.s$1 = s$1;
                        }
                    });
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        this.sendMessages(topic, messages);
    }

    public void sendMessages(String topic, String[] messages) {
        this.producer_$eq((Producer<String, String>)new Producer(new ProducerConfig(this.producerConfiguration())));
        this.producer().send((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])messages).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final KeyedMessage<String, String> apply(String x$2) {
                return new KeyedMessage(this.topic$3, (Object)x$2);
            }
            {
                this.topic$3 = topic$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KeyedMessage.class)))));
        this.producer().close();
        this.producer_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    public Properties org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("broker.id", "0");
        props.put("host.name", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerPort())).toString());
        props.put("log.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath());
        props.put("zookeeper.connect", this.zkAddress());
        props.put("log.flush.interval.messages", "1");
        props.put("replica.socket.timeout.ms", "1500");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties producerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerAddress());
        props.put("serializer.class", StringEncoder.class.getName());
        props.put("request.required.acks", "-1");
        return var1_1;
    }

    public <T> T eventually(Time timeout, Time interval, Function0<T> func) {
        long startTime = System.currentTimeMillis();
        return (T)this.tryAgain$1(1, timeout, interval, func, startTime);
    }

    public void org$apache$spark$streaming$kafka09$KafkaTestUtils$$waitUntilMetadataIsPropagated(String topic, int partition) {
        this.eventually(new Time(10000L), new Time(100L), (Function0)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            public final String topic$2;
            public final int partition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$kafka09$KafkaTestUtils$$isPropagated$1(this.topic$2, this.partition$1), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$spark$streaming$kafka09$KafkaTestUtils$$waitUntilMetadataIsPropagated$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition [", ", ", "] metadata not propagated after timeout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$2, BoxesRunTime.boxToInteger((int)this.$outer.partition$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.partition$1 = partition$1;
            }
        });
    }

    private final Either makeAttempt$1(Function0 func$1) {
        Throwable throwable2;
        block2: {
            Right right;
            try {
                right = package$.MODULE$.Right().apply(func$1.apply());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!NonFatal$.MODULE$.apply(throwable3)) break block2;
                Left left = package$.MODULE$.Left().apply((Object)throwable3);
                right = left;
            }
            return right;
        }
        throw throwable2;
    }

    private final Object tryAgain$1(int attempt, Time timeout$1, Time interval$1, Function0 func$1, long startTime$1) {
        Either either;
        block2: {
            Throwable e;
            while (true) {
                if ((either = this.makeAttempt$1(func$1)) instanceof Right) {
                    Object result;
                    Right right = (Right)either;
                    Object object = result = right.b();
                    return object;
                }
                if (!(either instanceof Left)) break block2;
                Left left = (Left)either;
                e = (Throwable)left.a();
                long duration = System.currentTimeMillis() - startTime$1;
                if (duration >= timeout$1.milliseconds()) break;
                Thread.sleep(interval$1.milliseconds());
                ++attempt;
            }
            throw new TimeoutException(e.getMessage());
        }
        throw new MatchError((Object)either);
    }

    public final boolean org$apache$spark$streaming$kafka09$KafkaTestUtils$$isPropagated$1(String topic$2, int partition$1) {
        boolean bl;
        Option option = this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$server().apis().metadataCache().getPartitionInfo(topic$2, partition$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            PartitionStateInfo partitionState = (PartitionStateInfo)some.x();
            LeaderAndIsr leaderAndInSyncReplicas = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr();
            bl = this.zkUtils().getLeaderForPartition(topic$2, partition$1).isDefined() && Request$.MODULE$.isValidBrokerId(leaderAndInSyncReplicas.leader()) && leaderAndInSyncReplicas.isr().size() >= 1;
        } else {
            bl = false;
        }
        return bl;
    }

    public KafkaTestUtils() {
        Logging.class.$init$((Logging)this);
        this.zkHost = "localhost";
        this.zkPort = 0;
        this.zkConnectionTimeout = 60000;
        this.zkSessionTimeout = 6000;
        this.brokerHost = "localhost";
        this.org$apache$spark$streaming$kafka09$KafkaTestUtils$$brokerPort = 0;
        this.zkReady = false;
        this.brokerReady = false;
    }

    public class EmbeddedZookeeper {
        private final String zkConnect;
        private final File snapshotDir;
        private final File logDir;
        private final ZooKeeperServer zookeeper;
        private final /* synthetic */ Tuple2 x$3;
        private final String ip;
        private final int port;
        private final NIOServerCnxnFactory factory;
        private final int actualPort;
        public final /* synthetic */ KafkaTestUtils $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public File snapshotDir() {
            return this.snapshotDir;
        }

        public File logDir() {
            return this.logDir;
        }

        public ZooKeeperServer zookeeper() {
            return this.zookeeper;
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public NIOServerCnxnFactory factory() {
            return this.factory;
        }

        public int actualPort() {
            return this.actualPort;
        }

        public void shutdown() {
            this.factory().shutdown();
            Utils$.MODULE$.deleteRecursively(this.snapshotDir());
            Utils$.MODULE$.deleteRecursively(this.logDir());
        }

        public /* synthetic */ KafkaTestUtils org$apache$spark$streaming$kafka09$KafkaTestUtils$EmbeddedZookeeper$$$outer() {
            return this.$outer;
        }

        public EmbeddedZookeeper(KafkaTestUtils $outer, String zkConnect) {
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.snapshotDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), 500);
            String[] splits = zkConnect.split(":");
            Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt()));
            if (tuple2 != null) {
                Tuple2 tuple22;
                String ip = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                this.x$3 = tuple22 = new Tuple2((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port));
                this.ip = (String)this.x$3._1();
                this.port = this.x$3._2$mcI$sp();
                this.factory = new NIOServerCnxnFactory();
                this.factory().configure(new InetSocketAddress(this.ip(), this.port()), 16);
                this.factory().startup(this.zookeeper());
                this.actualPort = this.factory().getLocalPort();
                return;
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

