/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka09;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka09.CanCommitOffsets;
import org.apache.spark.streaming.kafka09.ConsumerStrategy;
import org.apache.spark.streaming.kafka09.DirectKafkaInputDStream$;
import org.apache.spark.streaming.kafka09.KafkaRDD;
import org.apache.spark.streaming.kafka09.KafkaUtils$;
import org.apache.spark.streaming.kafka09.LocationStrategy;
import org.apache.spark.streaming.kafka09.OffsetRange;
import org.apache.spark.streaming.kafka09.OffsetRange$;
import org.apache.spark.streaming.kafka09.PreferBrokers$;
import org.apache.spark.streaming.kafka09.PreferConsistent$;
import org.apache.spark.streaming.kafka09.PreferFixed;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMf!B\u0001\u0003\u0001\u0019a!a\u0006#je\u0016\u001cGoS1gW\u0006Le\u000e];u\tN#(/Z1n\u0015\t\u0019A!A\u0004lC\u001a\\\u0017\rM\u001d\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<WcA\u0007!]M!\u0001A\u0004\u00197!\ry!\u0003F\u0007\u0002!)\u0011\u0011\u0003B\u0001\bIN$(/Z1n\u0013\t\u0019\u0002C\u0001\u0007J]B,H\u000fR*ue\u0016\fW\u000e\u0005\u0003\u00169yiS\"\u0001\f\u000b\u0005]A\u0012\u0001C2p]N,X.\u001a:\u000b\u0005eQ\u0012aB2mS\u0016tGo\u001d\u0006\u00037!\tQa[1gW\u0006L!!\b\f\u0003\u001d\r{gn];nKJ\u0014VmY8sIB\u0011q\u0004\t\u0007\u0001\t\u0015\t\u0003A1\u0001$\u0005\u0005Y5\u0001A\t\u0003I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012qAT8uQ&tw\r\u0005\u0002&W%\u0011AF\n\u0002\u0004\u0003:L\bCA\u0010/\t\u0015y\u0003A1\u0001$\u0005\u00051\u0006CA\u00195\u001b\u0005\u0011$BA\u001a\u0007\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001b3\u0005\u001daunZ4j]\u001e\u0004\"a\u000e\u001d\u000e\u0003\tI!!\u000f\u0002\u0003!\r\u000bgnQ8n[&$xJ\u001a4tKR\u001c\b\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\t}\u001b8o\u0019\t\u0003{yj\u0011\u0001B\u0005\u0003\u007f\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011\u0005\u0003!\u0011!Q\u0001\n\t\u000b\u0001\u0003\\8dCRLwN\\*ue\u0006$XmZ=\u0011\u0005]\u001a\u0015B\u0001#\u0003\u0005AaunY1uS>t7\u000b\u001e:bi\u0016<\u0017\u0010\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0003A\u0019wN\\:v[\u0016\u00148\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u00038\u0011zi\u0013BA%\u0003\u0005A\u0019uN\\:v[\u0016\u00148\u000b\u001e:bi\u0016<\u0017\u0010C\u0003L\u0001\u0011\u0005A*\u0001\u0004=S:LGO\u0010\u000b\u0005\u001b:{\u0005\u000b\u0005\u00038\u0001yi\u0003\"B\u001eK\u0001\u0004a\u0004\"B!K\u0001\u0004\u0011\u0005\"\u0002$K\u0001\u00049\u0005b\u0002*\u0001\u0005\u0004%\taU\u0001\u0014Kb,7-\u001e;pe.\u000bgm[1QCJ\fWn]\u000b\u0002)B!QK\u0017/d\u001b\u00051&BA,Y\u0003\u0011)H/\u001b7\u000b\u0003e\u000bAA[1wC&\u00111L\u0016\u0002\b\u0011\u0006\u001c\b.T1q!\ti\u0006M\u0004\u0002&=&\u0011qLJ\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'AB*ue&twM\u0003\u0002`MA\u0011AmZ\u0007\u0002K*\u0011a\rW\u0001\u0005Y\u0006tw-\u0003\u0002iK\n1qJ\u00196fGRDaA\u001b\u0001!\u0002\u0013!\u0016\u0001F3yK\u000e,Ho\u001c:LC\u001a\\\u0017\rU1sC6\u001c\b\u0005C\u0004m\u0001\u0001\u0007I\u0011C7\u0002\u001d\r,(O]3oi>3gm]3ugV\ta\u000e\u0005\u0003piZdX\"\u00019\u000b\u0005E\u0014\u0018!C5n[V$\u0018M\u00197f\u0015\t\u0019h%\u0001\u0006d_2dWm\u0019;j_:L!!\u001e9\u0003\u00075\u000b\u0007\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002z5\u000511m\\7n_:L!a\u001f=\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011Q%`\u0005\u0003}\u001a\u0012A\u0001T8oO\"I\u0011\u0011\u0001\u0001A\u0002\u0013E\u00111A\u0001\u0013GV\u0014(/\u001a8u\u001f\u001a47/\u001a;t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005-\u0001cA\u0013\u0002\b%\u0019\u0011\u0011\u0002\u0014\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u001by\u0018\u0011!a\u0001]\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005E\u0001\u0001)Q\u0005]\u0006y1-\u001e:sK:$xJ\u001a4tKR\u001c\b\u0005C\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0003\u0002\u0018\u0005\u00111nY\u000b\u0003\u00033\u0001R!FA\u000e=5J1!!\b\u0017\u0005!\u0019uN\\:v[\u0016\u0014\b\"CA\u0011\u0001\u0001\u0007I\u0011BA\u0012\u0003\u0019Y7m\u0018\u0013fcR!\u0011QAA\u0013\u0011)\ti!a\b\u0002\u0002\u0003\u0007\u0011\u0011\u0004\u0005\t\u0003S\u0001\u0001\u0015)\u0003\u0002\u001a\u0005\u00191n\u0019\u0011)\t\u0005\u001d\u0012Q\u0006\t\u0004K\u0005=\u0012bAA\u0019M\tIAO]1og&,g\u000e\u001e\u0005\u0007/\u0001!\t!!\u000e\u0015\u0005\u0005e\u0001bBA\u001d\u0001\u0011\u0005\u00131H\u0001\ba\u0016\u00148/[:u)\u0011\ti$a\u0011\u0011\t=\ty\u0004F\u0005\u0004\u0003\u0003\u0002\"a\u0002#TiJ,\u0017-\u001c\u0005\t\u0003\u000b\n9\u00041\u0001\u0002H\u0005Aa.Z<MKZ,G\u000e\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\tiEB\u0001\bgR|'/Y4f\u0013\u0011\t\t&a\u0013\u0003\u0019M#xN]1hK2+g/\u001a7\t\u000f\u0005U\u0003\u0001\"\u0005\u0002X\u0005Qq-\u001a;Ce>\\WM]:\u0016\u0005\u0005e\u0003\u0003B+[mrCq!!\u0018\u0001\t#\ty&A\thKR\u0004&/\u001a4feJ,G\rS8tiN,\"!!\u0019\u0011\u000bU\u000b\u0019G\u001e/\n\u0005U4\u0006\u0002CA4\u0001\u0011\u0005C!!\u001b\u0002\t9\fW.Z\u000b\u00029\"Q\u0011Q\u000e\u0001C\u0002\u0013EC!a\u001c\u0002\u001d\rDWmY6q_&tG\u000fR1uCV\u0011\u0011\u0011\u000f\t\u0005\u0003g\n)(D\u0001\u0001\r\u001d\t9\b\u0001\u0001\u0005\u0003s\u0012Q\u0005R5sK\u000e$8*\u00194lC&s\u0007/\u001e;E'R\u0014X-Y7DQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\u0014\t\u0005U\u00141\u0010\t\u0005\u001f\u0005uD#C\u0002\u0002\u0000A\u0011Q\u0003R*ue\u0016\fWn\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018\rC\u0004L\u0003k\"\t!a!\u0015\u0005\u0005E\u0004\u0002CAD\u0003k\"\t!!#\u0002\u0019\t\fGo\u00195G_J$\u0016.\\3\u0016\u0005\u0005-\u0005\u0003CAG\u0003'\u000b)*a'\u000e\u0005\u0005=%bAAIe\u00069Q.\u001e;bE2,\u0017bA.\u0002\u0010B\u0019Q(a&\n\u0007\u0005eEA\u0001\u0003US6,\u0007#B\u0013\u0002\u001e\u0006\u0005\u0016bAAPM\t)\u0011I\u001d:bsBAQ%a)]\u0003OcH0C\u0002\u0002&\u001a\u0012a\u0001V;qY\u0016$\u0004cA\u0013\u0002*&\u0019\u00111\u0016\u0014\u0003\u0007%sG\u000f\u0003\u0005\u00020\u0006UD\u0011IAY\u0003\u0019)\b\u000fZ1uKR!\u0011QAAZ\u0011!\t),!,A\u0002\u0005U\u0015\u0001\u0002;j[\u0016D\u0001\"!/\u0002v\u0011\u0005\u00131X\u0001\bG2,\u0017M\\;q)\u0011\t)!!0\t\u0011\u0005U\u0016q\u0017a\u0001\u0003+C\u0001\"!1\u0002v\u0011\u0005\u00131Y\u0001\be\u0016\u001cHo\u001c:f)\t\t)\u0001\u0003\u0005\u0002H\u0002\u0001\u000b\u0011BA9\u0003=\u0019\u0007.Z2la>Lg\u000e\u001e#bi\u0006\u0004\u0003BCAf\u0001\t\u0007I\u0011\u000b\u0003\u0002N\u0006q!/\u0019;f\u0007>tGO]8mY\u0016\u0014XCAAh!\u0015)\u0013\u0011[Ak\u0013\r\t\u0019N\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005]\u0017Q\\\u0007\u0003\u00033T1!a7\u0005\u0003%\u00198\r[3ek2,'/\u0003\u0003\u0002`\u0006e'A\u0004*bi\u0016\u001cuN\u001c;s_2dWM\u001d\u0005\t\u0003G\u0004\u0001\u0015!\u0003\u0002P\u0006y!/\u0019;f\u0007>tGO]8mY\u0016\u0014\b\u0005C\u0005\u0002h\u0002\u0011\r\u0011\"\u0003\u0002j\u0006AR.\u0019=SCR,G*[7jiB+'\u000fU1si&$\u0018n\u001c8\u0016\u0005\u0005\u001d\u0006\u0002CAw\u0001\u0001\u0006I!a*\u000235\f\u0007PU1uK2KW.\u001b;QKJ\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\t\u0003c\u0004A\u0011\u0003\u0003\u0002t\u00069R.\u0019=NKN\u001c\u0018mZ3t!\u0016\u0014\b+\u0019:uSRLwN\u001c\u000b\u0005\u0003k\fY\u0010E\u0003&\u0003#\f9\u0010E\u0003^\u0003s4H0\u0003\u0002vE\"A\u0011Q`Ax\u0001\u0004\t90A\u0004pM\u001a\u001cX\r^:\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004\u0005q\u0011\r\u001a6vgR\u0004vn]5uS>tGc\u0001?\u0003\u0006!9!qAA\u0000\u0001\u00041\u0018A\u0001;q\u0011\u001d\u0011Y\u0001\u0001C\t\u0005\u001b\tQ\u0002\\1uKN$xJ\u001a4tKR\u001cHCAA|\u0011\u001d\u0011\t\u0002\u0001C\t\u0005'\tQa\u00197b[B$B!a>\u0003\u0016!A\u0011Q B\b\u0001\u0004\t9\u0010C\u0004\u0003\u001a\u0001!\tEa\u0007\u0002\u000f\r|W\u000e];uKR!!Q\u0004B\u0013!\u0015)\u0013\u0011\u001bB\u0010!\u00159$\u0011\u0005\u0010.\u0013\r\u0011\u0019C\u0001\u0002\t\u0017\u000647.\u0019*E\t\"A!q\u0005B\f\u0001\u0004\t)*A\u0005wC2LG\rV5nK\"9!1\u0006\u0001\u0005B\u0005\r\u0017!B:uCJ$\bb\u0002B\u0018\u0001\u0011\u0005\u00131Y\u0001\u0005gR|\u0007\u000fC\u0005\u00034\u0001\u0011\r\u0011\"\u0005\u00036\u0005Y1m\\7nSR\fV/Z;f+\t\u00119\u0004\u0005\u0004\u0003:\t}\"1I\u0007\u0003\u0005wQ1A!\u0010W\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0005\u0003\u0012YDA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fIF+X-^3\u0011\u0007]\u0012)%C\u0002\u0003H\t\u00111b\u00144gg\u0016$(+\u00198hK\"A!1\n\u0001!\u0002\u0013\u00119$\u0001\u0007d_6l\u0017\u000e^)vKV,\u0007\u0005C\u0005\u0003P\u0001\u0011\r\u0011\"\u0005\u0003R\u0005q1m\\7nSR\u001c\u0015\r\u001c7cC\u000e\\WC\u0001B*!\u0019\u0011)Fa\u0017\u0003`5\u0011!q\u000b\u0006\u0005\u00053\u0012Y$\u0001\u0004bi>l\u0017nY\u0005\u0005\u0005;\u00129FA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\r)\"\u0011M\u0005\u0004\u0005G2\"\u0001F(gMN,GoQ8n[&$8)\u00197mE\u0006\u001c7\u000e\u0003\u0005\u0003h\u0001\u0001\u000b\u0011\u0002B*\u0003=\u0019w.\\7ji\u000e\u000bG\u000e\u001c2bG.\u0004\u0003b\u0002B6\u0001\u0011\u0005!QN\u0001\fG>lW.\u001b;Bgft7\r\u0006\u0003\u0002\u0006\t=\u0004\u0002\u0003B9\u0005S\u0002\rAa\u001d\u0002\u0019=4gm]3u%\u0006tw-Z:\u0011\u000b\u0015\niJa\u0011\t\u000f\t-\u0004\u0001\"\u0001\u0003xQ1\u0011Q\u0001B=\u0005wB\u0001B!\u001d\u0003v\u0001\u0007!1\u000f\u0005\t\u0005{\u0012)\b1\u0001\u0003`\u0005A1-\u00197mE\u0006\u001c7\u000eC\u0004\u0003\u0002\u0002!\t\"a1\u0002\u0013\r|W.\\5u\u00032dga\u0002BC\u0001\u0001!!q\u0011\u0002\u001a\t&\u0014Xm\u0019;LC\u001a\\\u0017MU1uK\u000e{g\u000e\u001e:pY2,'o\u0005\u0003\u0003\u0004\u0006U\u0007\"\u0004BF\u0005\u0007\u0013\t\u0011)A\u0005\u0003O\u0013i)\u0001\u0002jI&!!qRAo\u0003%\u0019HO]3b[VKE\tC\u0006\u0003\u0014\n\r%\u0011!Q\u0001\n\tU\u0015!C3ti&l\u0017\r^8s!\u0011\u00119J!(\u000e\u0005\te%\u0002\u0002BN\u00033\fAA]1uK&!!q\u0014BM\u00055\u0011\u0016\r^3FgRLW.\u0019;pe\"91Ja!\u0005\u0002\t\rFC\u0002BS\u0005O\u0013I\u000b\u0005\u0003\u0002t\t\r\u0005\u0002\u0003BF\u0005C\u0003\r!a*\t\u0011\tM%\u0011\u0015a\u0001\u0005+C\u0001B!,\u0003\u0004\u0012\u0005#qV\u0001\baV\u0014G.[:i)\u0011\t)A!-\t\u000f\tm%1\u0016a\u0001y\u0002")
public class DirectKafkaInputDStream<K, V>
extends InputDStream<ConsumerRecord<K, V>>
implements CanCommitOffsets {
    private final LocationStrategy locationStrategy;
    private final ConsumerStrategy<K, V> consumerStrategy;
    private final HashMap<String, Object> executorKafkaParams;
    private scala.collection.immutable.Map<TopicPartition, Object> currentOffsets;
    private transient Consumer<K, V> kc;
    private final DirectKafkaInputDStreamCheckpointData checkpointData;
    private final Option<RateController> rateController;
    private final int org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$maxRateLimitPerPartition;
    private final ConcurrentLinkedQueue<OffsetRange> commitQueue;
    private final AtomicReference<OffsetCommitCallback> commitCallback;

    public HashMap<String, Object> executorKafkaParams() {
        return this.executorKafkaParams;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> currentOffsets() {
        return this.currentOffsets;
    }

    public void currentOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.currentOffsets = x$1;
    }

    private Consumer<K, V> kc() {
        return this.kc;
    }

    private void kc_$eq(Consumer<K, V> x$1) {
        this.kc = x$1;
    }

    public synchronized Consumer<K, V> consumer() {
        if (this.kc() == null) {
            this.kc_$eq(this.consumerStrategy.onStart((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.currentOffsets().mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Long apply(long l) {
                    return new Long(l);
                }
            })).asJava()));
        }
        return this.kc();
    }

    public DStream<ConsumerRecord<K, V>> persist(StorageLevel newLevel) {
        this.logError((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window";
            }
        });
        return super.persist(newLevel);
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<TopicPartition, String> getBrokers() {
        void var2_2;
        Consumer<K, V> c = this.consumer();
        HashMap result = new HashMap();
        HashMap<TopicPartition, String> hosts = new HashMap<TopicPartition, String>();
        for (TopicPartition tp : c.assignment()) {
            if (hosts.get(tp) == null) {
                for (PartitionInfo i : c.partitionsFor(tp.topic())) {
                    hosts.put(new TopicPartition(i.topic(), i.partition()), i.leader().host());
                }
            }
            result.put(tp, hosts.get(tp));
        }
        return var2_2;
    }

    public java.util.Map<TopicPartition, String> getPreferredHosts() {
        LocationStrategy locationStrategy;
        block5: {
            java.util.Map<Object, String> map;
            block3: {
                block4: {
                    block2: {
                        locationStrategy = this.locationStrategy;
                        if (!PreferBrokers$.MODULE$.equals(locationStrategy)) break block2;
                        map = this.getBrokers();
                        break block3;
                    }
                    if (!PreferConsistent$.MODULE$.equals(locationStrategy)) break block4;
                    map = Collections.emptyMap();
                    break block3;
                }
                if (!(locationStrategy instanceof PreferFixed)) break block5;
                PreferFixed preferFixed = (PreferFixed)locationStrategy;
                java.util.Map<TopicPartition, String> hostMap = preferFixed.hostMap();
                map = hostMap;
            }
            return map;
        }
        throw new MatchError((Object)locationStrategy);
    }

    public String name() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kafka 0.09 direct stream [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())}));
    }

    public DirectKafkaInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    public Option<RateController> rateController() {
        return this.rateController;
    }

    public int org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$maxRateLimitPerPartition() {
        return this.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$maxRateLimitPerPartition;
    }

    public Option<scala.collection.immutable.Map<TopicPartition, Object>> maxMessagesPerPartition(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        Option option;
        block7: {
            None$ none$;
            scala.collection.immutable.Map map;
            block6: {
                block5: {
                    Option estimatedRateLimit = this.rateController().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(RateController x$1) {
                            return (int)x$1.getLatestRate();
                        }
                    });
                    option = estimatedRateLimit.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(int x$2) {
                            return this.apply$mcZI$sp(x$2);
                        }

                        public boolean apply$mcZI$sp(int x$2) {
                            return x$2 > 0;
                        }
                    });
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    int rate = BoxesRunTime.unboxToInt((Object)some.x());
                    scala.collection.immutable.Map lagPerPartition = (scala.collection.immutable.Map)offsets.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;

                        public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$1) {
                            Tuple2<TopicPartition, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                TopicPartition tp = (TopicPartition)tuple2._1();
                                long offset = tuple2._2$mcJ$sp();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max(offset - BoxesRunTime.unboxToLong((Object)this.$outer.currentOffsets().apply((Object)tp)), 0L)));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    long totalLag = BoxesRunTime.unboxToLong((Object)lagPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    map = (scala.collection.immutable.Map)lagPerPartition.map((Function1)new Serializable(this, rate, totalLag){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;
                        private final int rate$1;
                        private final long totalLag$1;

                        public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$2) {
                            Tuple2<TopicPartition, Object> tuple2 = x0$2;
                            if (tuple2 != null) {
                                TopicPartition tp = (TopicPartition)tuple2._1();
                                long lag = tuple2._2$mcJ$sp();
                                int backpressureRate = Math.round((float)((double)lag / (double)this.totalLag$1) * (float)this.rate$1);
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)(this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$maxRateLimitPerPartition() > 0 ? BoxesRunTime.boxToInteger((int)Math.min(backpressureRate, this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$maxRateLimitPerPartition())) : BoxesRunTime.boxToInteger((int)backpressureRate)));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rate$1 = rate$1;
                            this.totalLag$1 = totalLag$1;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    break block6;
                }
                if (!None$.MODULE$.equals(option)) break block7;
                map = (scala.collection.immutable.Map)offsets.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DirectKafkaInputDStream $outer;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$3) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$maxRateLimitPerPartition()));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            scala.collection.immutable.Map effectiveRateLimitPerPartition = map;
            if (BoxesRunTime.unboxToInt((Object)effectiveRateLimitPerPartition.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                double secsPerBatch = (double)this.context().graph().batchDuration().milliseconds() / (double)1000;
                none$ = new Some(effectiveRateLimitPerPartition.map((Function1)new Serializable(this, secsPerBatch){
                    public static final long serialVersionUID = 0L;
                    private final double secsPerBatch$1;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$4) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$4;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            int limit = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)((long)(this.secsPerBatch$1 * (double)limit))));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.secsPerBatch$1 = secsPerBatch$1;
                    }
                }, Map$.MODULE$.canBuildFrom()));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)option);
    }

    public long org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$adjustPosition(TopicPartition tp) {
        long l;
        Consumer<K, V> c = this.consumer();
        long pos = c.position(tp);
        if (pos == 0L) {
            boolean isStreams;
            boolean bl = isStreams = tp.topic().startsWith("/") || tp.topic().contains(":");
            l = isStreams ? 1L : 0L;
        } else {
            l = pos;
        }
        return l;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> latestOffsets() {
        Consumer<K, V> c = this.consumer();
        Set parts = (Set)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala();
        Set newPartitions = (Set)parts.diff((GenSet)this.currentOffsets().keySet());
        this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)this.currentOffsets().$plus$plus((GenTraversableOnce)((TraversableOnce)newPartitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectKafkaInputDStream $outer;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$adjustPosition(tp)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
        c.pause((TopicPartition[])newPartitions.toArray(ClassTag$.MODULE$.apply(TopicPartition.class)));
        c.seekToEnd((TopicPartition[])this.currentOffsets().keySet().toArray(ClassTag$.MODULE$.apply(TopicPartition.class)));
        return ((TraversableOnce)parts.map((Function1)new Serializable(this, c){
            public static final long serialVersionUID = 0L;
            private final Consumer c$1;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.c$1.position(tp)));
            }
            {
                this.c$1 = c$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, Object> clamp(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        return (scala.collection.immutable.Map)this.maxMessagesPerPartition(offsets).map((Function1)new Serializable(this, offsets){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectKafkaInputDStream $outer;
            public final scala.collection.immutable.Map offsets$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply(scala.collection.immutable.Map<TopicPartition, Object> mmp) {
                return (scala.collection.immutable.Map)mmp.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$clamp$1 $outer;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$5) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$5;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            long messages = tuple2._2$mcJ$sp();
                            long uo = BoxesRunTime.unboxToLong((Object)this.$outer.offsets$1.apply((Object)tp));
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.min(BoxesRunTime.unboxToLong((Object)this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$anonfun$$$outer().currentOffsets().apply((Object)tp)) + messages, uo)));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsets$1 = offsets$1;
            }
        }).getOrElse((Function0)new Serializable(this, offsets){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map offsets$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply() {
                return this.offsets$1;
            }
            {
                this.offsets$1 = offsets$1;
            }
        });
    }

    public Option<KafkaRDD<K, V>> compute(Time validTime) {
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = this.clamp(this.latestOffsets());
        Iterable offsetRanges = (Iterable)untilOffsets.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectKafkaInputDStream $outer;

            public final OffsetRange apply(Tuple2<TopicPartition, Object> x0$6) {
                Tuple2<TopicPartition, Object> tuple2 = x0$6;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long uo = tuple2._2$mcJ$sp();
                    long fo = BoxesRunTime.unboxToLong((Object)this.$outer.currentOffsets().apply((Object)tp));
                    OffsetRange offsetRange = OffsetRange$.MODULE$.apply(tp.topic(), tp.partition(), fo, uo);
                    return offsetRange;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        KafkaRDD rdd = new KafkaRDD(this.context().sparkContext(), this.executorKafkaParams(), (OffsetRange[])offsetRanges.toArray(ClassTag$.MODULE$.apply(OffsetRange.class)), this.getPreferredHosts(), true);
        String description = ((TraversableOnce)((TraversableLike)offsetRanges.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(OffsetRange offsetRange) {
                return offsetRange.fromOffset() != offsetRange.untilOffset();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(OffsetRange offsetRange) {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic: ", "\\tpartition: ", "\\t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offsetRange.topic(), BoxesRunTime.boxToInteger((int)offsetRange.partition())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offsets: ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offsetRange.fromOffset()), BoxesRunTime.boxToLong((long)offsetRange.untilOffset())}))).toString();
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsets"), (Object)offsetRanges.toList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), (Object)description)}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), rdd.count(), metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        this.currentOffsets_$eq(untilOffsets);
        this.commitAll();
        return new Some(rdd);
    }

    public void start() {
        Consumer<K, V> c = this.consumer();
        c.poll(0L);
        if (this.currentOffsets().isEmpty()) {
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStream $outer;

                public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$adjustPosition(tp)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        c.pause((TopicPartition[])this.currentOffsets().keySet().toArray(ClassTag$.MODULE$.apply(TopicPartition.class)));
    }

    public synchronized void stop() {
        if (this.kc() != null) {
            this.kc().close();
        }
    }

    public ConcurrentLinkedQueue<OffsetRange> commitQueue() {
        return this.commitQueue;
    }

    public AtomicReference<OffsetCommitCallback> commitCallback() {
        return this.commitCallback;
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges) {
        this.commitAsync(offsetRanges, null);
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges, OffsetCommitCallback callback) {
        this.commitCallback().set(callback);
        this.commitQueue().addAll(Arrays.asList((Object[])offsetRanges));
    }

    public void commitAll() {
        HashMap<TopicPartition, OffsetAndMetadata> m = new HashMap<TopicPartition, OffsetAndMetadata>();
        for (OffsetRange osr : this.commitQueue()) {
            TopicPartition tp = osr.topicPartition();
            OffsetAndMetadata x = (OffsetAndMetadata)m.get(tp);
            long offset = x == null ? osr.untilOffset() : Math.max(x.offset(), osr.untilOffset());
            m.put(tp, new OffsetAndMetadata(offset));
        }
        if (!m.isEmpty()) {
            this.consumer().commitAsync(m, this.commitCallback().get());
        }
    }

    public DirectKafkaInputDStream(StreamingContext _ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy) {
        this.locationStrategy = locationStrategy;
        this.consumerStrategy = consumerStrategy;
        super(_ssc, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        HashMap<String, Object> ekp = new HashMap<String, Object>(consumerStrategy.executorKafkaParams());
        KafkaUtils$.MODULE$.fixKafkaParams(ekp);
        this.executorKafkaParams = ekp;
        this.currentOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.kc = null;
        this.checkpointData = new DirectKafkaInputDStreamCheckpointData();
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some((Object)new DirectKafkaRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.context().graph().batchDuration()))) : None$.MODULE$;
        this.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$$maxRateLimitPerPartition = this.context().sparkContext().getConf().getInt("spark.streaming.kafka.maxRatePerPartition", 0);
        this.commitQueue = new ConcurrentLinkedQueue();
        this.commitCallback = new AtomicReference();
    }

    public class DirectKafkaRateController
    extends RateController {
        public void publish(long rate) {
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaRateController$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaRateController(int id, RateEstimator estimator) {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }

    public class DirectKafkaInputDStreamCheckpointData
    extends DStreamCheckpointData<ConsumerRecord<K, V>> {
        public scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> batchForTime() {
            return this.data();
        }

        public void update(Time time) {
            this.batchForTime().clear();
            this.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStreamCheckpointData $outer;

                public final scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> apply(Tuple2<Time, RDD<ConsumerRecord<K, V>>> kv) {
                    Tuple4[] a = (Tuple4[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((KafkaRDD)kv._2()).offsetRanges()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple4<String, Object, Object, Object> apply(OffsetRange x$3) {
                            return x$3.toTuple();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class)))).toArray(ClassTag$.MODULE$.apply(Tuple4.class));
                    return this.$outer.batchForTime().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)a));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public void cleanup(Time time) {
        }

        public void restore() {
            ((IterableLike)this.batchForTime().toSeq().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Time apply(Tuple2<Time, Tuple4<String, Object, Object, Object>[]> x$4) {
                    return (Time)x$4._1();
                }
            }, Time$.MODULE$.ordering())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStreamCheckpointData $outer;

                public final scala.collection.mutable.HashMap<Time, RDD<ConsumerRecord<K, V>>> apply(Tuple2<Time, Tuple4<String, Object, Object, Object>[]> x0$7) {
                    Tuple2<Time, Tuple4<String, Object, Object, Object>[]> tuple2 = x0$7;
                    if (tuple2 != null) {
                        Time t = (Time)tuple2._1();
                        Tuple4[] b = (Tuple4[])tuple2._2();
                        this.$outer.logInfo((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final Time t$1;
                            private final Tuple4[] b$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restoring KafkaRDD for time ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.t$1, Predef$.MODULE$.refArrayOps((Object[])this.b$1).mkString("[", ", ", "]")}));
                            }
                            {
                                this.t$1 = t$1;
                                this.b$1 = b$1;
                            }
                        });
                        scala.collection.mutable.HashMap hashMap = this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), new KafkaRDD<K, V>(this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().context().sparkContext(), this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().executorKafkaParams(), (OffsetRange[])Predef$.MODULE$.refArrayOps((Object[])b).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final OffsetRange apply(Tuple4<String, Object, Object, Object> x$5) {
                                return OffsetRange$.MODULE$.apply(x$5);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OffsetRange.class))), this.$outer.org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().getPreferredHosts(), false)));
                        return hashMap;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka09$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaInputDStreamCheckpointData() {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(DirectKafkaInputDStream.this, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        }
    }
}

