/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client;

import java.io.File;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbClient;
import org.apache.kerby.kerberos.kerb.client.KrbClientBase;
import org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.apache.kerby.kerberos.kerb.client.KrbOption;
import org.apache.kerby.kerberos.kerb.client.TokenOption;
import org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;

public class KrbTokenClient
extends KrbClientBase {
    public KrbTokenClient() throws KrbException {
    }

    public KrbTokenClient(KrbConfig krbConfig) {
        super(krbConfig);
    }

    public KrbTokenClient(File confDir) throws KrbException {
        super(confDir);
    }

    public KrbTokenClient(KrbClient krbClient) {
        super(krbClient);
    }

    public TgtTicket requestTgt(AuthToken token, String armorCache) throws KrbException {
        if (!token.isIdToken()) {
            throw new IllegalArgumentException("Identity token is expected");
        }
        KOptions requestOptions = new KOptions();
        requestOptions.add(TokenOption.USER_ID_TOKEN, token);
        requestOptions.add(KrbOption.ARMOR_CACHE, armorCache);
        return this.requestTgt(requestOptions);
    }

    public TgtTicket requestTgt(AuthToken token, TgtTicket tgt) throws KrbException {
        if (!token.isIdToken()) {
            throw new IllegalArgumentException("Identity token is expected");
        }
        KOptions requestOptions = new KOptions();
        requestOptions.add(TokenOption.USER_ID_TOKEN, token);
        requestOptions.add(KrbOption.TGT, tgt);
        return this.requestTgt(requestOptions);
    }

    public SgtTicket requestSgt(AuthToken token, String serverPrincipal, String armorCache) throws KrbException {
        if (!token.isAcToken()) {
            throw new IllegalArgumentException("Access token is expected");
        }
        KOptions requestOptions = new KOptions();
        requestOptions.add(TokenOption.USER_AC_TOKEN, token);
        requestOptions.add(KrbOption.ARMOR_CACHE, armorCache);
        requestOptions.add(KrbOption.SERVER_PRINCIPAL, serverPrincipal);
        return this.requestSgt(requestOptions);
    }
}

