/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.hadoop.util.PlatformName;
import org.apache.kerby.kerberos.kerb.keytab.Keytab;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.log4j.Logger;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class KerberosUtil {
    private static final Logger LOG = Logger.getLogger(KerberosUtil.class);

    public static String getKrb5LoginModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "org.apache.hadoop.security.login.KerberosBugWorkAroundLoginModule";
    }

    public static Oid getOidInstance(String oidName) throws ClassNotFoundException, GSSException, NoSuchFieldException, IllegalAccessException {
        Class<?> oidClass;
        if (PlatformName.IBM_JAVA) {
            if ("NT_GSS_KRB5_PRINCIPAL".equals(oidName)) {
                return new Oid("1.2.840.113554.1.2.2.1");
            }
            oidClass = Class.forName("com.ibm.security.jgss.GSSUtil");
        } else {
            oidClass = Class.forName("sun.security.jgss.GSSUtil");
        }
        Field oidField = oidClass.getDeclaredField(oidName);
        return (Oid)oidField.get(oidClass);
    }

    public static String getDefaultRealm() throws ClassNotFoundException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return new KerberosPrincipal("tmp", 1).getRealm();
    }

    public static String getDefaultRealmProtected() {
        try {
            return KerberosUtil.getDefaultRealm();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getDomainRealm(String shortprinc) {
        String realmString = null;
        try {
            Class<?> classRef = PlatformName.IBM_JAVA ? Class.forName("com.ibm.security.krb5.PrincipalName") : Class.forName("sun.security.krb5.PrincipalName");
            int tKrbNtSrvHst = classRef.getField("KRB_NT_SRV_HST").getInt(null);
            Object principalName = classRef.getConstructor(String.class, Integer.TYPE).newInstance(shortprinc, tKrbNtSrvHst);
            realmString = (String)classRef.getMethod("getRealmString", new Class[0]).invoke(principalName, new Object[0]);
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == realmString || realmString.equals("")) {
            return KerberosUtil.getDefaultRealmProtected();
        }
        return realmString;
    }

    static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static final String getServicePrincipal(String service, String hostname) throws UnknownHostException {
        String fqdn = hostname;
        if (null == fqdn || fqdn.equals("") || fqdn.equals("0.0.0.0")) {
            fqdn = KerberosUtil.getLocalHostName();
        }
        return service + "/" + fqdn.toLowerCase(Locale.ENGLISH);
    }

    static final String[] getPrincipalNames(String keytabFileName) throws IOException {
        Keytab keytab = Keytab.loadKeytab(new File(keytabFileName));
        HashSet<String> principals = new HashSet<String>();
        List<PrincipalName> entries = keytab.getPrincipals();
        for (PrincipalName entry : entries) {
            principals.add(entry.getName().replace("\\", "/"));
        }
        return principals.toArray(new String[0]);
    }

    public static final String[] getPrincipalNames(String keytab, Pattern pattern) throws IOException {
        String[] principals = KerberosUtil.getPrincipalNames(keytab);
        if (principals.length != 0) {
            ArrayList<String> matchingPrincipals = new ArrayList<String>();
            for (String principal : principals) {
                if (!pattern.matcher(principal).matches()) continue;
                matchingPrincipals.add(principal);
            }
            principals = matchingPrincipals.toArray(new String[0]);
        }
        return principals;
    }

    public static void checkJCEKeyStrength() {
        try {
            if (Cipher.getMaxAllowedKeyLength("AES") != Integer.MAX_VALUE) {
                LOG.warn((Object)"JCE Unlimited Strength Jurisdiction Policy Files are not installed. This could cause authentication failures.");
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn((Object)e.getMessage());
        }
    }
}

