/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.server.handler.jmx;

import java.util.HashMap;
import java.util.Map;
import org.spark_project.jetty.server.handler.ContextHandler;
import org.spark_project.jetty.server.handler.jmx.AbstractHandlerMBean;
import org.spark_project.jetty.util.Attributes;
import org.spark_project.jetty.util.annotation.ManagedAttribute;
import org.spark_project.jetty.util.annotation.ManagedObject;
import org.spark_project.jetty.util.annotation.ManagedOperation;
import org.spark_project.jetty.util.annotation.Name;

@ManagedObject(value="ContextHandler mbean wrapper")
public class ContextHandlerMBean
extends AbstractHandlerMBean {
    public ContextHandlerMBean(Object managedObject) {
        super(managedObject);
    }

    @ManagedAttribute(value="Map of context attributes")
    public Map<String, Object> getContextAttributes() {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        Attributes attrs = ((ContextHandler)this._managed).getAttributes();
        for (String name : attrs.getAttributeNameSet()) {
            Object value2 = attrs.getAttribute(name);
            map2.put(name, value2);
        }
        return map2;
    }

    @ManagedOperation(value="Set context attribute", impact="ACTION")
    public void setContextAttribute(@Name(value="name", description="attribute name") String name, @Name(value="value", description="attribute value") Object value2) {
        Attributes attrs = ((ContextHandler)this._managed).getAttributes();
        attrs.setAttribute(name, value2);
    }

    @ManagedOperation(value="Set context attribute", impact="ACTION")
    public void setContextAttribute(@Name(value="name", description="attribute name") String name, @Name(value="value", description="attribute value") String value2) {
        Attributes attrs = ((ContextHandler)this._managed).getAttributes();
        attrs.setAttribute(name, value2);
    }

    @ManagedOperation(value="Remove context attribute", impact="ACTION")
    public void removeContextAttribute(@Name(value="name", description="attribute name") String name) {
        Attributes attrs = ((ContextHandler)this._managed).getAttributes();
        attrs.removeAttribute(name);
    }
}

