/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.xdr.type;

import java.nio.ByteBuffer;
import org.apache.kerby.xdr.XdrDataType;
import org.apache.kerby.xdr.type.XdrSimple;

public class XdrInteger
extends XdrSimple<Integer> {
    public XdrInteger() {
        this((Integer)null);
    }

    public XdrInteger(Integer value2) {
        super(XdrDataType.INTEGER, value2);
    }

    @Override
    protected int encodingBodyLength() {
        return 4;
    }

    @Override
    protected void toBytes() {
        int value2 = (Integer)this.getValue();
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value2);
        buffer.flip();
        this.setBytes(buffer.array());
    }

    @Override
    protected void toValue() {
        if (this.getBytes().length != 4) {
            byte[] intBytes = ByteBuffer.allocate(4).put(this.getBytes(), 0, 4).array();
            this.setBytes(intBytes);
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.getBytes());
        this.setValue(buffer.getInt());
    }
}

