/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.xdr.type;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kerby.xdr.XdrDataType;
import org.apache.kerby.xdr.type.XdrSimple;

public class XdrBoolean
extends XdrSimple<Boolean> {
    private static final byte[] TRUE_BYTE = new byte[]{0, 0, 0, 1};
    private static final byte[] FALSE_BYTE = new byte[]{0, 0, 0, 0};
    public static final XdrBoolean TRUE = new XdrBoolean(true);
    public static final XdrBoolean FALSE = new XdrBoolean(false);

    public XdrBoolean() {
        this((Boolean)null);
    }

    public XdrBoolean(Boolean value2) {
        super(XdrDataType.BOOLEAN, value2);
    }

    @Override
    protected int encodingBodyLength() {
        return 4;
    }

    @Override
    protected void toBytes() {
        this.setBytes((Boolean)this.getValue() != false ? TRUE_BYTE : FALSE_BYTE);
    }

    @Override
    protected void toValue() throws IOException {
        byte[] bytes;
        if (this.getBytes().length != 4) {
            byte[] boolBytes = ByteBuffer.allocate(4).put(this.getBytes(), 0, 4).array();
            this.setBytes(boolBytes);
        }
        if (Arrays.equals(bytes = this.getBytes(), TRUE_BYTE)) {
            this.setValue(true);
        } else if (Arrays.equals(bytes, FALSE_BYTE)) {
            this.setValue(false);
        } else {
            throw new IOException("Fail to decode boolean type: " + Arrays.toString(bytes));
        }
    }
}

