/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.preauth.pkinit;

import org.apache.kerby.kerberos.kerb.preauth.pkinit.IdentityOpts;
import org.apache.kerby.kerberos.kerb.preauth.pkinit.IdentityType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public class PkinitIdenity {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void processIdentityOption(IdentityOpts identityOpts, String value2) {
        IdentityType idType = IdentityType.NONE;
        String residual = null;
        if (value2.contains(":")) {
            if (value2.startsWith("FILE:")) {
                idType = IdentityType.FILE;
            } else if (value2.startsWith("PKCS11:")) {
                idType = IdentityType.PKCS11;
            } else if (value2.startsWith("PKCS12:")) {
                idType = IdentityType.PKCS12;
            } else if (value2.startsWith("DIR:")) {
                idType = IdentityType.DIR;
            } else {
                if (!value2.startsWith("ENV:")) throw new RuntimeException("Invalid Identity option format: " + value2);
                idType = IdentityType.ENVVAR;
            }
        } else {
            residual = value2;
            idType = IdentityType.FILE;
        }
        identityOpts.idType = idType;
        switch (idType) {
            case ENVVAR: {
                PkinitIdenity.processIdentityOption(identityOpts, System.getenv(residual));
                return;
            }
            case FILE: {
                PkinitIdenity.parseFileOption(identityOpts, residual);
                return;
            }
            case PKCS11: {
                PkinitIdenity.parsePkcs11Option(identityOpts, residual);
                return;
            }
            case PKCS12: {
                PkinitIdenity.parsePkcs12Option(identityOpts, residual);
                return;
            }
            case DIR: {
                identityOpts.certFile = residual;
                return;
            }
        }
    }

    public static void parseFileOption(IdentityOpts identityOpts, String residual) {
        String[] parts = residual.split(",");
        String certName = parts[0];
        String keyName = null;
        if (parts.length > 1) {
            keyName = parts[1];
        }
        identityOpts.certFile = certName;
        identityOpts.keyFile = keyName;
    }

    public static void parsePkcs12Option(IdentityOpts identityOpts, String residual) {
        identityOpts.certFile = residual;
        identityOpts.keyFile = residual;
    }

    public static void parsePkcs11Option(IdentityOpts identityOpts, String residual) {
    }

    public static void loadCerts(IdentityOpts identityOpts, PrincipalName principal) {
        switch (identityOpts.idType) {
            case FILE: {
                PkinitIdenity.loadCertsFromFile(identityOpts, principal);
                break;
            }
            case DIR: {
                PkinitIdenity.loadCertsFromDir(identityOpts, principal);
                break;
            }
            case PKCS11: {
                PkinitIdenity.loadCertsAsPkcs11(identityOpts, principal);
                break;
            }
            case PKCS12: {
                PkinitIdenity.loadCertsAsPkcs12(identityOpts, principal);
                break;
            }
        }
    }

    private static void loadCertsAsPkcs12(IdentityOpts identityOpts, PrincipalName principal) {
    }

    private static void loadCertsAsPkcs11(IdentityOpts identityOpts, PrincipalName principal) {
    }

    private static void loadCertsFromDir(IdentityOpts identityOpts, PrincipalName principal) {
    }

    private static void loadCertsFromFile(IdentityOpts identityOpts, PrincipalName principal) {
    }

    public static void initialize(IdentityOpts identityOpts, PrincipalName principal) {
    }
}

