/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.crypto.key;

import java.io.UnsupportedEncodingException;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.crypto.enc.EncryptProvider;
import org.apache.kerby.kerberos.kerb.crypto.key.AbstractKeyMaker;
import org.apache.kerby.kerberos.kerb.crypto.util.Md4;

public class Rc4KeyMaker
extends AbstractKeyMaker {
    public Rc4KeyMaker(EncryptProvider encProvider) {
        super(encProvider);
    }

    @Override
    public byte[] str2key(String string2, String salt, byte[] param) throws KrbException {
        if (param != null && param.length > 0) {
            throw new RuntimeException("Invalid param to str2Key");
        }
        try {
            byte[] passwd = string2.getBytes("UTF-16LE");
            Md4 md = new Md4();
            md.update(passwd);
            return md.digest();
        }
        catch (UnsupportedEncodingException e) {
            throw new KrbException("str2key failed", (Throwable)e);
        }
    }

    @Override
    public byte[] random2Key(byte[] randomBits) throws KrbException {
        if (randomBits.length != this.encProvider().keyInputSize()) {
            throw new KrbException("Invalid random bits, not of correct bytes size");
        }
        return randomBits;
    }
}

