/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.EtypeInfo;
import org.apache.kerby.kerberos.kerb.type.base.EtypeInfo2;
import org.apache.kerby.kerberos.kerb.type.base.EtypeInfo2Entry;
import org.apache.kerby.kerberos.kerb.type.base.EtypeInfoEntry;
import org.apache.kerby.kerberos.kerb.type.base.KrbError;
import org.apache.kerby.kerberos.kerb.type.base.MethodData;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataType;

public class KrbErrorUtil {
    public static List<EncryptionType> getEtypes(KrbError error) throws IOException {
        MethodData methodData = new MethodData();
        methodData.decode(error.getEdata());
        for (PaDataEntry pd : methodData.getElements()) {
            if (pd.getPaDataType() == PaDataType.ETYPE_INFO2) {
                return KrbErrorUtil.getEtypes2(pd.getPaDataValue());
            }
            if (pd.getPaDataType() != PaDataType.ETYPE_INFO) continue;
            return KrbErrorUtil.getEtypes(pd.getPaDataValue());
        }
        return Collections.emptyList();
    }

    private static List<EncryptionType> getEtypes(byte[] data) throws IOException {
        EtypeInfo info = new EtypeInfo();
        info.decode(data);
        ArrayList<EncryptionType> results = new ArrayList<EncryptionType>();
        for (EtypeInfoEntry entry2 : info.getElements()) {
            results.add(entry2.getEtype());
        }
        return results;
    }

    private static List<EncryptionType> getEtypes2(byte[] data) throws IOException {
        EtypeInfo2 info2 = new EtypeInfo2();
        info2.decode(data);
        ArrayList<EncryptionType> results = new ArrayList<EncryptionType>();
        for (EtypeInfo2Entry entry2 : info2.getElements()) {
            results.add(entry2.getEtype());
        }
        return results;
    }
}

