/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class Krb5Parser {
    private File krb5conf;
    private Map<String, Object> items;

    public Krb5Parser(File confFile) {
        this.krb5conf = confFile;
        this.items = null;
    }

    public void load() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(this.krb5conf.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
        this.items = new IdentityHashMap<String, Object>();
        String originLine = br.readLine();
        while (originLine != null) {
            String line = originLine.trim();
            if (line.startsWith("#") || line.length() == 0) {
                originLine = br.readLine();
                continue;
            }
            if (line.startsWith("[")) {
                this.insertSections(line, br, this.items);
                originLine = br.readLine();
                continue;
            }
            if (line.startsWith("include")) {
                String[] splited = line.trim().split("\\s+");
                if (splited.length != 2) {
                    throw new RuntimeException("Unable to parse:" + originLine);
                }
                this.items.put(splited[0], splited[1]);
                originLine = br.readLine();
                continue;
            }
            throw new RuntimeException("Unable to parse:" + originLine);
        }
        br.close();
    }

    public Map<String, Object> getItems() {
        return this.items;
    }

    public List<String> getSections() {
        ArrayList<String> al = new ArrayList<String>(this.items.keySet());
        return al;
    }

    public Object getSection(String sectionName, String ... keys) {
        Object value2 = null;
        for (Map.Entry<String, Object> item : this.items.entrySet()) {
            if (!item.getKey().equals(sectionName)) continue;
            value2 = item.getValue();
            if (keys.length == 0) {
                return value2;
            }
            Map map2 = (Map)item.getValue();
            for (Map.Entry entry2 : map2.entrySet()) {
                if (!((String)entry2.getKey()).equals(keys[0])) continue;
                value2 = entry2.getValue();
            }
        }
        for (int i = 1; i < keys.length; ++i) {
            Map map3 = (Map)value2;
            for (Map.Entry entry3 : map3.entrySet()) {
                if (!((String)entry3.getKey()).equals(keys[i])) continue;
                value2 = entry3.getValue();
            }
        }
        return value2;
    }

    public void dump() {
        this.printSection(this.items);
    }

    private void insertSections(String line, BufferedReader br, Map<String, Object> items) throws IOException {
        while (line.startsWith("[")) {
            String sectionName = line.substring(1, line.length() - 1);
            IdentityHashMap<String, Object> entries = new IdentityHashMap<String, Object>();
            line = br.readLine();
            if (line == null) break;
            while (line.startsWith("#") && (line = br.readLine()) != null) {
            }
            if (line != null) {
                line = line.trim();
                line = this.insertEntries(line, br, entries);
                items.put(sectionName, entries);
            }
            if (line != null) continue;
            break;
        }
    }

    private String insertEntries(String line, BufferedReader br, Map<String, Object> entries) throws IOException {
        if (line == null) {
            return line;
        }
        if (line.startsWith("[")) {
            return line;
        }
        if (line.startsWith("}")) {
            line = br.readLine();
            if (line != null) {
                line = line.trim();
            }
            return line;
        }
        if (line.length() == 0 || line.startsWith("#")) {
            line = br.readLine();
            if (line != null) {
                line = line.trim();
                line = this.insertEntries(line, br, entries);
            }
            return line;
        }
        String[] kv = line.split("=", 2);
        kv[0] = kv[0].trim();
        kv[1] = kv[1].trim();
        if (kv[1].startsWith("{")) {
            IdentityHashMap<String, Object> meValue = new IdentityHashMap<String, Object>();
            line = br.readLine();
            if (line != null) {
                line = line.trim();
                line = this.insertEntries(line, br, meValue);
                entries.put(kv[0], meValue);
                line = this.insertEntries(line, br, entries);
            }
        } else {
            entries.put(kv[0], kv[1]);
            line = br.readLine();
            if (line != null) {
                line = line.trim();
                line = this.insertEntries(line, br, entries);
            }
        }
        return line;
    }

    private void printSection(Map<String, Object> map2) {
        for (Map.Entry<String, Object> entry2 : map2.entrySet()) {
            String key = entry2.getKey();
            Object value2 = entry2.getValue();
            System.out.println("[" + key + "]");
            if (value2 instanceof Map) {
                int count2 = 0;
                this.printEntry((Map)value2, count2);
                continue;
            }
            throw new RuntimeException("Unable to print contents of [" + key + "]");
        }
    }

    private void printEntry(Map<String, Object> map2, int count2) {
        for (Map.Entry<String, Object> entry2 : map2.entrySet()) {
            int i;
            String key = entry2.getKey();
            Object value2 = entry2.getValue();
            for (i = 0; i < count2; ++i) {
                System.out.print("\t");
            }
            if (value2 instanceof String) {
                System.out.println(key + " = " + (String)value2);
            }
            if (!(value2 instanceof Map)) continue;
            System.out.println(key + " = {");
            this.printEntry((Map)value2, count2 + 1);
            for (i = 0; i < count2; ++i) {
                System.out.print("\t");
            }
            System.out.println("}");
        }
    }
}

