/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client.preauth;

import java.util.ArrayList;
import java.util.List;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbContext;
import org.apache.kerby.kerberos.kerb.client.preauth.AbstractPreauthPlugin;
import org.apache.kerby.kerberos.kerb.client.preauth.KrbPreauth;
import org.apache.kerby.kerberos.kerb.client.preauth.PreauthContext;
import org.apache.kerby.kerberos.kerb.client.preauth.PreauthHandle;
import org.apache.kerby.kerberos.kerb.client.preauth.builtin.EncTsPreauth;
import org.apache.kerby.kerberos.kerb.client.preauth.builtin.TgtPreauth;
import org.apache.kerby.kerberos.kerb.client.preauth.pkinit.PkinitPreauth;
import org.apache.kerby.kerberos.kerb.client.preauth.token.TokenPreauth;
import org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import org.apache.kerby.kerberos.kerb.type.pa.PaData;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataType;

public class PreauthHandler {
    private KrbContext krbContext;
    private List<KrbPreauth> preauths;

    public void init(KrbContext krbContext) {
        this.krbContext = krbContext;
        this.loadPreauthPlugins(krbContext);
    }

    private void loadPreauthPlugins(KrbContext context) {
        this.preauths = new ArrayList<KrbPreauth>();
        AbstractPreauthPlugin preauth = new EncTsPreauth();
        preauth.init(context);
        this.preauths.add(preauth);
        preauth = new TgtPreauth();
        preauth.init(context);
        this.preauths.add(preauth);
        preauth = new PkinitPreauth();
        preauth.init(context);
        this.preauths.add(preauth);
        preauth = new TokenPreauth();
        preauth.init(context);
        this.preauths.add(preauth);
    }

    public PreauthContext preparePreauthContext(KdcRequest kdcRequest) {
        PreauthContext preauthContext = new PreauthContext();
        preauthContext.setPreauthRequired(this.krbContext.getConfig().isPreauthRequired());
        for (KrbPreauth preauth : this.preauths) {
            PreauthHandle handle2 = new PreauthHandle(preauth);
            handle2.initRequestContext(kdcRequest);
            preauthContext.getHandles().add(handle2);
        }
        return preauthContext;
    }

    public void preauth(KdcRequest kdcRequest) throws KrbException {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        if (!preauthContext.isPreauthRequired()) {
            return;
        }
        this.setPreauthOptions(kdcRequest, kdcRequest.getPreauthOptions());
        if (!preauthContext.hasInputPaData()) {
            this.tryFirst(kdcRequest, preauthContext.getOutputPaData());
            return;
        }
        this.prepareUserResponses(kdcRequest, preauthContext.getInputPaData());
        preauthContext.getUserResponser().respondQuestions();
        if (!kdcRequest.isRetrying()) {
            this.process(kdcRequest, preauthContext.getInputPaData(), preauthContext.getOutputPaData());
        } else {
            this.tryAgain(kdcRequest, preauthContext.getInputPaData(), preauthContext.getOutputPaData());
        }
    }

    public void prepareUserResponses(KdcRequest kdcRequest, PaData inPadata) throws KrbException {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        for (PaDataEntry pae : inPadata.getElements()) {
            PreauthHandle handle2;
            if (!preauthContext.isPaTypeAllowed(pae.getPaDataType()) || (handle2 = this.findHandle(kdcRequest, pae.getPaDataType())) == null) continue;
            handle2.prepareQuestions(kdcRequest);
        }
    }

    public void setPreauthOptions(KdcRequest kdcRequest, KOptions preauthOptions) throws KrbException {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        for (PreauthHandle handle2 : preauthContext.getHandles()) {
            handle2.setPreauthOptions(kdcRequest, preauthOptions);
        }
    }

    public void tryFirst(KdcRequest kdcRequest, PaData outPadata) throws KrbException {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        PreauthHandle handle2 = this.findHandle(kdcRequest, preauthContext.getAllowedPaType());
        handle2.tryFirst(kdcRequest, outPadata);
    }

    public void process(KdcRequest kdcRequest, PaData inPadata, PaData outPadata) throws KrbException {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        for (int real = 0; real <= 1; ++real) {
            for (PaDataEntry pae : inPadata.getElements()) {
                PreauthHandle handle2;
                if (real > 0 && !preauthContext.isPaTypeAllowed(pae.getPaDataType()) || (handle2 = this.findHandle(kdcRequest, preauthContext.getAllowedPaType())) == null || real > 0 && preauthContext.checkAndPutTried(pae.getPaDataType())) continue;
                boolean gotData = handle2.process(kdcRequest, pae, outPadata);
                if (real <= 0 || !gotData) continue;
                return;
            }
        }
    }

    public void tryAgain(KdcRequest kdcRequest, PaData inPadata, PaData outPadata) {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        for (PaDataEntry pae : inPadata.getElements()) {
            PreauthHandle handle2 = this.findHandle(kdcRequest, pae.getPaDataType());
            if (handle2 == null) continue;
            handle2.tryAgain(kdcRequest, pae.getPaDataType(), preauthContext.getErrorPaData(), outPadata);
        }
    }

    public void destroy() {
        for (KrbPreauth preauth : this.preauths) {
            preauth.destroy();
        }
    }

    private PreauthHandle findHandle(KdcRequest kdcRequest, PaDataType paType) {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        for (PreauthHandle handle2 : preauthContext.getHandles()) {
            for (PaDataType pt : handle2.preauth.getPaTypes()) {
                if (pt != paType) continue;
                return handle2;
            }
        }
        return null;
    }
}

