/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public abstract class KrbOutputStream
extends DataOutputStream {
    public KrbOutputStream(OutputStream out) {
        super(out);
    }

    public abstract void writePrincipal(PrincipalName var1, int var2) throws IOException;

    public void writeRealm(String realm) throws IOException {
        this.writeCountedString(realm);
    }

    public abstract void writeKey(EncryptionKey var1, int var2) throws IOException;

    public void writeTime(KerberosTime ktime) throws IOException {
        int time = 0;
        if (ktime != null) {
            time = (int)(((Date)ktime.getValue()).getTime() / 1000L);
        }
        this.writeInt(time);
    }

    public void writeCountedString(String string2) throws IOException {
        byte[] data = string2 != null ? string2.getBytes(StandardCharsets.UTF_8) : null;
        this.writeCountedOctets(data);
    }

    public void writeCountedOctets(byte[] data) throws IOException {
        if (data != null) {
            this.writeInt(data.length);
            this.write(data);
        } else {
            this.writeInt(0);
        }
    }
}

