/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.config;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.kerby.config.Config;
import org.apache.kerby.config.ConfigImpl;
import org.apache.kerby.config.ConfigLoader;
import org.apache.kerby.config.ConfigObject;
import org.apache.kerby.config.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlConfigLoader
extends ConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);

    @Override
    protected void loadConfig(ConfigImpl config, Resource resource) throws Exception {
        Element doc = this.loadResourceDocument(resource);
        this.loadConfig(config, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element loadResourceDocument(Resource resource) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        docBuilderFactory.setNamespaceAware(true);
        try {
            docBuilderFactory.setXIncludeAware(true);
        }
        catch (UnsupportedOperationException e) {
            LOGGER.error("Failed to set setXIncludeAware(true) for parser", (Throwable)e);
        }
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = null;
        try (InputStream is = (InputStream)resource.getResource();){
            doc = builder.parse(is);
        }
        Element root2 = doc.getDocumentElement();
        this.validateConfig(root2);
        return root2;
    }

    private boolean validateConfig(Element root2) {
        boolean valid = false;
        if ("config".equals(root2.getTagName())) {
            valid = true;
        } else {
            LOGGER.error("bad conf element: top-level element not <configuration>");
        }
        return valid;
    }

    private void loadConfig(ConfigImpl config, Element element) {
        NodeList props = element.getChildNodes();
        for (int i = 0; i < props.getLength(); ++i) {
            Element prop;
            String name;
            Node subNode = props.item(i);
            if (!(subNode instanceof Element) || (name = XmlConfigLoader.getElementName(prop = (Element)subNode)) == null) continue;
            ConfigObject value2 = null;
            String tagName = prop.getTagName();
            if ("property".equals(tagName) && prop.hasChildNodes()) {
                value2 = XmlConfigLoader.loadProperty(prop);
            } else if ("config".equals(tagName) && prop.hasChildNodes()) {
                ConfigImpl cfg = new ConfigImpl(name);
                this.loadConfig(cfg, prop);
                value2 = new ConfigObject(cfg);
            }
            config.set(name, value2);
        }
    }

    private static ConfigObject loadProperty(Element ele) {
        if (ele.getFirstChild() instanceof Text) {
            String value2 = ((Text)ele.getFirstChild()).getData();
            return new ConfigObject(value2);
        }
        NodeList nodes = ele.getChildNodes();
        ArrayList<String> values = new ArrayList<String>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            String value3 = null;
            Node valueNode = nodes.item(i);
            if (!(valueNode instanceof Element)) continue;
            Element valueEle = (Element)valueNode;
            if ("value".equals(valueEle.getTagName()) && valueEle.hasChildNodes()) {
                value3 = ((Text)valueEle.getFirstChild()).getData();
            }
            if (value3 == null) continue;
            values.add(value3);
        }
        return new ConfigObject(values);
    }

    private static String getElementName(Element ele) {
        NamedNodeMap nnm = ele.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Attr attr;
            Node node = nnm.item(i);
            if (!(node instanceof Attr) || !"name".equals((attr = (Attr)node).getName())) continue;
            return attr.getValue();
        }
        return null;
    }
}

