/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.config;

import java.util.Iterator;
import java.util.Map;
import org.apache.kerby.config.ConfigImpl;
import org.apache.kerby.config.ConfigLoader;
import org.apache.kerby.config.Resource;

public class MapConfigLoader
extends ConfigLoader {
    @Override
    protected void loadConfig(ConfigImpl config, Resource resource) {
        Map mapConfig = (Map)resource.getResource();
        Iterator iter = mapConfig.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry entry2 = iter.next();
            if (entry2.getValue() instanceof String) {
                this.loadStringMap(config, mapConfig);
            } else {
                this.loadObjectMap(config, mapConfig);
            }
        }
    }

    private void loadStringMap(ConfigImpl config, Map<String, Object> stringMap) {
        for (Map.Entry<String, Object> entry2 : stringMap.entrySet()) {
            config.set(entry2.getKey(), (String)entry2.getValue());
        }
    }

    private void loadObjectMap(ConfigImpl config, Map<String, Object> objectMap) {
        for (Map.Entry<String, Object> entry2 : objectMap.entrySet()) {
            String key = entry2.getKey();
            Object value2 = entry2.getValue();
            if (value2 instanceof Map) {
                ConfigImpl subConfig = new ConfigImpl(key);
                this.loadSubmap(subConfig, (Map)value2);
                config.add(subConfig);
                continue;
            }
            throw new RuntimeException("Unable to resolve config:" + key);
        }
    }

    private void loadSubmap(ConfigImpl config, Map<String, Object> map2) {
        for (Map.Entry<String, Object> entry2 : map2.entrySet()) {
            String key = entry2.getKey();
            Object value2 = entry2.getValue();
            if (value2 instanceof String) {
                config.set(key, (String)value2);
            }
            if (!(value2 instanceof Map)) continue;
            ConfigImpl subConfig = new ConfigImpl(key);
            this.loadSubmap(subConfig, (Map)value2);
            config.add(subConfig);
        }
    }
}

