/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1.type;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.nio.ByteBuffer;
import org.apache.kerby.asn1.Asn1Dumpable;
import org.apache.kerby.asn1.Asn1Dumper;
import org.apache.kerby.asn1.Tag;
import org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.type.AbstractAsn1Type;
import org.apache.kerby.asn1.type.Asn1Encodeable;
import org.apache.kerby.asn1.type.Asn1Type;

public class Asn1Tagging<T extends Asn1Type>
extends AbstractAsn1Type<T>
implements Asn1Dumpable {
    public Asn1Tagging(int tagNo, T value2, boolean isAppSpecific, boolean isImplicit) {
        super(Asn1Tagging.makeTag(isAppSpecific, tagNo), value2);
        if (value2 == null) {
            this.initValue();
        }
        this.useImplicit(isImplicit);
    }

    private static Tag makeTag(boolean isAppSpecific, int tagNo) {
        return isAppSpecific ? Tag.newAppTag(tagNo) : Tag.newCtxTag(tagNo);
    }

    @Override
    public void useImplicit(boolean isImplicit) {
        super.useImplicit(isImplicit);
        if (!isImplicit) {
            this.usePrimitive(false);
        } else {
            this.usePrimitive(((Asn1Type)this.getValue()).isPrimitive());
        }
    }

    @Override
    protected int encodingBodyLength() throws IOException {
        Asn1Encodeable value2 = (Asn1Encodeable)this.getValue();
        if (this.isImplicit()) {
            return value2.encodingBodyLength();
        }
        return value2.encodingLength();
    }

    @Override
    protected void encodeBody(ByteBuffer buffer) throws IOException {
        Asn1Encodeable value2 = (Asn1Encodeable)this.getValue();
        if (this.isImplicit()) {
            value2.encodeBody(buffer);
        } else {
            value2.encode(buffer);
        }
    }

    @Override
    protected void decodeBody(Asn1ParseResult parseResult) throws IOException {
        Asn1Encodeable value2 = (Asn1Encodeable)this.getValue();
        if (this.isImplicit()) {
            value2.decodeBody(parseResult);
        } else {
            Asn1Container container = (Asn1Container)parseResult;
            Asn1ParseResult body = container.getChildren().get(0);
            value2.decode(body);
        }
    }

    private void initValue() {
        AbstractAsn1Type value2;
        Class valueType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        try {
            value2 = (AbstractAsn1Type)valueType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create tagged value", e);
        }
        this.setValue(value2);
    }

    @Override
    public void dumpWith(Asn1Dumper dumper, int indents) {
        Asn1Type taggedValue = (Asn1Type)this.getValue();
        dumper.indent(indents).appendType(this.getClass());
        dumper.append(this.simpleInfo()).newLine();
        dumper.dumpType(indents, taggedValue);
    }
}

