/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1.type;

import java.io.IOException;
import org.apache.kerby.asn1.UniversalTag;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.type.Asn1Simple;

public class Asn1Boolean
extends Asn1Simple<Boolean> {
    private static final byte[] TRUE_BYTE = new byte[]{-1};
    private static final byte[] FALSE_BYTE = new byte[]{0};
    public static final Asn1Boolean TRUE = new Asn1Boolean(true);
    public static final Asn1Boolean FALSE = new Asn1Boolean(false);

    public Asn1Boolean() {
        this((Boolean)null);
    }

    public Asn1Boolean(Boolean value2) {
        super(UniversalTag.BOOLEAN, value2);
    }

    @Override
    protected int encodingBodyLength() {
        return 1;
    }

    @Override
    protected void decodeBody(Asn1ParseResult parseResult) throws IOException {
        if (parseResult.getBodyLength() != 1) {
            throw new IOException("More than 1 byte found for Boolean");
        }
        super.decodeBody(parseResult);
    }

    @Override
    protected void toBytes() {
        this.setBytes((Boolean)this.getValue() != false ? TRUE_BYTE : FALSE_BYTE);
    }

    @Override
    protected void toValue() throws IOException {
        byte[] bytes = this.getBytes();
        if (bytes[0] == 0) {
            this.setValue(false);
        } else if ((bytes[0] & 0xFF) == 255) {
            this.setValue(true);
        } else if (this.isBER()) {
            this.setValue(true);
        } else {
            this.setValue(false);
        }
    }
}

