/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.MultiMechsAuthenticationHandler;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.log4j.Logger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

public class KerberosAuthHandler
extends MultiMechsAuthenticationHandler {
    private static final Logger LOG = Logger.getLogger(KerberosAuthHandler.class);
    protected GSSManager gssManager;
    protected LoginContext loginContext;
    protected String principal;
    protected String keytab;

    @Override
    public void init(Properties config) throws ServletException {
        if (this.loginContext != null) {
            return;
        }
        try {
            this.loginContext = new LoginContext("MAPR_WEBSERVER_KERBEROS");
            this.loginContext.login();
            Configuration jassConfig = Configuration.getConfiguration();
            AppConfigurationEntry[] appInfo = jassConfig.getAppConfigurationEntry("MAPR_WEBSERVER_KERBEROS");
            for (int i = 0; i < appInfo.length; ++i) {
                Map<String, ?> options = appInfo[i].getOptions();
                this.principal = (String)options.get("principal");
                this.keytab = (String)options.get("keyTab");
            }
            Subject serverSubject = this.loginContext.getSubject();
            try {
                this.gssManager = Subject.doAs(serverSubject, new PrivilegedExceptionAction<GSSManager>(){

                    @Override
                    public GSSManager run() throws Exception {
                        return GSSManager.getInstance();
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
            LOG.info((Object)("Initialized, principal [" + this.principal + "] from keytab [" + this.keytab + "]"));
        }
        catch (Exception ex) {
            KerberosUtil.checkJCEKeyStrength();
            LOG.warn((Object)"Failed to obtain kerberos identity... If no Kerberos configuration was intended no further action is needed otherwise turn on DEBUG to see full exception trace");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Full stacktrace", (Throwable)ex);
            }
            this.loginContext = null;
            throw new ServletException((Throwable)ex);
        }
    }

    @Override
    public AuthenticationToken postauthenticate(HttpServletRequest request, final HttpServletResponse response) throws IOException, AuthenticationException {
        Base64 base64;
        byte[] clientToken;
        String negotiateToken;
        AuthenticationToken token2 = null;
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Negotiate")) {
            authorization = authorization.substring("Negotiate".length()).trim();
        }
        if ((negotiateToken = new String(clientToken = (base64 = new Base64(0)).decode(authorization))).startsWith("NTLM")) {
            response.sendError(412, "NTLM Authentication not supported, please try a different browser");
            LOG.info((Object)"No support for NTLM tokens is provided");
            return token2;
        }
        Subject serverSubject = this.loginContext.getSubject();
        try {
            token2 = Subject.doAs(serverSubject, new PrivilegedExceptionAction<AuthenticationToken>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public AuthenticationToken run() throws Exception {
                    AuthenticationToken token2 = null;
                    GSSContext gssContext = null;
                    try {
                        gssContext = KerberosAuthHandler.this.gssManager.createContext((GSSCredential)null);
                        byte[] serverToken = gssContext.acceptSecContext(clientToken, 0, clientToken.length);
                        if (serverToken != null && serverToken.length > 0) {
                            String authenticate = base64.encodeToString(serverToken);
                            response.setHeader("WWW-Authenticate", "Negotiate " + authenticate);
                        }
                        if (!gssContext.isEstablished()) {
                            response.setStatus(401);
                            LOG.trace((Object)"SPNEGO in progress");
                        } else {
                            String clientPrincipal = gssContext.getSrcName().toString();
                            KerberosName kerberosName = new KerberosName(clientPrincipal);
                            String userName = kerberosName.getShortName();
                            token2 = new AuthenticationToken(userName, clientPrincipal, KerberosAuthHandler.this.getType());
                            response.setStatus(200);
                            LOG.trace((Object)("SPNEGO completed for principal [" + clientPrincipal + "]"));
                        }
                    }
                    finally {
                        if (gssContext != null) {
                            gssContext.dispose();
                        }
                    }
                    return token2;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            if (ex.getException() instanceof IOException) {
                throw (IOException)ex.getException();
            }
            throw new AuthenticationException(ex.getException());
        }
        catch (Exception e) {
            throw new AuthenticationException("Authorization is failed, please check your config files settings", e);
        }
        return token2;
    }

    @Override
    public void destroy() {
        try {
            if (this.loginContext != null) {
                this.loginContext.logout();
                this.loginContext = null;
            }
        }
        catch (LoginException ex) {
            LOG.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void addHeader(HttpServletResponse response) {
        response.addHeader("WWW-Authenticate", "Negotiate");
    }

    @Override
    public MultiMechsAuthenticationHandler getAuthBasedEntity(String authorization) {
        if (authorization != null && authorization.startsWith("Negotiate")) {
            return this;
        }
        return null;
    }

    protected String getPrincipal() {
        return this.principal;
    }

    protected String getKeytab() {
        return this.keytab;
    }
}

