/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.util.AuthToken;

public class AuthenticationToken
extends AuthToken {
    public static final AuthenticationToken ANONYMOUS = new AuthenticationToken();

    private AuthenticationToken() {
    }

    private AuthenticationToken(AuthToken token2) {
        super(token2.getUserName(), token2.getName(), token2.getType());
        this.setExpires(token2.getExpires());
    }

    public AuthenticationToken(String userName, String principal, String type) {
        super(userName, principal, type);
    }

    @Override
    public void setExpires(long expires) {
        if (this != ANONYMOUS) {
            super.setExpires(expires);
        }
    }

    @Override
    public boolean isExpired() {
        return super.isExpired();
    }

    public static AuthenticationToken parse(String tokenStr) throws AuthenticationException {
        return new AuthenticationToken(AuthToken.parse(tokenStr));
    }
}

