/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.listen;

import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.listen.ListenerEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.base.Function;
import org.spark_project.guava.collect.Maps;
import org.spark_project.guava.util.concurrent.MoreExecutors;

public class ListenerContainer<T>
implements Listenable<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<T, ListenerEntry<T>> listeners = Maps.newConcurrentMap();

    @Override
    public void addListener(T listener) {
        this.addListener(listener, (Executor)MoreExecutors.sameThreadExecutor());
    }

    @Override
    public void addListener(T listener, Executor executor) {
        this.listeners.put(listener, new ListenerEntry<T>(listener, executor));
    }

    @Override
    public void removeListener(T listener) {
        this.listeners.remove(listener);
    }

    public void clear() {
        this.listeners.clear();
    }

    public int size() {
        return this.listeners.size();
    }

    public void forEach(final Function<T, Void> function) {
        for (final ListenerEntry<T> entry2 : this.listeners.values()) {
            entry2.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        function.apply(entry2.listener);
                    }
                    catch (Throwable e) {
                        ListenerContainer.this.log.error(String.format("Listener (%s) threw an exception", entry2.listener), e);
                    }
                }
            });
        }
    }
}

