/*
 * Decompiled with CFR 0.152.
 */
package org.I0Itec.zkclient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.util.ZkPathUtil;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class InMemoryConnection
implements IZkConnection {
    private Lock _lock = new ReentrantLock(true);
    private Map<String, DataAndVersion> _data = new HashMap<String, DataAndVersion>();
    private Map<String, Long> _creationTime = new HashMap<String, Long>();
    private final AtomicInteger sequence = new AtomicInteger(0);
    private Set<String> _dataWatches = new HashSet<String>();
    private Set<String> _nodeWatches = new HashSet<String>();
    private EventThread _eventThread;

    public InMemoryConnection() {
        try {
            this.create("/", null, CreateMode.PERSISTENT);
        }
        catch (KeeperException e) {
            throw ZkException.create(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZkInterruptedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws InterruptedException {
        this._lock.lockInterruptibly();
        try {
            if (this._eventThread != null) {
                this._eventThread.interrupt();
                this._eventThread.join();
                this._eventThread = null;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(Watcher watcher) {
        this._lock.lock();
        try {
            if (this._eventThread != null) {
                throw new IllegalStateException("Already connected.");
            }
            this._eventThread = new EventThread(watcher);
            this._eventThread.start();
            this._eventThread.send(new WatchedEvent(null, Watcher.Event.KeeperState.SyncConnected, null));
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String create(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        this._lock.lock();
        try {
            if (mode.isSequential()) {
                int newSequence = this.sequence.getAndIncrement();
                path = path + ZkPathUtil.leadingZeros(newSequence, 10);
            }
            if (this.exists(path, false)) {
                throw new KeeperException.NodeExistsException();
            }
            this._data.put(path, new DataAndVersion(data, 0));
            this._creationTime.put(path, System.currentTimeMillis());
            this.checkWatch(this._nodeWatches, path, Watcher.Event.EventType.NodeCreated);
            String parentPath = this.getParentPath(path);
            if (parentPath != null) {
                this.checkWatch(this._nodeWatches, parentPath, Watcher.Event.EventType.NodeChildrenChanged);
            }
            String string2 = path;
            return string2;
        }
        finally {
            this._lock.unlock();
        }
    }

    private String getParentPath(String path) {
        int lastIndexOf = path.lastIndexOf("/");
        if (lastIndexOf == -1 || lastIndexOf == 0) {
            return null;
        }
        return path.substring(0, lastIndexOf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String path) throws InterruptedException, KeeperException {
        this._lock.lock();
        try {
            if (!this.exists(path, false)) {
                throw new KeeperException.NoNodeException();
            }
            this._data.remove(path);
            this._creationTime.remove(path);
            this.checkWatch(this._nodeWatches, path, Watcher.Event.EventType.NodeDeleted);
            String parentPath = this.getParentPath(path);
            if (parentPath != null) {
                this.checkWatch(this._nodeWatches, parentPath, Watcher.Event.EventType.NodeChildrenChanged);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String path, boolean watch) throws KeeperException, InterruptedException {
        this._lock.lock();
        try {
            if (watch) {
                this.installWatch(this._nodeWatches, path);
            }
            boolean bl = this._data.containsKey(path);
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    private void installWatch(Set<String> watches, String path) {
        watches.add(path);
    }

    @Override
    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        if (!this.exists(path, false)) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.NONODE, (String)path);
        }
        if (this.exists(path, false) && watch) {
            this.installWatch(this._nodeWatches, path);
        }
        ArrayList<String> children = new ArrayList<String>();
        String[] directoryStack = path.split("/");
        Set<String> keySet = this._data.keySet();
        for (String string2 : keySet) {
            String[] stack;
            if (!string2.startsWith(path) || (stack = string2.split("/")).length != directoryStack.length + 1) continue;
            children.add(stack[stack.length - 1]);
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZooKeeper.States getZookeeperState() {
        this._lock.lock();
        try {
            if (this._eventThread == null) {
                ZooKeeper.States states = ZooKeeper.States.CLOSED;
                return states;
            }
            ZooKeeper.States states = ZooKeeper.States.CONNECTED;
            return states;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readData(String path, Stat stat, boolean watch) throws KeeperException, InterruptedException {
        if (watch) {
            this.installWatch(this._dataWatches, path);
        }
        this._lock.lock();
        try {
            DataAndVersion dataAndVersion = this._data.get(path);
            if (dataAndVersion == null) {
                throw new ZkNoNodeException((KeeperException)new KeeperException.NoNodeException());
            }
            byte[] bs = dataAndVersion.getData();
            if (stat != null) {
                stat.setVersion(dataAndVersion.getVersion());
            }
            byte[] byArray = bs;
            return byArray;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void writeData(String path, byte[] data, int expectedVersion) throws KeeperException, InterruptedException {
        this.writeDataReturnStat(path, data, expectedVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stat writeDataReturnStat(String path, byte[] data, int expectedVersion) throws KeeperException, InterruptedException {
        int newVersion = -1;
        this._lock.lock();
        try {
            this.checkWatch(this._dataWatches, path, Watcher.Event.EventType.NodeDataChanged);
            if (!this.exists(path, false)) {
                throw new KeeperException.NoNodeException();
            }
            newVersion = this._data.get(path).getVersion() + 1;
            this._data.put(path, new DataAndVersion(data, newVersion));
            String parentPath = this.getParentPath(path);
            if (parentPath != null) {
                this.checkWatch(this._nodeWatches, parentPath, Watcher.Event.EventType.NodeChildrenChanged);
            }
        }
        finally {
            this._lock.unlock();
        }
        Stat stat = new Stat();
        stat.setVersion(newVersion);
        return stat;
    }

    private void checkWatch(Set<String> watches, String path, Watcher.Event.EventType eventType) {
        if (watches.contains(path)) {
            watches.remove(path);
            this._eventThread.send(new WatchedEvent(eventType, Watcher.Event.KeeperState.SyncConnected, path));
        }
    }

    @Override
    public long getCreateTime(String path) {
        Long time = this._creationTime.get(path);
        if (time == null) {
            return -1L;
        }
        return time;
    }

    @Override
    public String getServers() {
        return "mem";
    }

    private class EventThread
    extends Thread {
        private Watcher _watcher;
        private BlockingQueue<WatchedEvent> _blockingQueue = new LinkedBlockingDeque<WatchedEvent>();

        public EventThread(Watcher watcher) {
            this._watcher = watcher;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this._watcher.process(this._blockingQueue.take());
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void send(WatchedEvent event) {
            this._blockingQueue.add(event);
        }
    }

    public static class DataAndVersion {
        private byte[] _data;
        private int _version;

        public DataAndVersion(byte[] data, int version) {
            this._data = data;
            this._version = version;
        }

        public byte[] getData() {
            return this._data;
        }

        public int getVersion() {
            return this._version;
        }
    }
}

