/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.annotation.adapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollapsedStringAdapter
extends XmlAdapter<String, String> {
    @Override
    public String unmarshal(String text2) {
        int s;
        if (text2 == null) {
            return null;
        }
        int len = text2.length();
        for (s = 0; s < len && !CollapsedStringAdapter.isWhiteSpace(text2.charAt(s)); ++s) {
        }
        if (s == len) {
            return text2;
        }
        StringBuffer result = new StringBuffer(len);
        if (s != 0) {
            for (int i = 0; i < s; ++i) {
                result.append(text2.charAt(i));
            }
            result.append(' ');
        }
        boolean inStripMode = true;
        for (int i = s + 1; i < len; ++i) {
            char ch = text2.charAt(i);
            boolean b = CollapsedStringAdapter.isWhiteSpace(ch);
            if (inStripMode && b) continue;
            inStripMode = b;
            if (inStripMode) {
                result.append(' ');
                continue;
            }
            result.append(ch);
        }
        len = result.length();
        if (len > 0 && result.charAt(len - 1) == ' ') {
            result.setLength(len - 1);
        }
        return result.toString();
    }

    @Override
    public String marshal(String s) {
        return s;
    }

    protected static boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }
}

