/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.InvalidContainerRequestException;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.RackResolver;
import org.spark_project.guava.annotations.VisibleForTesting;
import org.spark_project.guava.base.Joiner;
import org.spark_project.guava.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AMRMClientImpl<T extends AMRMClient.ContainerRequest>
extends AMRMClient<T> {
    private static final Log LOG = LogFactory.getLog(AMRMClientImpl.class);
    private static final List<String> ANY_LIST = Collections.singletonList("*");
    private int lastResponseId = 0;
    protected String appHostName;
    protected int appHostPort;
    protected String appTrackingUrl;
    protected ApplicationMasterProtocol rmClient;
    protected Resource clusterAvailableResources;
    protected int clusterNodeCount;
    protected final Set<String> blacklistedNodes = new HashSet<String>();
    protected final Set<String> blacklistAdditions = new HashSet<String>();
    protected final Set<String> blacklistRemovals = new HashSet<String>();
    protected final Map<Priority, Map<String, TreeMap<Resource, ResourceRequestInfo>>> remoteRequestsTable = new TreeMap<Priority, Map<String, TreeMap<Resource, ResourceRequestInfo>>>();
    protected final Set<ResourceRequest> ask = new TreeSet<ResourceRequest>(new ResourceRequest.ResourceRequestComparator());
    protected final Set<ContainerId> release = new TreeSet<ContainerId>();
    protected Set<ContainerId> pendingRelease = new TreeSet<ContainerId>();

    static boolean canFit(Resource arg0, Resource arg1) {
        int mem0 = arg0.getMemory();
        int mem1 = arg1.getMemory();
        int cpu0 = arg0.getVirtualCores();
        int cpu1 = arg1.getVirtualCores();
        return mem0 <= mem1 && cpu0 <= cpu1;
    }

    public AMRMClientImpl() {
        super(AMRMClientImpl.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        RackResolver.init(conf);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        YarnConfiguration conf = new YarnConfiguration(this.getConfig());
        try {
            this.rmClient = ClientRMProxy.createRMProxy(conf, ApplicationMasterProtocol.class);
        }
        catch (IOException e) {
            throw new YarnRuntimeException(e);
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.rmClient != null) {
            RPC.stopProxy((Object)this.rmClient);
        }
        super.serviceStop();
    }

    @Override
    public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl) throws YarnException, IOException {
        this.appHostName = appHostName;
        this.appHostPort = appHostPort;
        this.appTrackingUrl = appTrackingUrl;
        Preconditions.checkArgument((appHostName != null ? 1 : 0) != 0, (Object)"The host name should not be null");
        Preconditions.checkArgument((appHostPort >= -1 ? 1 : 0) != 0, (Object)"Port number of the host should be any integers larger than or equal to -1");
        return this.registerApplicationMaster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisterApplicationMasterResponse registerApplicationMaster() throws YarnException, IOException {
        RegisterApplicationMasterRequest request = RegisterApplicationMasterRequest.newInstance(this.appHostName, this.appHostPort, this.appTrackingUrl);
        RegisterApplicationMasterResponse response = this.rmClient.registerApplicationMaster(request);
        AMRMClientImpl aMRMClientImpl = this;
        synchronized (aMRMClientImpl) {
            this.lastResponseId = 0;
            if (!response.getNMTokensFromPreviousAttempts().isEmpty()) {
                this.populateNMTokens(response.getNMTokensFromPreviousAttempts());
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocateResponse allocate(float progressIndicator) throws YarnException, IOException {
        AllocateResponse allocateResponse;
        block35: {
            Object blacklistRequest;
            Preconditions.checkArgument((progressIndicator >= 0.0f ? 1 : 0) != 0, (Object)"Progress indicator should not be negative");
            allocateResponse = null;
            ArrayList<ResourceRequest> askList = null;
            ArrayList<ContainerId> releaseList = null;
            AllocateRequest allocateRequest = null;
            ArrayList<String> blacklistToAdd = new ArrayList<String>();
            ArrayList<String> blacklistToRemove = new ArrayList<String>();
            AMRMClientImpl aMRMClientImpl = this;
            synchronized (aMRMClientImpl) {
                askList = new ArrayList<ResourceRequest>(this.ask.size());
                for (ResourceRequest r : this.ask) {
                    askList.add(ResourceRequest.newInstance(r.getPriority(), r.getResourceName(), r.getCapability(), r.getNumContainers(), r.getRelaxLocality(), r.getNodeLabelExpression()));
                }
                releaseList = new ArrayList<ContainerId>(this.release);
                this.ask.clear();
                this.release.clear();
                blacklistToAdd.addAll(this.blacklistAdditions);
                blacklistToRemove.addAll(this.blacklistRemovals);
                blacklistRequest = ResourceBlacklistRequest.newInstance(blacklistToAdd, blacklistToRemove);
                allocateRequest = AllocateRequest.newInstance(this.lastResponseId, progressIndicator, askList, releaseList, blacklistRequest);
                this.blacklistAdditions.clear();
                this.blacklistRemovals.clear();
            }
            try {
                allocateResponse = this.rmClient.allocate(allocateRequest);
            }
            catch (ApplicationMasterNotRegisteredException e) {
                LOG.warn((Object)"ApplicationMaster is out of sync with ResourceManager, hence resyncing.");
                blacklistRequest = this;
                synchronized (blacklistRequest) {
                    this.release.addAll(this.pendingRelease);
                    this.blacklistAdditions.addAll(this.blacklistedNodes);
                    for (Map<String, TreeMap<Resource, ResourceRequestInfo>> rr : this.remoteRequestsTable.values()) {
                        for (Map map2 : rr.values()) {
                            for (ResourceRequestInfo request : map2.values()) {
                                this.addResourceRequestToAsk(request.remoteRequest);
                            }
                        }
                    }
                }
                this.registerApplicationMaster();
                allocateResponse = this.allocate(progressIndicator);
                blacklistRequest = allocateResponse;
                if (allocateResponse == null) {
                    Object i$ = this;
                    synchronized (i$) {
                        this.release.addAll(releaseList);
                        for (ResourceRequest oldAsk : askList) {
                            if (this.ask.contains(oldAsk)) continue;
                            this.ask.add(oldAsk);
                        }
                        this.blacklistAdditions.addAll(blacklistToAdd);
                        this.blacklistRemovals.addAll(blacklistToRemove);
                    }
                }
                return blacklistRequest;
            }
            try {
                aMRMClientImpl = this;
                synchronized (aMRMClientImpl) {
                    this.clusterNodeCount = allocateResponse.getNumClusterNodes();
                    this.lastResponseId = allocateResponse.getResponseId();
                    this.clusterAvailableResources = allocateResponse.getAvailableResources();
                    if (!allocateResponse.getNMTokens().isEmpty()) {
                        this.populateNMTokens(allocateResponse.getNMTokens());
                    }
                    if (allocateResponse.getAMRMToken() != null) {
                        this.updateAMRMToken(allocateResponse.getAMRMToken());
                    }
                    if (!this.pendingRelease.isEmpty() && !allocateResponse.getCompletedContainersStatuses().isEmpty()) {
                        this.removePendingReleaseRequests(allocateResponse.getCompletedContainersStatuses());
                    }
                }
                if (allocateResponse != null) break block35;
                aMRMClientImpl = this;
            }
            catch (Throwable throwable) {
                if (allocateResponse == null) {
                    AMRMClientImpl aMRMClientImpl2 = this;
                    synchronized (aMRMClientImpl2) {
                        this.release.addAll(releaseList);
                        for (ResourceRequest oldAsk : askList) {
                            if (this.ask.contains(oldAsk)) continue;
                            this.ask.add(oldAsk);
                        }
                        this.blacklistAdditions.addAll(blacklistToAdd);
                        this.blacklistRemovals.addAll(blacklistToRemove);
                    }
                }
                throw throwable;
            }
            synchronized (aMRMClientImpl) {
                this.release.addAll(releaseList);
                for (ResourceRequest oldAsk : askList) {
                    if (this.ask.contains(oldAsk)) continue;
                    this.ask.add(oldAsk);
                }
                this.blacklistAdditions.addAll(blacklistToAdd);
                this.blacklistRemovals.addAll(blacklistToRemove);
            }
        }
        return allocateResponse;
    }

    protected void removePendingReleaseRequests(List<ContainerStatus> completedContainersStatuses) {
        for (ContainerStatus containerStatus : completedContainersStatuses) {
            this.pendingRelease.remove(containerStatus.getContainerId());
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void populateNMTokens(List<NMToken> nmTokens) {
        for (NMToken token2 : nmTokens) {
            String nodeId = token2.getNodeId().toString();
            if (this.getNMTokenCache().containsToken(nodeId)) {
                LOG.info((Object)("Replacing token for : " + nodeId));
            } else {
                LOG.info((Object)("Received new token for : " + nodeId));
            }
            this.getNMTokenCache().setToken(nodeId, token2.getToken());
        }
    }

    @Override
    public void unregisterApplicationMaster(FinalApplicationStatus appStatus, String appMessage, String appTrackingUrl) throws YarnException, IOException {
        Preconditions.checkArgument((appStatus != null ? 1 : 0) != 0, (Object)"AppStatus should not be null.");
        FinishApplicationMasterRequest request = FinishApplicationMasterRequest.newInstance(appStatus, appMessage, appTrackingUrl);
        try {
            FinishApplicationMasterResponse response;
            while (!(response = this.rmClient.finishApplicationMaster(request)).getIsUnregistered()) {
                LOG.info((Object)"Waiting for application to be successfully unregistered.");
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Interrupted while waiting for application to be removed from RMStateStore");
        }
        catch (ApplicationMasterNotRegisteredException e) {
            LOG.warn((Object)"ApplicationMaster is out of sync with ResourceManager, hence resyncing.");
            this.registerApplicationMaster();
            this.unregisterApplicationMaster(appStatus, appMessage, appTrackingUrl);
        }
    }

    @Override
    public synchronized void addContainerRequest(T req) {
        Preconditions.checkArgument((req != null ? 1 : 0) != 0, (Object)"Resource request can not be null.");
        HashSet<String> dedupedRacks = new HashSet<String>();
        if (((AMRMClient.ContainerRequest)req).getRacks() != null) {
            dedupedRacks.addAll(((AMRMClient.ContainerRequest)req).getRacks());
            if (((AMRMClient.ContainerRequest)req).getRacks().size() != dedupedRacks.size()) {
                Joiner joiner = Joiner.on((char)',');
                LOG.warn((Object)("ContainerRequest has duplicate racks: " + joiner.join(((AMRMClient.ContainerRequest)req).getRacks())));
            }
        }
        Set<String> inferredRacks = this.resolveRacks(((AMRMClient.ContainerRequest)req).getNodes());
        inferredRacks.removeAll(dedupedRacks);
        this.checkLocalityRelaxationConflict(((AMRMClient.ContainerRequest)req).getPriority(), ANY_LIST, ((AMRMClient.ContainerRequest)req).getRelaxLocality());
        this.checkLocalityRelaxationConflict(((AMRMClient.ContainerRequest)req).getPriority(), dedupedRacks, true);
        this.checkLocalityRelaxationConflict(((AMRMClient.ContainerRequest)req).getPriority(), inferredRacks, ((AMRMClient.ContainerRequest)req).getRelaxLocality());
        this.checkNodeLabelExpression(req);
        if (((AMRMClient.ContainerRequest)req).getNodes() != null) {
            HashSet<String> dedupedNodes = new HashSet<String>(((AMRMClient.ContainerRequest)req).getNodes());
            if (dedupedNodes.size() != ((AMRMClient.ContainerRequest)req).getNodes().size()) {
                Joiner joiner = Joiner.on((char)',');
                LOG.warn((Object)("ContainerRequest has duplicate nodes: " + joiner.join(((AMRMClient.ContainerRequest)req).getNodes())));
            }
            for (String node : dedupedNodes) {
                this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), node, ((AMRMClient.ContainerRequest)req).getCapability(), req, true, ((AMRMClient.ContainerRequest)req).getNodeLabelExpression());
            }
        }
        for (String rack : dedupedRacks) {
            this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), rack, ((AMRMClient.ContainerRequest)req).getCapability(), req, true, ((AMRMClient.ContainerRequest)req).getNodeLabelExpression());
        }
        for (String rack : inferredRacks) {
            this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), rack, ((AMRMClient.ContainerRequest)req).getCapability(), req, ((AMRMClient.ContainerRequest)req).getRelaxLocality(), ((AMRMClient.ContainerRequest)req).getNodeLabelExpression());
        }
        this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), "*", ((AMRMClient.ContainerRequest)req).getCapability(), req, ((AMRMClient.ContainerRequest)req).getRelaxLocality(), ((AMRMClient.ContainerRequest)req).getNodeLabelExpression());
    }

    @Override
    public synchronized void removeContainerRequest(T req) {
        Preconditions.checkArgument((req != null ? 1 : 0) != 0, (Object)"Resource request can not be null.");
        HashSet<String> allRacks = new HashSet<String>();
        if (((AMRMClient.ContainerRequest)req).getRacks() != null) {
            allRacks.addAll(((AMRMClient.ContainerRequest)req).getRacks());
        }
        allRacks.addAll(this.resolveRacks(((AMRMClient.ContainerRequest)req).getNodes()));
        if (((AMRMClient.ContainerRequest)req).getNodes() != null) {
            for (String node : new HashSet<String>(((AMRMClient.ContainerRequest)req).getNodes())) {
                this.decResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), node, ((AMRMClient.ContainerRequest)req).getCapability(), req);
            }
        }
        for (String rack : allRacks) {
            this.decResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), rack, ((AMRMClient.ContainerRequest)req).getCapability(), req);
        }
        this.decResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), "*", ((AMRMClient.ContainerRequest)req).getCapability(), req);
    }

    @Override
    public synchronized void releaseAssignedContainer(ContainerId containerId) {
        Preconditions.checkArgument((containerId != null ? 1 : 0) != 0, (Object)"ContainerId can not be null.");
        this.pendingRelease.add(containerId);
        this.release.add(containerId);
    }

    @Override
    public synchronized Resource getAvailableResources() {
        return this.clusterAvailableResources;
    }

    @Override
    public synchronized int getClusterNodeCount() {
        return this.clusterNodeCount;
    }

    @Override
    public synchronized List<? extends Collection<T>> getMatchingRequests(Priority priority, String resourceName, Resource capability) {
        Preconditions.checkArgument((capability != null ? 1 : 0) != 0, (Object)"The Resource to be requested should not be null ");
        Preconditions.checkArgument((priority != null ? 1 : 0) != 0, (Object)"The priority at which to request containers should not be null ");
        LinkedList list = new LinkedList();
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            return list;
        }
        TreeMap<Resource, ResourceRequestInfo> reqMap = remoteRequests.get(resourceName);
        if (reqMap == null) {
            return list;
        }
        ResourceRequestInfo resourceRequestInfo = reqMap.get(capability);
        if (resourceRequestInfo != null && !resourceRequestInfo.containerRequests.isEmpty()) {
            list.add(resourceRequestInfo.containerRequests);
            return list;
        }
        SortedMap<Resource, ResourceRequestInfo> tailMap = reqMap.tailMap(capability);
        for (Map.Entry<Resource, ResourceRequestInfo> entry2 : tailMap.entrySet()) {
            if (!AMRMClientImpl.canFit(entry2.getKey(), capability) || entry2.getValue().containerRequests.isEmpty()) continue;
            list.add(entry2.getValue().containerRequests);
        }
        return list;
    }

    private Set<String> resolveRacks(List<String> nodes) {
        HashSet<String> racks = new HashSet<String>();
        if (nodes != null) {
            for (String node : nodes) {
                String rack = RackResolver.resolve(node).getNetworkLocation();
                if (rack == null) {
                    LOG.warn((Object)("Failed to resolve rack for node " + node + "."));
                    continue;
                }
                racks.add(rack);
            }
        }
        return racks;
    }

    private void checkLocalityRelaxationConflict(Priority priority, Collection<String> locations, boolean relaxLocality) {
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            return;
        }
        for (String location : locations) {
            boolean existingRelaxLocality;
            TreeMap<Resource, ResourceRequestInfo> reqs = remoteRequests.get(location);
            if (reqs == null || reqs.isEmpty() || relaxLocality == (existingRelaxLocality = reqs.values().iterator().next().remoteRequest.getRelaxLocality())) continue;
            throw new InvalidContainerRequestException("Cannot submit a ContainerRequest asking for location " + location + " with locality relaxation " + relaxLocality + " when it has " + "already been requested with locality relaxation " + existingRelaxLocality);
        }
    }

    private void checkNodeLabelExpression(T containerRequest) {
        String exp = ((AMRMClient.ContainerRequest)containerRequest).getNodeLabelExpression();
        if (null == exp || exp.isEmpty()) {
            return;
        }
        if (exp.contains("&&") || exp.contains("||")) {
            throw new InvalidContainerRequestException("Cannot specify more than two node labels in a single node label expression");
        }
    }

    private void addResourceRequestToAsk(ResourceRequest remoteRequest) {
        if (this.ask.contains(remoteRequest)) {
            this.ask.remove(remoteRequest);
        }
        this.ask.add(remoteRequest);
    }

    private void addResourceRequest(Priority priority, String resourceName, Resource capability, T req, boolean relaxLocality, String labelExpression) {
        ResourceRequestInfo resourceRequestInfo;
        TreeMap<Resource, ResourceRequestInfo> reqMap;
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            remoteRequests = new HashMap<String, TreeMap<Resource, ResourceRequestInfo>>();
            this.remoteRequestsTable.put(priority, remoteRequests);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Added priority=" + priority));
            }
        }
        if ((reqMap = remoteRequests.get(resourceName)) == null) {
            reqMap = new TreeMap(new ResourceReverseMemoryThenCpuComparator());
            remoteRequests.put(resourceName, reqMap);
        }
        if ((resourceRequestInfo = reqMap.get(capability)) == null) {
            resourceRequestInfo = new ResourceRequestInfo(priority, resourceName, capability, relaxLocality);
            reqMap.put(capability, resourceRequestInfo);
        }
        resourceRequestInfo.remoteRequest.setNumContainers(resourceRequestInfo.remoteRequest.getNumContainers() + 1);
        if (relaxLocality) {
            resourceRequestInfo.containerRequests.add(req);
        }
        if ("*".equals(resourceName)) {
            resourceRequestInfo.remoteRequest.setNodeLabelExpression(labelExpression);
        }
        this.addResourceRequestToAsk(resourceRequestInfo.remoteRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addResourceRequest: applicationId= priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    private void decResourceRequest(Priority priority, String resourceName, Resource capability, T req) {
        Map<String, TreeMap<Resource, ResourceRequestInfo>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not decrementing resource as priority " + priority + " is not present in request table"));
            }
            return;
        }
        Map reqMap = remoteRequests.get(resourceName);
        if (reqMap == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not decrementing resource as " + resourceName + " is not present in request table"));
            }
            return;
        }
        ResourceRequestInfo resourceRequestInfo = (ResourceRequestInfo)reqMap.get(capability);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEFORE decResourceRequest: applicationId= priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
        resourceRequestInfo.remoteRequest.setNumContainers(resourceRequestInfo.remoteRequest.getNumContainers() - 1);
        resourceRequestInfo.containerRequests.remove(req);
        if (resourceRequestInfo.remoteRequest.getNumContainers() < 0) {
            resourceRequestInfo.remoteRequest.setNumContainers(0);
        }
        this.addResourceRequestToAsk(resourceRequestInfo.remoteRequest);
        if (resourceRequestInfo.remoteRequest.getNumContainers() == 0) {
            reqMap.remove(capability);
            if (reqMap.size() == 0) {
                remoteRequests.remove(resourceName);
            }
            if (remoteRequests.size() == 0) {
                this.remoteRequestsTable.remove(priority);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("AFTER decResourceRequest: applicationId= priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    @Override
    public synchronized void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        if (blacklistAdditions != null) {
            this.blacklistAdditions.addAll(blacklistAdditions);
            this.blacklistedNodes.addAll(blacklistAdditions);
            this.blacklistRemovals.removeAll(blacklistAdditions);
        }
        if (blacklistRemovals != null) {
            this.blacklistRemovals.addAll(blacklistRemovals);
            this.blacklistedNodes.removeAll(blacklistRemovals);
            this.blacklistAdditions.removeAll(blacklistRemovals);
        }
        if (blacklistAdditions != null && blacklistRemovals != null && blacklistAdditions.removeAll(blacklistRemovals)) {
            LOG.warn((Object)"The same resources appear in both blacklistAdditions and blacklistRemovals in updateBlacklist.");
        }
    }

    private void updateAMRMToken(org.apache.hadoop.yarn.api.records.Token token2) throws IOException {
        Token amrmToken = new Token(token2.getIdentifier().array(), token2.getPassword().array(), new Text(token2.getKind()), new Text(token2.getService()));
        UserGroupInformation currentUGI = UserGroupInformation.getCurrentUser();
        currentUGI.addToken(amrmToken);
        amrmToken.setService(ClientRMProxy.getAMRMTokenService(this.getConfig()));
    }

    class ResourceReverseMemoryThenCpuComparator
    implements Comparator<Resource> {
        ResourceReverseMemoryThenCpuComparator() {
        }

        @Override
        public int compare(Resource arg0, Resource arg1) {
            int mem0 = arg0.getMemory();
            int mem1 = arg1.getMemory();
            int cpu0 = arg0.getVirtualCores();
            int cpu1 = arg1.getVirtualCores();
            if (mem0 == mem1) {
                if (cpu0 == cpu1) {
                    return 0;
                }
                if (cpu0 < cpu1) {
                    return 1;
                }
                return -1;
            }
            if (mem0 < mem1) {
                return 1;
            }
            return -1;
        }
    }

    class ResourceRequestInfo {
        ResourceRequest remoteRequest;
        LinkedHashSet<T> containerRequests;

        ResourceRequestInfo(Priority priority, String resourceName, Resource capability, boolean relaxLocality) {
            this.remoteRequest = ResourceRequest.newInstance(priority, resourceName, capability, 0);
            this.remoteRequest.setRelaxLocality(relaxLocality);
            this.containerRequests = new LinkedHashSet();
        }
    }
}

