/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.directory.api.i18n.I18n;

public class GeneralizedTime
implements Comparable<GeneralizedTime> {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private String upGeneralizedTime;
    private Format upFormat;
    private TimeZoneFormat upTimeZoneFormat;
    private FractionDelimiter upFractionDelimiter;
    private int upFractionLength;
    private Calendar calendar;

    public GeneralizedTime(Date date) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(date);
        this.setUp(this.calendar);
    }

    public GeneralizedTime(Calendar calendar) {
        this.setUp(calendar);
    }

    private void setUp(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04358, (Object[])new Object[0]));
        }
        this.calendar = calendar;
        this.upGeneralizedTime = null;
        this.upFormat = Format.YEAR_MONTH_DAY_HOUR_MIN_SEC_FRACTION;
        this.upTimeZoneFormat = TimeZoneFormat.Z;
        this.upFractionDelimiter = FractionDelimiter.DOT;
        this.upFractionLength = 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneralizedTime(String generalizedTime) throws ParseException {
        if (generalizedTime == null) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04359, (Object[])new Object[0]), 0);
        }
        this.upGeneralizedTime = generalizedTime;
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeInMillis(0L);
        this.calendar.setLenient(false);
        this.parseYear();
        this.parseMonth();
        this.parseDay();
        this.parseHour();
        if (this.upGeneralizedTime.length() < 11) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04360, (Object[])new Object[0]), 10);
        }
        int pos = 10;
        char c = this.upGeneralizedTime.charAt(pos);
        if ('0' <= c && c <= '9') {
            this.parseMinute();
            if (this.upGeneralizedTime.length() < 13) {
                throw new ParseException(I18n.err((I18n)I18n.ERR_04361, (Object[])new Object[0]), 12);
            }
            pos = 12;
            c = this.upGeneralizedTime.charAt(pos);
            if ('0' <= c && c <= '9') {
                this.parseSecond();
                if (this.upGeneralizedTime.length() < 15) {
                    throw new ParseException(I18n.err((I18n)I18n.ERR_04362, (Object[])new Object[0]), 14);
                }
                pos = 14;
                c = this.upGeneralizedTime.charAt(pos);
                if (c == '.' || c == ',') {
                    this.parseFractionOfSecond();
                    this.parseTimezone(pos += 1 + this.upFractionLength);
                    this.upFormat = Format.YEAR_MONTH_DAY_HOUR_MIN_SEC_FRACTION;
                } else {
                    if (c != 'Z' && c != '+' && c != '-') throw new ParseException(I18n.err((I18n)I18n.ERR_04363, (Object[])new Object[0]), 14);
                    this.parseTimezone(pos);
                    this.upFormat = Format.YEAR_MONTH_DAY_HOUR_MIN_SEC;
                }
            } else if (c == '.' || c == ',') {
                this.parseFractionOfMinute();
                this.parseTimezone(pos += 1 + this.upFractionLength);
                this.upFormat = Format.YEAR_MONTH_DAY_HOUR_MIN_FRACTION;
            } else {
                if (c != 'Z' && c != '+' && c != '-') throw new ParseException(I18n.err((I18n)I18n.ERR_04364, (Object[])new Object[0]), 12);
                this.parseTimezone(pos);
                this.upFormat = Format.YEAR_MONTH_DAY_HOUR_MIN;
            }
        } else if (c == '.' || c == ',') {
            this.parseFractionOfHour();
            this.parseTimezone(pos += 1 + this.upFractionLength);
            this.upFormat = Format.YEAR_MONTH_DAY_HOUR_FRACTION;
        } else {
            if (c != 'Z' && c != '+' && c != '-') throw new ParseException(I18n.err((I18n)I18n.ERR_04365, (Object[])new Object[0]), 10);
            this.parseTimezone(pos);
            this.upFormat = Format.YEAR_MONTH_DAY_HOUR;
        }
        try {
            this.calendar.getTimeInMillis();
        }
        catch (IllegalArgumentException iae) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04366, (Object[])new Object[0]), 0);
        }
        this.calendar.setLenient(true);
    }

    private void parseTimezone(int pos) throws ParseException {
        if (this.upGeneralizedTime.length() < pos + 1) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04367, (Object[])new Object[0]), pos);
        }
        char c = this.upGeneralizedTime.charAt(pos);
        if (c == 'Z') {
            this.calendar.setTimeZone(GMT);
            this.upTimeZoneFormat = TimeZoneFormat.Z;
            if (this.upGeneralizedTime.length() > pos + 1) {
                throw new ParseException(I18n.err((I18n)I18n.ERR_04368, (Object[])new Object[0]), pos + 1);
            }
        } else if (c == '+' || c == '-') {
            StringBuilder sb = new StringBuilder("GMT");
            sb.append(c);
            String digits = this.getAllDigits(pos + 1);
            sb.append(digits);
            if (digits.length() == 2 && digits.matches("^([01]\\d|2[0-3])$")) {
                TimeZone timeZone = TimeZone.getTimeZone(sb.toString());
                this.calendar.setTimeZone(timeZone);
                this.upTimeZoneFormat = TimeZoneFormat.DIFF_HOUR;
            } else if (digits.length() == 4 && digits.matches("^([01]\\d|2[0-3])([0-5]\\d)$")) {
                TimeZone timeZone = TimeZone.getTimeZone(sb.toString());
                this.calendar.setTimeZone(timeZone);
                this.upTimeZoneFormat = TimeZoneFormat.DIFF_HOUR_MINUTE;
            } else {
                throw new ParseException(I18n.err((I18n)I18n.ERR_04369, (Object[])new Object[0]), pos);
            }
            if (this.upGeneralizedTime.length() > pos + 1 + digits.length()) {
                throw new ParseException(I18n.err((I18n)I18n.ERR_04370, (Object[])new Object[0]), pos + 1 + digits.length());
            }
        }
    }

    private void parseFractionOfSecond() throws ParseException {
        this.parseFractionDelmiter(14);
        String fraction = this.getFraction(15);
        this.upFractionLength = fraction.length();
        double fract = Double.parseDouble("0." + fraction);
        int millisecond = (int)Math.round(fract * 1000.0);
        this.calendar.set(14, millisecond);
    }

    private void parseFractionOfMinute() throws ParseException {
        this.parseFractionDelmiter(12);
        String fraction = this.getFraction(13);
        this.upFractionLength = fraction.length();
        double fract = Double.parseDouble("0." + fraction);
        int milliseconds = (int)Math.round(fract * 1000.0 * 60.0);
        int second = milliseconds / 1000;
        int millisecond = milliseconds - second * 1000;
        this.calendar.set(13, second);
        this.calendar.set(14, millisecond);
    }

    private void parseFractionOfHour() throws ParseException {
        this.parseFractionDelmiter(10);
        String fraction = this.getFraction(11);
        this.upFractionLength = fraction.length();
        double fract = Double.parseDouble("0." + fraction);
        int milliseconds = (int)Math.round(fract * 1000.0 * 60.0 * 60.0);
        int minute = milliseconds / 60000;
        int second = (milliseconds - minute * 60 * 1000) / 1000;
        int millisecond = milliseconds - minute * 60 * 1000 - second * 1000;
        this.calendar.set(12, minute);
        this.calendar.set(13, second);
        this.calendar.set(14, millisecond);
    }

    private void parseFractionDelmiter(int fractionDelimiterPos) {
        char c = this.upGeneralizedTime.charAt(fractionDelimiterPos);
        this.upFractionDelimiter = c == '.' ? FractionDelimiter.DOT : FractionDelimiter.COMMA;
    }

    private String getFraction(int startIndex) throws ParseException {
        String fraction = this.getAllDigits(startIndex);
        if (fraction.length() == 0) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04371, (Object[])new Object[0]), startIndex);
        }
        return fraction;
    }

    private String getAllDigits(int startIndex) {
        char c;
        StringBuilder sb = new StringBuilder();
        while (this.upGeneralizedTime.length() > startIndex && '0' <= (c = this.upGeneralizedTime.charAt(startIndex)) && c <= '9') {
            sb.append(c);
            ++startIndex;
        }
        return sb.toString();
    }

    private void parseSecond() throws ParseException {
        if (this.upGeneralizedTime.length() < 14) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04372, (Object[])new Object[0]), 12);
        }
        try {
            int second = Integer.parseInt(this.upGeneralizedTime.substring(12, 14));
            this.calendar.set(13, second);
        }
        catch (NumberFormatException e) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04373, (Object[])new Object[0]), 12);
        }
    }

    private void parseMinute() throws ParseException {
        if (this.upGeneralizedTime.length() < 12) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04374, (Object[])new Object[0]), 10);
        }
        try {
            int minute = Integer.parseInt(this.upGeneralizedTime.substring(10, 12));
            this.calendar.set(12, minute);
        }
        catch (NumberFormatException e) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04375, (Object[])new Object[0]), 10);
        }
    }

    private void parseHour() throws ParseException {
        if (this.upGeneralizedTime.length() < 10) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04376, (Object[])new Object[0]), 8);
        }
        try {
            int hour = Integer.parseInt(this.upGeneralizedTime.substring(8, 10));
            this.calendar.set(11, hour);
        }
        catch (NumberFormatException e) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04377, (Object[])new Object[0]), 8);
        }
    }

    private void parseDay() throws ParseException {
        if (this.upGeneralizedTime.length() < 8) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04378, (Object[])new Object[0]), 6);
        }
        try {
            int day = Integer.parseInt(this.upGeneralizedTime.substring(6, 8));
            this.calendar.set(5, day);
        }
        catch (NumberFormatException e) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04379, (Object[])new Object[0]), 6);
        }
    }

    private void parseMonth() throws ParseException {
        if (this.upGeneralizedTime.length() < 6) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04380, (Object[])new Object[0]), 4);
        }
        try {
            int month = Integer.parseInt(this.upGeneralizedTime.substring(4, 6));
            this.calendar.set(2, month - 1);
        }
        catch (NumberFormatException e) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04381, (Object[])new Object[0]), 4);
        }
    }

    private void parseYear() throws ParseException {
        if (this.upGeneralizedTime.length() < 4) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04382, (Object[])new Object[0]), 0);
        }
        try {
            int year = Integer.parseInt(this.upGeneralizedTime.substring(0, 4));
            this.calendar.set(1, year);
        }
        catch (NumberFormatException e) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04383, (Object[])new Object[0]), 0);
        }
    }

    public String toGeneralizedTime() {
        return this.toGeneralizedTime(this.upFormat, this.upFractionDelimiter, this.upFractionLength, this.upTimeZoneFormat);
    }

    public String toGeneralizedTimeWithoutFraction() {
        return this.toGeneralizedTime(this.getFormatWithoutFraction(this.upFormat), this.upFractionDelimiter, this.upFractionLength, this.upTimeZoneFormat);
    }

    private Format getFormatWithoutFraction(Format f) {
        switch (f) {
            case YEAR_MONTH_DAY_HOUR_FRACTION: {
                return Format.YEAR_MONTH_DAY_HOUR;
            }
            case YEAR_MONTH_DAY_HOUR_MIN_FRACTION: {
                return Format.YEAR_MONTH_DAY_HOUR_MIN;
            }
            case YEAR_MONTH_DAY_HOUR_MIN_SEC_FRACTION: {
                return Format.YEAR_MONTH_DAY_HOUR_MIN_SEC;
            }
        }
        return f;
    }

    public String toGeneralizedTime(Format format2, FractionDelimiter fractionDelimiter, int fractionLength, TimeZoneFormat timeZoneFormat) {
        Calendar clonedCalendar = (Calendar)this.calendar.clone();
        if (timeZoneFormat == TimeZoneFormat.Z) {
            clonedCalendar.setTimeZone(GMT);
        }
        DecimalFormat twoDigits = new DecimalFormat("00");
        DecimalFormat fourDigits = new DecimalFormat("00");
        StringBuffer fractionFormat = new StringBuffer("");
        for (int i = 0; i < fractionLength && i < 3; ++i) {
            fractionFormat.append("0");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(fourDigits.format(clonedCalendar.get(1)));
        sb.append(twoDigits.format(clonedCalendar.get(2) + 1));
        sb.append(twoDigits.format(clonedCalendar.get(5)));
        sb.append(twoDigits.format(clonedCalendar.get(11)));
        switch (format2) {
            case YEAR_MONTH_DAY_HOUR_MIN_SEC: {
                sb.append(twoDigits.format(clonedCalendar.get(12)));
                sb.append(twoDigits.format(clonedCalendar.get(13)));
                break;
            }
            case YEAR_MONTH_DAY_HOUR_MIN_SEC_FRACTION: {
                sb.append(twoDigits.format(clonedCalendar.get(12)));
                sb.append(twoDigits.format(clonedCalendar.get(13)));
                DecimalFormat fractionDigits = new DecimalFormat(fractionFormat.toString());
                sb.append(fractionDelimiter == FractionDelimiter.COMMA ? (char)',' : '.');
                sb.append(fractionDigits.format(clonedCalendar.get(14)));
                break;
            }
            case YEAR_MONTH_DAY_HOUR_MIN: {
                sb.append(twoDigits.format(clonedCalendar.get(12)));
                break;
            }
            case YEAR_MONTH_DAY_HOUR_MIN_FRACTION: {
                sb.append(twoDigits.format(clonedCalendar.get(12)));
                double millisec = 1000 * clonedCalendar.get(13) + clonedCalendar.get(14);
                double fraction = millisec / 60000.0;
                DecimalFormat fractionDigits = new DecimalFormat("0." + fractionFormat);
                sb.append(fractionDelimiter == FractionDelimiter.COMMA ? (char)',' : '.');
                sb.append(fractionDigits.format(fraction).substring(2));
                break;
            }
            case YEAR_MONTH_DAY_HOUR_FRACTION: {
                double millisec = 60000 * clonedCalendar.get(12) + 1000 * clonedCalendar.get(13) + clonedCalendar.get(14);
                double fraction = millisec / 3600000.0;
                DecimalFormat fractionDigits = new DecimalFormat("0." + fractionFormat);
                sb.append(fractionDelimiter == FractionDelimiter.COMMA ? (char)',' : '.');
                sb.append(fractionDigits.format(fraction).substring(2));
            }
        }
        if (timeZoneFormat == TimeZoneFormat.Z && clonedCalendar.getTimeZone().hasSameRules(GMT)) {
            sb.append('Z');
        } else {
            TimeZone timeZone = clonedCalendar.getTimeZone();
            int rawOffset = timeZone.getRawOffset();
            sb.append(rawOffset < 0 ? (char)'-' : '+');
            rawOffset = Math.abs(rawOffset);
            int hour = rawOffset / 3600000;
            int minute = (rawOffset - hour * 60 * 60 * 1000) / 60000;
            if (hour < 10) {
                sb.append('0');
            }
            sb.append(hour);
            if (timeZoneFormat == TimeZoneFormat.DIFF_HOUR_MINUTE || timeZoneFormat == TimeZoneFormat.Z) {
                if (minute < 10) {
                    sb.append('0');
                }
                sb.append(minute);
            }
        }
        return sb.toString();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public String toString() {
        return this.toGeneralizedTime();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.calendar.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeneralizedTime) {
            GeneralizedTime other = (GeneralizedTime)obj;
            return this.calendar.equals(other.calendar);
        }
        return false;
    }

    @Override
    public int compareTo(GeneralizedTime other) {
        return this.calendar.compareTo(other.calendar);
    }

    public long getTime() {
        return this.calendar.getTimeInMillis();
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public int getMonth() {
        return this.calendar.get(2);
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    public int getHour() {
        return this.calendar.get(11);
    }

    public int getMinutes() {
        return this.calendar.get(12);
    }

    public int getSeconds() {
        return this.calendar.get(13);
    }

    public int getFraction() {
        return this.calendar.get(14);
    }

    public static Date getDate(String zuluTime) throws ParseException {
        return new GeneralizedTime((String)zuluTime).calendar.getTime();
    }

    public static enum TimeZoneFormat {
        Z,
        DIFF_HOUR,
        DIFF_HOUR_MINUTE;

    }

    public static enum FractionDelimiter {
        DOT,
        COMMA;

    }

    public static enum Format {
        YEAR_MONTH_DAY_HOUR_MIN_SEC,
        YEAR_MONTH_DAY_HOUR_MIN_SEC_FRACTION,
        YEAR_MONTH_DAY_HOUR_MIN,
        YEAR_MONTH_DAY_HOUR_MIN_FRACTION,
        YEAR_MONTH_DAY_HOUR,
        YEAR_MONTH_DAY_HOUR_FRACTION;

    }
}

