/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.utils;

import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.annotations.VisibleForTesting;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.Maps;
import org.spark_project.guava.collect.Sets;

public class CloseableExecutorService
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(CloseableExecutorService.class);
    private final Set<Future<?>> futures = Sets.newSetFromMap((Map)Maps.newConcurrentMap());
    private final ExecutorService executorService;
    private final boolean shutdownOnClose;
    protected final AtomicBoolean isOpen = new AtomicBoolean(true);

    public CloseableExecutorService(ExecutorService executorService) {
        this(executorService, false);
    }

    public CloseableExecutorService(ExecutorService executorService, boolean shutdownOnClose) {
        this.executorService = (ExecutorService)Preconditions.checkNotNull((Object)executorService, (Object)"executorService cannot be null");
        this.shutdownOnClose = shutdownOnClose;
    }

    public boolean isShutdown() {
        return !this.isOpen.get();
    }

    @VisibleForTesting
    int size() {
        return this.futures.size();
    }

    @Override
    public void close() {
        this.isOpen.set(false);
        Iterator<Future<?>> iterator2 = this.futures.iterator();
        while (iterator2.hasNext()) {
            Future<?> future = iterator2.next();
            iterator2.remove();
            if (future.isDone() || future.isCancelled() || future.cancel(true)) continue;
            this.log.warn("Could not cancel " + future);
        }
        if (this.shutdownOnClose) {
            this.executorService.shutdownNow();
        }
    }

    public <V> Future<V> submit(Callable<V> task) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)"CloseableExecutorService is closed");
        InternalFutureTask<V> futureTask = new InternalFutureTask<V>(new FutureTask<V>(task));
        this.executorService.execute(futureTask);
        return futureTask;
    }

    public Future<?> submit(Runnable task) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)"CloseableExecutorService is closed");
        InternalFutureTask<Object> futureTask = new InternalFutureTask<Object>(new FutureTask<Object>(task, null));
        this.executorService.execute(futureTask);
        return futureTask;
    }

    protected class InternalFutureTask<T>
    extends FutureTask<T> {
        private final RunnableFuture<T> task;

        InternalFutureTask(RunnableFuture<T> task) {
            super(task, null);
            this.task = task;
            CloseableExecutorService.this.futures.add(task);
        }

        @Override
        protected void done() {
            CloseableExecutorService.this.futures.remove(this.task);
        }
    }

    protected class InternalScheduledFutureTask
    implements Future<Void> {
        private final ScheduledFuture<?> scheduledFuture;

        public InternalScheduledFutureTask(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
            CloseableExecutorService.this.futures.add(scheduledFuture);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            CloseableExecutorService.this.futures.remove(this.scheduledFuture);
            return this.scheduledFuture.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.scheduledFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.scheduledFuture.isDone();
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }
}

