/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.StringHelper;

@InterfaceAudience.Private
public class Apps {
    public static final String APP = "application";
    public static final String ID = "ID";

    public static ApplicationId toAppID(String aid) {
        Iterator<String> it = StringHelper._split(aid).iterator();
        return Apps.toAppID(APP, aid, it);
    }

    public static ApplicationId toAppID(String prefix, String s, Iterator<String> it) {
        if (!it.hasNext() || !it.next().equals(prefix)) {
            Apps.throwParseException(StringHelper.sjoin(prefix, ID), s);
        }
        Apps.shouldHaveNext(prefix, s, it);
        ApplicationId appId = ApplicationId.newInstance(Long.parseLong(it.next()), Integer.parseInt(it.next()));
        return appId;
    }

    public static void shouldHaveNext(String prefix, String s, Iterator<String> it) {
        if (!it.hasNext()) {
            Apps.throwParseException(StringHelper.sjoin(prefix, ID), s);
        }
    }

    public static void throwParseException(String name, String s) {
        throw new YarnRuntimeException(StringHelper.join("Error parsing ", name, ": ", s));
    }

    public static void setEnvFromInputString(Map<String, String> env, String envString, String classPathSeparator) {
        if (envString != null && envString.length() > 0) {
            String[] childEnvs = envString.split(",");
            Pattern p = Pattern.compile(Shell.getEnvironmentVariableRegex());
            for (String cEnv : childEnvs) {
                String[] parts = cEnv.split("=");
                Matcher m = p.matcher(parts[1]);
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    String var = m.group(1);
                    String replace = env.get(var);
                    if (replace == null) {
                        replace = System.getenv(var);
                    }
                    if (replace == null) {
                        replace = "";
                    }
                    m.appendReplacement(sb, Matcher.quoteReplacement(replace));
                }
                m.appendTail(sb);
                Apps.addToEnvironment(env, parts[0], sb.toString(), classPathSeparator);
            }
        }
    }

    @Deprecated
    public static void setEnvFromInputString(Map<String, String> env, String envString) {
        Apps.setEnvFromInputString(env, envString, File.pathSeparator);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void addToEnvironment(Map<String, String> environment, String variable, String value2, String classPathSeparator) {
        String val = environment.get(variable);
        val = val == null ? value2 : val + classPathSeparator + value2;
        environment.put(StringInterner.weakIntern((String)variable), StringInterner.weakIntern((String)val));
    }

    @Deprecated
    public static void addToEnvironment(Map<String, String> environment, String variable, String value2) {
        Apps.addToEnvironment(environment, variable, value2, File.pathSeparator);
    }

    public static String crossPlatformify(String var) {
        return "{{" + var + "}}";
    }
}

