/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.conf.DefaultYarnConfiguration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.ExternalTokenManager;

public final class ExternalTokenManagerFactory {
    private static final Log LOG = LogFactory.getLog(ExternalTokenManagerFactory.class);
    private static ExternalTokenManager extTokenManager;

    public static ExternalTokenManager get() {
        return extTokenManager;
    }

    static {
        YarnConfiguration conf = DefaultYarnConfiguration.get();
        Class clazz = conf.getClass("yarn.external.token.manager", null, ExternalTokenManager.class);
        if (clazz != null) {
            try {
                extTokenManager = (ExternalTokenManager)clazz.newInstance();
            }
            catch (Exception e) {
                throw new YarnRuntimeException(e);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Initialized external token manager class - " + clazz.getName()));
            }
        }
    }
}

