/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

abstract class WhiteSpaceProcessor {
    WhiteSpaceProcessor() {
    }

    public static String replace(String text2) {
        return ((Object)WhiteSpaceProcessor.replace((CharSequence)text2)).toString();
    }

    public static CharSequence replace(CharSequence text2) {
        int i;
        for (i = text2.length() - 1; i >= 0 && !WhiteSpaceProcessor.isWhiteSpaceExceptSpace(text2.charAt(i)); --i) {
        }
        if (i < 0) {
            return text2;
        }
        StringBuilder buf = new StringBuilder(text2);
        buf.setCharAt(i--, ' ');
        while (i >= 0) {
            if (WhiteSpaceProcessor.isWhiteSpaceExceptSpace(buf.charAt(i))) {
                buf.setCharAt(i, ' ');
            }
            --i;
        }
        return new String(buf);
    }

    public static CharSequence trim(CharSequence text2) {
        int end;
        int start;
        int len = text2.length();
        for (start = 0; start < len && WhiteSpaceProcessor.isWhiteSpace(text2.charAt(start)); ++start) {
        }
        for (end = len - 1; end > start && WhiteSpaceProcessor.isWhiteSpace(text2.charAt(end)); --end) {
        }
        if (start == 0 && end == len - 1) {
            return text2;
        }
        return text2.subSequence(start, end + 1);
    }

    public static String collapse(String text2) {
        return ((Object)WhiteSpaceProcessor.collapse((CharSequence)text2)).toString();
    }

    public static CharSequence collapse(CharSequence text2) {
        int s;
        int len = text2.length();
        for (s = 0; s < len && !WhiteSpaceProcessor.isWhiteSpace(text2.charAt(s)); ++s) {
        }
        if (s == len) {
            return text2;
        }
        StringBuilder result = new StringBuilder(len);
        if (s != 0) {
            for (int i = 0; i < s; ++i) {
                result.append(text2.charAt(i));
            }
            result.append(' ');
        }
        boolean inStripMode = true;
        for (int i = s + 1; i < len; ++i) {
            char ch = text2.charAt(i);
            boolean b = WhiteSpaceProcessor.isWhiteSpace(ch);
            if (inStripMode && b) continue;
            inStripMode = b;
            if (inStripMode) {
                result.append(' ');
                continue;
            }
            result.append(ch);
        }
        len = result.length();
        if (len > 0 && result.charAt(len - 1) == ' ') {
            result.setLength(len - 1);
        }
        return result;
    }

    public static final boolean isWhiteSpace(CharSequence s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (WhiteSpaceProcessor.isWhiteSpace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }

    protected static final boolean isWhiteSpaceExceptSpace(char ch) {
        if (ch >= ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r';
    }
}

