/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka;

import kafka.common.TopicAndPartition;
import kafka.message.MessageAndMetadata;
import kafka.serializer.Decoder;
import org.apache.spark.SparkException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka.DirectKafkaInputDStream$;
import org.apache.spark.streaming.kafka.KafkaCluster;
import org.apache.spark.streaming.kafka.KafkaCluster$;
import org.apache.spark.streaming.kafka.KafkaRDD;
import org.apache.spark.streaming.kafka.KafkaRDD$;
import org.apache.spark.streaming.kafka.OffsetRange;
import org.apache.spark.streaming.kafka.OffsetRange$;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\t=e!B\u0001\u0003\u0001\u0011a!a\u0006#je\u0016\u001cGoS1gW\u0006Le\u000e];u\tN#(/Z1n\u0015\t\u0019A!A\u0003lC\u001a\\\u0017M\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sOV1QBW/owZ\u00192\u0001\u0001\b$!\ry!\u0003F\u0007\u0002!)\u0011\u0011\u0003B\u0001\bIN$(/Z1n\u0013\t\u0019\u0002C\u0001\u0007J]B,H\u000fR*ue\u0016\fW\u000e\u0005\u0002\u0016-1\u0001A!B\f\u0001\u0005\u0004I\"!\u0001*\u0004\u0001E\u0011!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\b\u001d>$\b.\u001b8h!\tY\u0012%\u0003\u0002#9\t\u0019\u0011I\\=\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u00192\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005!*#a\u0002'pO\u001eLgn\u001a\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u0005!ql]:d!\taS&D\u0001\u0005\u0013\tqCA\u0001\tTiJ,\u0017-\\5oO\u000e{g\u000e^3yi\"A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011'A\u0006lC\u001a\\\u0017\rU1sC6\u001cX#\u0001\u001a\u0011\tM2\u0014(\u000f\b\u00037QJ!!\u000e\u000f\u0002\rA\u0013X\rZ3g\u0013\t9\u0004HA\u0002NCBT!!\u000e\u000f\u0011\u0005MR\u0014BA\u001e9\u0005\u0019\u0019FO]5oO\"AQ\b\u0001B\u0001B\u0003%!'\u0001\u0007lC\u001a\\\u0017\rU1sC6\u001c\b\u0005\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001A\u0003-1'o\\7PM\u001a\u001cX\r^:\u0016\u0003\u0005\u0003Ba\r\u001cC\u0013B\u00111iR\u0007\u0002\t*\u0011QIR\u0001\u0007G>lWn\u001c8\u000b\u0003\rI!\u0001\u0013#\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\u001c\u0015&\u00111\n\b\u0002\u0005\u0019>tw\r\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003B\u000311'o\\7PM\u001a\u001cX\r^:!\u0011!y\u0005A!A!\u0002\u0013\u0001\u0016AD7fgN\fw-\u001a%b]\u0012dWM\u001d\t\u00057E\u001bF#\u0003\u0002S9\tIa)\u001e8di&|g.\r\t\u0005)^KF,D\u0001V\u0015\t1f)A\u0004nKN\u001c\u0018mZ3\n\u0005a+&AE'fgN\fw-Z!oI6+G/\u00193bi\u0006\u0004\"!\u0006.\u0005\u000bm\u0003!\u0019A\r\u0003\u0003-\u0003\"!F/\u0005\u000by\u0003!\u0019A\r\u0003\u0003YC\u0001\u0002\u0019\u0001\u0003\u0004\u0003\u0006Y!Y\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u00012f36\t1M\u0003\u0002e9\u00059!/\u001a4mK\u000e$\u0018B\u00014d\u0005!\u0019E.Y:t)\u0006<\u0007\u0002\u00035\u0001\u0005\u0007\u0005\u000b1B5\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0002cKrC\u0001b\u001b\u0001\u0003\u0004\u0003\u0006Y\u0001\\\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004c\u00012f[B\u0011QC\u001c\u0003\u0006_\u0002\u0011\r\u0001\u001d\u0002\u0002+F\u0011!$\u001d\t\u0004eVLV\"A:\u000b\u0005Q4\u0015AC:fe&\fG.\u001b>fe&\u0011ao\u001d\u0002\b\t\u0016\u001cw\u000eZ3s\u0011!A\bAaA!\u0002\u0017I\u0018AC3wS\u0012,gnY3%iA\u0019!-\u001a>\u0011\u0005UYH!\u0002?\u0001\u0005\u0004i(!\u0001+\u0012\u0005iq\bc\u0001:v9\"Q\u0011\u0011\u0001\u0001\u0003\u0004\u0003\u0006Y!a\u0001\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$S\u0007E\u0002cKRAq!a\u0002\u0001\t\u0003\tI!\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003\u0017\tY\"!\b\u0002 \u0005\u0005B\u0003DA\u0007\u0003#\t\u0019\"!\u0006\u0002\u0018\u0005e\u0001\u0003CA\b\u0001ecVN\u001f\u000b\u000e\u0003\tAa\u0001YA\u0003\u0001\b\t\u0007B\u00025\u0002\u0006\u0001\u000f\u0011\u000e\u0003\u0004l\u0003\u000b\u0001\u001d\u0001\u001c\u0005\u0007q\u0006\u0015\u00019A=\t\u0011\u0005\u0005\u0011Q\u0001a\u0002\u0003\u0007AaAKA\u0003\u0001\u0004Y\u0003B\u0002\u0019\u0002\u0006\u0001\u0007!\u0007\u0003\u0004@\u0003\u000b\u0001\r!\u0011\u0005\u0007\u001f\u0006\u0015\u0001\u0019\u0001)\t\u0013\u0005\u0015\u0002A1A\u0005\u0002\u0005\u001d\u0012AC7bqJ+GO]5fgV\u0011\u0011\u0011\u0006\t\u00047\u0005-\u0012bAA\u00179\t\u0019\u0011J\u001c;\t\u0011\u0005E\u0002\u0001)A\u0005\u0003S\t1\"\\1y%\u0016$(/[3tA!A\u0011Q\u0007\u0001\u0005B\u0011\t9$\u0001\u0003oC6,W#A\u001d\t\u0015\u0005m\u0002A1A\u0005R\u0011\ti$\u0001\bdQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\u0016\u0005\u0005}\u0002\u0003BA!\u0003\u0007j\u0011\u0001\u0001\u0004\b\u0003\u000b\u0002\u0001\u0001BA$\u0005\u0015\"\u0015N]3di.\u000bgm[1J]B,H\u000fR*ue\u0016\fWn\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018m\u0005\u0003\u0002D\u0005%\u0003\u0003B\b\u0002LQI1!!\u0014\u0011\u0005U!5\u000b\u001e:fC6\u001c\u0005.Z2la>Lg\u000e\u001e#bi\u0006D\u0001\"a\u0002\u0002D\u0011\u0005\u0011\u0011\u000b\u000b\u0003\u0003\u007fA\u0001\"!\u0016\u0002D\u0011\u0005\u0011qK\u0001\rE\u0006$8\r\u001b$peRKW.Z\u000b\u0003\u00033\u0002\u0002\"a\u0017\u0002f\u0005%\u0014qN\u0007\u0003\u0003;RA!a\u0018\u0002b\u00059Q.\u001e;bE2,'bAA29\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0014Q\f\u0002\b\u0011\u0006\u001c\b.T1q!\ra\u00131N\u0005\u0004\u0003[\"!\u0001\u0002+j[\u0016\u0004RaGA9\u0003kJ1!a\u001d\u001d\u0005\u0015\t%O]1z!!Y\u0012qO\u001d\u0002*%K\u0015bAA=9\t1A+\u001e9mKRB\u0001\"! \u0002D\u0011\u0005\u0013qP\u0001\u0007kB$\u0017\r^3\u0015\t\u0005\u0005\u0015q\u0011\t\u00047\u0005\r\u0015bAAC9\t!QK\\5u\u0011!\tI)a\u001fA\u0002\u0005%\u0014\u0001\u0002;j[\u0016D\u0001\"!$\u0002D\u0011\u0005\u0013qR\u0001\bG2,\u0017M\\;q)\u0011\t\t)!%\t\u0011\u0005%\u00151\u0012a\u0001\u0003SB\u0001\"!&\u0002D\u0011\u0005\u0013qS\u0001\be\u0016\u001cHo\u001c:f)\t\t\t\t\u0003\u0005\u0002\u001c\u0002\u0001\u000b\u0011BA \u0003=\u0019\u0007.Z2la>Lg\u000e\u001e#bi\u0006\u0004\u0003BCAP\u0001\t\u0007I\u0011\u000b\u0003\u0002\"\u0006q!/\u0019;f\u0007>tGO]8mY\u0016\u0014XCAAR!\u0015Y\u0012QUAU\u0013\r\t9\u000b\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u0016\u0011W\u0007\u0003\u0003[S1!a,\u0005\u0003%\u00198\r[3ek2,'/\u0003\u0003\u00024\u00065&A\u0004*bi\u0016\u001cuN\u001c;s_2dWM\u001d\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u0002$\u0006y!/\u0019;f\u0007>tGO]8mY\u0016\u0014\b\u0005C\u0005\u0002<\u0002\u0011\r\u0011\"\u0005\u0002>\u0006\u00111nY\u000b\u0003\u0003\u007f\u0003B!a\u0004\u0002B&\u0019\u00111\u0019\u0002\u0003\u0019-\u000bgm[1DYV\u001cH/\u001a:\t\u0011\u0005\u001d\u0007\u0001)A\u0005\u0003\u007f\u000b1a[2!\u0011%\tY\r\u0001b\u0001\n\u0013\ti-\u0001\rnCb\u0014\u0016\r^3MS6LG\u000fU3s!\u0006\u0014H/\u001b;j_:,\u0012!\u0013\u0005\b\u0003#\u0004\u0001\u0015!\u0003J\u0003ei\u0017\r\u001f*bi\u0016d\u0015.\\5u!\u0016\u0014\b+\u0019:uSRLwN\u001c\u0011\t\u0013\u0005U\u0007A1A\u0005\n\u00055\u0017aC5oSRL\u0017\r\u001c*bi\u0016Dq!!7\u0001A\u0003%\u0011*\u0001\u0007j]&$\u0018.\u00197SCR,\u0007\u0005\u0003\u0005\u0002^\u0002!\t\u0002BAp\u0003]i\u0017\r_'fgN\fw-Z:QKJ\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0002b\u0006\r\b\u0003B\u000e\u0002&\u0006Cq!!:\u0002\\\u0002\u0007\u0011)A\u0004pM\u001a\u001cX\r^:\t\u0011\u0005%\b\u00011A\u0005\u0012\u0001\u000babY;se\u0016tGo\u00144gg\u0016$8\u000fC\u0005\u0002n\u0002\u0001\r\u0011\"\u0005\u0002p\u0006\u00112-\u001e:sK:$xJ\u001a4tKR\u001cx\fJ3r)\u0011\t\t)!=\t\u0013\u0005M\u00181^A\u0001\u0002\u0004\t\u0015a\u0001=%c!9\u0011q\u001f\u0001!B\u0013\t\u0015aD2veJ,g\u000e^(gMN,Go\u001d\u0011\t\u000f\u0005m\b\u0001\"\u0006\u0002~\u0006\u0019B.\u0019;fgRdU-\u00193fe>3gm]3ugR!\u0011q B\u0015!\u0015\u0019dG\u0011B\u0001!\u0011\u0011\u0019Aa\t\u000f\t\t\u0015!q\u0004\b\u0005\u0005\u000f\u0011iB\u0004\u0003\u0003\n\tma\u0002\u0002B\u0006\u00053qAA!\u0004\u0003\u00189!!q\u0002B\u000b\u001b\t\u0011\tBC\u0002\u0003\u0014a\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t%\u0019!\u0011\u0005\u0002\u0002\u0019-\u000bgm[1DYV\u001cH/\u001a:\n\t\t\u0015\"q\u0005\u0002\r\u0019\u0016\fG-\u001a:PM\u001a\u001cX\r\u001e\u0006\u0004\u0005C\u0011\u0001\u0002\u0003B\u0016\u0003s\u0004\r!!\u000b\u0002\u000fI,GO]5fg\"\"\u0011\u0011 B\u0018!\u0011\u0011\tDa\u000e\u000e\u0005\tM\"b\u0001B\u001b9\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\te\"1\u0007\u0002\bi\u0006LGN]3d\u0011\u001d\u0011i\u0004\u0001C\t\u0005\u007f\tQa\u00197b[B$B!a@\u0003B!A!1\tB\u001e\u0001\u0004\ty0A\u0007mK\u0006$WM](gMN,Go\u001d\u0005\b\u0005\u000f\u0002A\u0011\tB%\u0003\u001d\u0019w.\u001c9vi\u0016$BAa\u0013\u0003TA)1$!*\u0003NAI\u0011q\u0002B(3rk'\u0010F\u0005\u0004\u0005#\u0012!\u0001C&bM.\f'\u000b\u0012#\t\u0011\tU#Q\ta\u0001\u0003S\n\u0011B^1mS\u0012$\u0016.\\3\t\u000f\te\u0003\u0001\"\u0011\u0002\u0018\u0006)1\u000f^1si\"9!Q\f\u0001\u0005\u0002\u0005]\u0015\u0001B:u_B4qA!\u0019\u0001\u0001\u0011\u0011\u0019GA\rESJ,7\r^&bM.\f'+\u0019;f\u0007>tGO]8mY\u0016\u00148\u0003\u0002B0\u0003SCQBa\u001a\u0003`\t\u0005\t\u0015!\u0003\u0002*\t%\u0014AA5e\u0013\u0011\u0011Y'!-\u0002\u0013M$(/Z1n+&#\u0005b\u0003B8\u0005?\u0012\t\u0011)A\u0005\u0005c\n\u0011\"Z:uS6\fGo\u001c:\u0011\t\tM$\u0011P\u0007\u0003\u0005kRAAa\u001e\u0002.\u0006!!/\u0019;f\u0013\u0011\u0011YH!\u001e\u0003\u001bI\u000bG/Z#ti&l\u0017\r^8s\u0011!\t9Aa\u0018\u0005\u0002\t}DC\u0002BA\u0005\u0007\u0013)\t\u0005\u0003\u0002B\t}\u0003\u0002\u0003B4\u0005{\u0002\r!!\u000b\t\u0011\t=$Q\u0010a\u0001\u0005cB\u0001B!#\u0003`\u0011\u0005#1R\u0001\baV\u0014G.[:i)\u0011\t\tI!$\t\u000f\t]$q\u0011a\u0001\u0013\u0002")
public class DirectKafkaInputDStream<K, V, U extends Decoder<K>, T extends Decoder<V>, R>
extends InputDStream<R> {
    private final Map<String, String> kafkaParams;
    private final Map<TopicAndPartition, Object> fromOffsets;
    public final Function1<MessageAndMetadata<K, V>, R> org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$messageHandler;
    public final ClassTag<K> org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$1;
    public final ClassTag<V> org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$2;
    public final ClassTag<U> org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$3;
    public final ClassTag<T> org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$4;
    public final ClassTag<R> org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$5;
    private final int maxRetries;
    private final DirectKafkaInputDStreamCheckpointData checkpointData;
    private final Option<RateController> rateController;
    private final KafkaCluster kc;
    private final long org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$maxRateLimitPerPartition;
    private final long org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$initialRate;
    private Map<TopicAndPartition, Object> currentOffsets;

    public Map<String, String> kafkaParams() {
        return this.kafkaParams;
    }

    public Map<TopicAndPartition, Object> fromOffsets() {
        return this.fromOffsets;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public String name() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kafka direct stream [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())}));
    }

    public DirectKafkaInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    public Option<RateController> rateController() {
        return this.rateController;
    }

    public KafkaCluster kc() {
        return this.kc;
    }

    public long org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$maxRateLimitPerPartition() {
        return this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$maxRateLimitPerPartition;
    }

    public long org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$initialRate() {
        return this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$initialRate;
    }

    public Option<Map<TopicAndPartition, Object>> maxMessagesPerPartition(Map<TopicAndPartition, Object> offsets) {
        Option option;
        block7: {
            None$ none$;
            Map map2;
            block6: {
                block5: {
                    Option estimatedRateLimit = this.rateController().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;

                        public final long apply(RateController x) {
                            long lr = x.getLatestRate();
                            return lr > 0L ? lr : this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$initialRate();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    option = estimatedRateLimit.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(long x$1) {
                            return this.apply$mcZJ$sp(x$1);
                        }

                        public boolean apply$mcZJ$sp(long x$1) {
                            return x$1 > 0L;
                        }
                    });
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    long rate = BoxesRunTime.unboxToLong((Object)some.x());
                    Map lagPerPartition = (Map)offsets.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;

                        public final Tuple2<TopicAndPartition, Object> apply(Tuple2<TopicAndPartition, Object> x0$1) {
                            Tuple2<TopicAndPartition, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                                long offset = tuple2._2$mcJ$sp();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max(offset - BoxesRunTime.unboxToLong((Object)this.$outer.currentOffsets().apply((Object)tp)), 0L)));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    long totalLag = BoxesRunTime.unboxToLong((Object)lagPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    map2 = (Map)lagPerPartition.map((Function1)new Serializable(this, rate, totalLag){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;
                        private final long rate$1;
                        private final long totalLag$1;

                        public final Tuple2<TopicAndPartition, Object> apply(Tuple2<TopicAndPartition, Object> x0$2) {
                            Tuple2<TopicAndPartition, Object> tuple2 = x0$2;
                            if (tuple2 != null) {
                                TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                                long lag = tuple2._2$mcJ$sp();
                                double backpressureRate = (double)lag / (double)this.totalLag$1 * (double)this.rate$1;
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)(this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$maxRateLimitPerPartition() > 0L ? BoxesRunTime.boxToDouble((double)Math.min(backpressureRate, (double)this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$maxRateLimitPerPartition())) : BoxesRunTime.boxToDouble((double)backpressureRate)));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rate$1 = rate$1;
                            this.totalLag$1 = totalLag$1;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    break block6;
                }
                if (!None$.MODULE$.equals(option)) break block7;
                map2 = (Map)offsets.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DirectKafkaInputDStream $outer;

                    public final Tuple2<TopicAndPartition, Object> apply(Tuple2<TopicAndPartition, Object> x0$3) {
                        Tuple2<TopicAndPartition, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$maxRateLimitPerPartition()));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            Map effectiveRateLimitPerPartition = map2;
            if (BoxesRunTime.unboxToDouble((Object)effectiveRateLimitPerPartition.values().sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) > 0.0) {
                double secsPerBatch = (double)this.context().graph().batchDuration().milliseconds() / (double)1000;
                none$ = new Some(effectiveRateLimitPerPartition.map((Function1)new Serializable(this, secsPerBatch){
                    public static final long serialVersionUID = 0L;
                    private final double secsPerBatch$1;

                    public final Tuple2<TopicAndPartition, Object> apply(Tuple2<TopicAndPartition, Object> x0$4) {
                        Tuple2<TopicAndPartition, Object> tuple2 = x0$4;
                        if (tuple2 != null) {
                            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                            double limit = tuple2._2$mcD$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max((long)(this.secsPerBatch$1 * limit), 1L)));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.secsPerBatch$1 = secsPerBatch$1;
                    }
                }, Map$.MODULE$.canBuildFrom()));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)option);
    }

    public Map<TopicAndPartition, Object> currentOffsets() {
        return this.currentOffsets;
    }

    public void currentOffsets_$eq(Map<TopicAndPartition, Object> x$1) {
        this.currentOffsets = x$1;
    }

    public final Map<TopicAndPartition, KafkaCluster.LeaderOffset> latestLeaderOffsets(int retries) {
        Either<ArrayBuffer<Throwable>, Map<TopicAndPartition, KafkaCluster.LeaderOffset>> o;
        while ((o = this.kc().getLatestLeaderOffsets((Set<TopicAndPartition>)this.currentOffsets().keySet())).isLeft()) {
            String err2 = ((SeqLike)o.left().get()).toString();
            if (retries <= 0) {
                throw new SparkException(err2);
            }
            this.logError((Function0)new Serializable(this, err2){
                public static final long serialVersionUID = 0L;
                private final String err$1;

                public final String apply() {
                    return this.err$1;
                }
                {
                    this.err$1 = err$1;
                }
            });
            Thread.sleep(this.kc().config().refreshLeaderBackoffMs());
            --retries;
        }
        return (Map)o.right().get();
    }

    public Map<TopicAndPartition, KafkaCluster.LeaderOffset> clamp(Map<TopicAndPartition, KafkaCluster.LeaderOffset> leaderOffsets) {
        Map offsets = leaderOffsets.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(KafkaCluster.LeaderOffset lo) {
                return lo.offset();
            }
        });
        return (Map)this.maxMessagesPerPartition((Map<TopicAndPartition, Object>)offsets).map((Function1)new Serializable(this, leaderOffsets){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectKafkaInputDStream $outer;
            public final Map leaderOffsets$1;

            public final Map<TopicAndPartition, KafkaCluster.LeaderOffset> apply(Map<TopicAndPartition, Object> mmp) {
                return (Map)mmp.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$clamp$1 $outer;

                    public final Tuple2<TopicAndPartition, KafkaCluster.LeaderOffset> apply(Tuple2<TopicAndPartition, Object> x0$5) {
                        Tuple2<TopicAndPartition, Object> tuple2 = x0$5;
                        if (tuple2 != null) {
                            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                            long messages = tuple2._2$mcJ$sp();
                            KafkaCluster.LeaderOffset lo = (KafkaCluster.LeaderOffset)this.$outer.leaderOffsets$1.apply((Object)tp);
                            long x$5 = Math.min(BoxesRunTime.unboxToLong((Object)this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$anonfun$$$outer().currentOffsets().apply((Object)tp)) + messages, lo.offset());
                            String x$6 = lo.copy$default$1();
                            int x$7 = lo.copy$default$2();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)lo.copy(x$6, x$7, x$5));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderOffsets$1 = leaderOffsets$1;
            }
        }).getOrElse((Function0)new Serializable(this, leaderOffsets){
            public static final long serialVersionUID = 0L;
            private final Map leaderOffsets$1;

            public final Map<TopicAndPartition, KafkaCluster.LeaderOffset> apply() {
                return this.leaderOffsets$1;
            }
            {
                this.leaderOffsets$1 = leaderOffsets$1;
            }
        });
    }

    public Option<KafkaRDD<K, V, U, T, R>> compute(Time validTime) {
        Map<TopicAndPartition, KafkaCluster.LeaderOffset> untilOffsets = this.clamp(this.latestLeaderOffsets(this.maxRetries()));
        KafkaRDD<K, V, U, T, R> rdd = KafkaRDD$.MODULE$.apply(this.context().sparkContext(), this.kafkaParams(), this.currentOffsets(), untilOffsets, this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$messageHandler, this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$1, this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$2, this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$3, this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$4, this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$5);
        Iterable offsetRanges = (Iterable)this.currentOffsets().map((Function1)new Serializable(this, untilOffsets){
            public static final long serialVersionUID = 0L;
            private final Map untilOffsets$1;

            public final OffsetRange apply(Tuple2<TopicAndPartition, Object> x0$6) {
                Tuple2<TopicAndPartition, Object> tuple2 = x0$6;
                if (tuple2 != null) {
                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                    long fo = tuple2._2$mcJ$sp();
                    KafkaCluster.LeaderOffset uo = (KafkaCluster.LeaderOffset)this.untilOffsets$1.apply((Object)tp);
                    OffsetRange offsetRange = OffsetRange$.MODULE$.apply(tp.topic(), tp.partition(), fo, uo.offset());
                    return offsetRange;
                }
                throw new MatchError(tuple2);
            }
            {
                this.untilOffsets$1 = untilOffsets$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        String description = ((TraversableOnce)((TraversableLike)offsetRanges.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(OffsetRange offsetRange) {
                return offsetRange.fromOffset() != offsetRange.untilOffset();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(OffsetRange offsetRange) {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic: ", "\\tpartition: ", "\\t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offsetRange.topic(), BoxesRunTime.boxToInteger((int)offsetRange.partition())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offsets: ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offsetRange.fromOffset()), BoxesRunTime.boxToLong((long)offsetRange.untilOffset())}))).toString();
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
        Map metadata = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsets"), (Object)offsetRanges.toList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), (Object)description)}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), rdd.count(), metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        this.currentOffsets_$eq((Map<TopicAndPartition, Object>)((Map)untilOffsets.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicAndPartition, Object> apply(Tuple2<TopicAndPartition, KafkaCluster.LeaderOffset> kv) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)BoxesRunTime.boxToLong((long)((KafkaCluster.LeaderOffset)kv._2()).offset()));
            }
        }, Map$.MODULE$.canBuildFrom())));
        return new Some(rdd);
    }

    public void start() {
    }

    public void stop() {
    }

    public DirectKafkaInputDStream(StreamingContext _ssc, Map<String, String> kafkaParams, Map<TopicAndPartition, Object> fromOffsets, Function1<MessageAndMetadata<K, V>, R> messageHandler, ClassTag<K> evidence$1, ClassTag<V> evidence$2, ClassTag<U> evidence$3, ClassTag<T> evidence$4, ClassTag<R> evidence$5) {
        this.kafkaParams = kafkaParams;
        this.fromOffsets = fromOffsets;
        this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$messageHandler = messageHandler;
        this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$1 = evidence$1;
        this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$2 = evidence$2;
        this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$3 = evidence$3;
        this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$4 = evidence$4;
        this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$5 = evidence$5;
        super(_ssc, evidence$5);
        this.maxRetries = this.context().sparkContext().getConf().getInt("spark.streaming.kafka.maxRetries", 1);
        this.checkpointData = new DirectKafkaInputDStreamCheckpointData();
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some((Object)new DirectKafkaRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.context().graph().batchDuration()))) : None$.MODULE$;
        this.kc = new KafkaCluster(kafkaParams);
        this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$maxRateLimitPerPartition = this.context().sparkContext().getConf().getLong("spark.streaming.kafka.maxRatePerPartition", 0L);
        this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$initialRate = this.context().sparkContext().getConf().getLong("spark.streaming.backpressure.initialRate", 0L);
        this.currentOffsets = fromOffsets;
    }

    public class DirectKafkaRateController
    extends RateController {
        public void publish(long rate) {
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaRateController$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaRateController(int id, RateEstimator estimator) {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }

    public class DirectKafkaInputDStreamCheckpointData
    extends DStreamCheckpointData<R> {
        public HashMap<Time, Tuple4<String, Object, Object, Object>[]> batchForTime() {
            return this.data();
        }

        public void update(Time time) {
            this.batchForTime().clear();
            this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStreamCheckpointData $outer;

                public final HashMap<Time, Tuple4<String, Object, Object, Object>[]> apply(Tuple2<Time, RDD<R>> kv) {
                    Tuple4[] a = (Tuple4[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((KafkaRDD)kv._2()).offsetRanges()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple4<String, Object, Object, Object> apply(OffsetRange x$2) {
                            return x$2.toTuple();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class)))).toArray(ClassTag$.MODULE$.apply(Tuple4.class));
                    return this.$outer.batchForTime().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)a));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public void cleanup(Time time) {
        }

        public void restore() {
            Set topics = this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().fromOffsets().keySet();
            Map<TopicAndPartition, Tuple2<String, Object>> leaders = KafkaCluster$.MODULE$.checkErrors(this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().kc().findLeaders((Set<TopicAndPartition>)topics));
            ((IterableLike)this.batchForTime().toSeq().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Time apply(Tuple2<Time, Tuple4<String, Object, Object, Object>[]> x$3) {
                    return (Time)x$3._1();
                }
            }, Time$.MODULE$.ordering())).foreach((Function1)new Serializable(this, leaders){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStreamCheckpointData $outer;
                private final Map leaders$1;

                public final HashMap<Time, RDD<R>> apply(Tuple2<Time, Tuple4<String, Object, Object, Object>[]> x0$7) {
                    Tuple2<Time, Tuple4<String, Object, Object, Object>[]> tuple2 = x0$7;
                    if (tuple2 != null) {
                        Time t = (Time)tuple2._1();
                        Tuple4[] b = (Tuple4[])tuple2._2();
                        this.$outer.logInfo((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final Time t$1;
                            private final Tuple4[] b$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restoring KafkaRDD for time ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.t$1, Predef$.MODULE$.refArrayOps((Object[])this.b$1).mkString("[", ", ", "]")}));
                            }
                            {
                                this.t$1 = t$1;
                                this.b$1 = b$1;
                            }
                        });
                        HashMap hashMap = this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), new KafkaRDD<K, V, U, T, R>(this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().context().sparkContext(), this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().kafkaParams(), (OffsetRange[])Predef$.MODULE$.refArrayOps((Object[])b).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final OffsetRange apply(Tuple4<String, Object, Object, Object> x$4) {
                                return OffsetRange$.MODULE$.apply(x$4);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OffsetRange.class))), (Map<TopicAndPartition, Tuple2<String, Object>>)this.leaders$1, this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$messageHandler, this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$1, this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$2, this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$3, this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$4, this.$outer.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$5)));
                        return hashMap;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.leaders$1 = leaders$1;
                }
            });
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaInputDStreamCheckpointData() {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(DirectKafkaInputDStream.this, DirectKafkaInputDStream.this.org$apache$spark$streaming$kafka$DirectKafkaInputDStream$$evidence$5);
        }
    }
}

