/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeToLabelsList;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.RMHAServiceTarget;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.spark_project.guava.base.Charsets;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.ImmutableMap;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMAdminCLI
extends HAAdmin {
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private boolean directlyAccessNodeLabelStore = false;
    static CommonNodeLabelsManager localNodeLabelsManager = null;
    private static final String NO_LABEL_ERR_MSG = "No cluster node-labels are specified";
    private static final String NO_MAPPING_ERR_MSG = "No node-to-labels mappings are specified";
    protected static final Map<String, HAAdmin.UsageInfo> ADMIN_USAGE = ImmutableMap.builder().put((Object)"-refreshQueues", (Object)new HAAdmin.UsageInfo("", "Reload the queues' acls, states and scheduler specific properties. \n\t\tResourceManager will reload the mapred-queues configuration file.")).put((Object)"-refreshNodes", (Object)new HAAdmin.UsageInfo("", "Refresh the hosts information at the ResourceManager.")).put((Object)"-refreshSuperUserGroupsConfiguration", (Object)new HAAdmin.UsageInfo("", "Refresh superuser proxy groups mappings")).put((Object)"-refreshUserToGroupsMappings", (Object)new HAAdmin.UsageInfo("", "Refresh user-to-groups mappings")).put((Object)"-refreshAdminAcls", (Object)new HAAdmin.UsageInfo("", "Refresh acls for administration of ResourceManager")).put((Object)"-showLabels", (Object)new HAAdmin.UsageInfo("", "Show labels for nodes in the cluster")).put((Object)"-refreshLabels", (Object)new HAAdmin.UsageInfo("", "Refresh labels for nodes in the cluster")).put((Object)"-refreshServiceAcl", (Object)new HAAdmin.UsageInfo("", "Reload the service-level authorization policy file. \n\t\tResoureceManager will reload the authorization policy file.")).put((Object)"-getGroups", (Object)new HAAdmin.UsageInfo("[username]", "Get the groups which given user belongs to.")).build();

    public RMAdminCLI() {
    }

    public RMAdminCLI(Configuration conf) {
        super(conf);
    }

    protected void setErrOut(PrintStream errOut) {
        this.errOut = errOut;
    }

    private static void appendHAUsage(StringBuilder usageBuilder) {
        for (Map.Entry cmdEntry : USAGE.entrySet()) {
            if (((String)cmdEntry.getKey()).equals("-help")) continue;
            HAAdmin.UsageInfo usageInfo = (HAAdmin.UsageInfo)cmdEntry.getValue();
            usageBuilder.append(" [" + (String)cmdEntry.getKey() + " " + usageInfo.args + "]");
        }
    }

    private static void buildHelpMsg(String cmd, StringBuilder builder) {
        HAAdmin.UsageInfo usageInfo = ADMIN_USAGE.get(cmd);
        if (usageInfo == null && (usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmd)) == null) {
            return;
        }
        String space = usageInfo.args == "" ? "" : " ";
        builder.append("   " + cmd + space + usageInfo.args + ": " + usageInfo.help);
    }

    private static void buildIndividualUsageMsg(String cmd, StringBuilder builder) {
        boolean isHACommand = false;
        HAAdmin.UsageInfo usageInfo = ADMIN_USAGE.get(cmd);
        if (usageInfo == null) {
            usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmd);
            if (usageInfo == null) {
                return;
            }
            isHACommand = true;
        }
        String space = usageInfo.args == "" ? "" : " ";
        builder.append("Usage: yarn rmadmin [" + cmd + space + usageInfo.args + "]\n");
        if (isHACommand) {
            builder.append(cmd + " can only be used when RM HA is enabled");
        }
    }

    private static void printNodeLabelsMsg() {
        System.out.println("Please refer to http://doc.mapr.com/display/MapR/Label-based+Scheduling to learn how to configure label based scheduling.");
    }

    private static void buildUsageMsg(StringBuilder builder, boolean isHAEnabled) {
        builder.append("Usage: yarn rmadmin\n");
        for (Map.Entry<String, HAAdmin.UsageInfo> entry2 : ADMIN_USAGE.entrySet()) {
            HAAdmin.UsageInfo usageInfo = entry2.getValue();
            builder.append("   " + entry2.getKey() + " " + usageInfo.args + "\n");
        }
        if (isHAEnabled) {
            for (Map.Entry<String, Object> entry3 : USAGE.entrySet()) {
                String cmdKey = entry3.getKey();
                if (cmdKey.equals("-help")) continue;
                HAAdmin.UsageInfo usageInfo = (HAAdmin.UsageInfo)entry3.getValue();
                builder.append("   " + cmdKey + " " + usageInfo.args + "\n");
            }
        }
        builder.append("   -help [cmd]\n");
    }

    private static void printHelp(String cmd, boolean isHAEnabled) {
        StringBuilder summary = new StringBuilder();
        summary.append("rmadmin is the command to execute YARN administrative commands.\n");
        summary.append("The full syntax is: \n\nyarn rmadmin [-refreshQueues] [-refreshNodes] [-refreshSuperUserGroupsConfiguration] [-refreshUserToGroupsMappings] [-refreshAdminAcls] [-showLabels] [-refreshLabels] [-refreshServiceAcl] [-getGroup [username]]");
        if (isHAEnabled) {
            RMAdminCLI.appendHAUsage(summary);
        }
        summary.append(" [-help [cmd]]");
        summary.append("\n");
        StringBuilder helpBuilder = new StringBuilder();
        System.out.println(summary);
        for (String cmdKey : ADMIN_USAGE.keySet()) {
            RMAdminCLI.buildHelpMsg(cmdKey, helpBuilder);
            helpBuilder.append("\n");
        }
        if (isHAEnabled) {
            for (String cmdKey : USAGE.keySet()) {
                if (cmdKey.equals("-help")) continue;
                RMAdminCLI.buildHelpMsg(cmdKey, helpBuilder);
                helpBuilder.append("\n");
            }
        }
        helpBuilder.append("   -help [cmd]: Displays help for the given command or all commands if none is specified.");
        System.out.println(helpBuilder);
        System.out.println();
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
    }

    private static void printUsage(String cmd, boolean isHAEnabled) {
        StringBuilder usageBuilder = new StringBuilder();
        if (ADMIN_USAGE.containsKey(cmd) || USAGE.containsKey(cmd)) {
            RMAdminCLI.buildIndividualUsageMsg(cmd, usageBuilder);
        } else {
            RMAdminCLI.buildUsageMsg(usageBuilder, isHAEnabled);
        }
        System.err.println(usageBuilder);
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
    }

    protected ResourceManagerAdministrationProtocol createAdminProtocol() throws IOException {
        YarnConfiguration conf = new YarnConfiguration(this.getConf());
        return ClientRMProxy.createRMProxy(conf, ResourceManagerAdministrationProtocol.class);
    }

    private int refreshQueues() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshQueuesRequest request = this.recordFactory.newRecordInstance(RefreshQueuesRequest.class);
        adminProtocol.refreshQueues(request);
        return 0;
    }

    private int refreshNodes() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshNodesRequest request = this.recordFactory.newRecordInstance(RefreshNodesRequest.class);
        adminProtocol.refreshNodes(request);
        return 0;
    }

    private int showLabels() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        GetClusterNodeLabelsRequest request = this.recordFactory.newRecordInstance(GetClusterNodeLabelsRequest.class);
        GetClusterNodeLabelsResponse response = adminProtocol.getClusterNodeLabels(request);
        this.displayNodeLabelsList(response.getClusterNodeLabels());
        return 0;
    }

    private void displayNodeLabelsList(List<NodeToLabelsList> nodeLabels) {
        String headerPattern = "%23s\t%10s\n";
        String dataPattern = "%23s\t%10s\n";
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, Charsets.UTF_8));
        writer.printf(headerPattern, "Nodes", "Labels");
        for (NodeToLabelsList singleNodeLabels : nodeLabels) {
            writer.printf(dataPattern, singleNodeLabels.getNode(), singleNodeLabels.getNodeLabel().toString());
        }
        writer.flush();
    }

    private int refreshLabels() throws IOException, YarnException {
        RefreshClusterNodeLabelsRequest request;
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshClusterNodeLabelsResponse response = adminProtocol.refreshClusterNodeLabels(request = this.recordFactory.newRecordInstance(RefreshClusterNodeLabelsRequest.class));
        if (response.getIsRefreshLabelsComplete()) {
            System.out.println("Refreshed labels for nodes in the cluster successfully.\n");
        } else {
            System.out.println("Failed to refresh labels for nodes in the cluster.\n");
        }
        return 0;
    }

    private int refreshUserToGroupsMappings() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshUserToGroupsMappingsRequest request = this.recordFactory.newRecordInstance(RefreshUserToGroupsMappingsRequest.class);
        adminProtocol.refreshUserToGroupsMappings(request);
        return 0;
    }

    private int refreshSuperUserGroupsConfiguration() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshSuperUserGroupsConfigurationRequest request = this.recordFactory.newRecordInstance(RefreshSuperUserGroupsConfigurationRequest.class);
        adminProtocol.refreshSuperUserGroupsConfiguration(request);
        return 0;
    }

    private int refreshAdminAcls() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshAdminAclsRequest request = this.recordFactory.newRecordInstance(RefreshAdminAclsRequest.class);
        adminProtocol.refreshAdminAcls(request);
        return 0;
    }

    private int refreshServiceAcls() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshServiceAclsRequest request = this.recordFactory.newRecordInstance(RefreshServiceAclsRequest.class);
        adminProtocol.refreshServiceAcls(request);
        return 0;
    }

    private int getGroups(String[] usernames) throws IOException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        if (usernames.length == 0) {
            usernames = new String[]{UserGroupInformation.getCurrentUser().getUserName()};
        }
        for (String username : usernames) {
            StringBuilder sb = new StringBuilder();
            sb.append(username + " :");
            for (String group : adminProtocol.getGroupsForUser(username)) {
                sb.append(" ");
                sb.append(group);
            }
            System.out.println(sb);
        }
        return 0;
    }

    protected static synchronized CommonNodeLabelsManager getNodeLabelManagerInstance(Configuration conf) {
        if (localNodeLabelsManager == null) {
            localNodeLabelsManager = new CommonNodeLabelsManager();
            localNodeLabelsManager.init(conf);
            localNodeLabelsManager.start();
        }
        return localNodeLabelsManager;
    }

    private Set<String> buildNodeLabelsSetFromStr(String args) {
        HashSet<String> labels = new HashSet<String>();
        for (String p : args.split(",")) {
            if (p.trim().isEmpty()) continue;
            labels.add(p.trim());
        }
        if (labels.isEmpty()) {
            throw new IllegalArgumentException(NO_LABEL_ERR_MSG);
        }
        return labels;
    }

    private int addToClusterNodeLabels(String args) throws IOException, YarnException {
        RMAdminCLI.printNodeLabelsMsg();
        return 0;
    }

    private int removeFromClusterNodeLabels(String args) throws IOException, YarnException {
        RMAdminCLI.printNodeLabelsMsg();
        return 0;
    }

    private Map<NodeId, Set<String>> buildNodeLabelsMapFromStr(String args) {
        HashMap<NodeId, Set<String>> map2 = new HashMap<NodeId, Set<String>>();
        for (String nodeToLabels : args.split("[ \n]")) {
            if ((nodeToLabels = nodeToLabels.trim()).isEmpty() || nodeToLabels.startsWith("#")) continue;
            String[] splits = nodeToLabels.split("=");
            int index2 = 0;
            if (splits.length != 2) {
                splits = nodeToLabels.split(",");
                index2 = 1;
            }
            String nodeIdStr = splits[0];
            if (index2 == 0) {
                splits = splits[1].split(",");
            }
            Preconditions.checkArgument((!nodeIdStr.trim().isEmpty() ? 1 : 0) != 0, (Object)"node name cannot be empty");
            NodeId nodeId = ConverterUtils.toNodeIdWithDefaultPort(nodeIdStr);
            map2.put(nodeId, new HashSet());
            for (int i = index2; i < splits.length; ++i) {
                if (splits[i].trim().isEmpty()) continue;
                ((Set)map2.get(nodeId)).add(splits[i].trim());
            }
            int nLabels = ((Set)map2.get(nodeId)).size();
            Preconditions.checkArgument((nLabels <= 1 ? 1 : 0) != 0, (String)"%d labels specified on host=%s, please note that we do not support specifying multiple labels on a single host for now.", (Object[])new Object[]{nLabels, nodeIdStr});
        }
        if (map2.isEmpty()) {
            throw new IllegalArgumentException(NO_MAPPING_ERR_MSG);
        }
        return map2;
    }

    private int replaceLabelsOnNodes(String args) throws IOException, YarnException {
        RMAdminCLI.printNodeLabelsMsg();
        return 0;
    }

    private int replaceLabelsOnNodes(Map<NodeId, Set<String>> map2) throws IOException, YarnException {
        if (this.directlyAccessNodeLabelStore) {
            RMAdminCLI.getNodeLabelManagerInstance(this.getConf()).replaceLabelsOnNode(map2);
        } else {
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            ReplaceLabelsOnNodeRequest request = ReplaceLabelsOnNodeRequest.newInstance(map2);
            adminProtocol.replaceLabelsOnNode(request);
        }
        return 0;
    }

    public int run(String[] args) throws Exception {
        ArrayList<String> argsList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-directlyAccessNodeLabelStore")) {
                this.directlyAccessNodeLabelStore = true;
                continue;
            }
            argsList.add(args[i]);
        }
        args = argsList.toArray(new String[0]);
        YarnConfiguration yarnConf = this.getConf() == null ? new YarnConfiguration() : new YarnConfiguration(this.getConf());
        boolean isHAEnabled = yarnConf.getBoolean("yarn.resourcemanager.ha.enabled", false);
        if (args.length < 1) {
            RMAdminCLI.printUsage("", isHAEnabled);
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        String cmd = args[i++];
        exitCode = 0;
        if ("-help".equals(cmd)) {
            if (i < args.length) {
                RMAdminCLI.printUsage(args[i], isHAEnabled);
            } else {
                RMAdminCLI.printHelp("", isHAEnabled);
            }
            return exitCode;
        }
        if (USAGE.containsKey(cmd)) {
            if (isHAEnabled) {
                return super.run(args);
            }
            System.out.println("Cannot run " + cmd + " when ResourceManager HA is not enabled");
            return -1;
        }
        if (("-refreshAdminAcls".equals(cmd) || "-refreshQueues".equals(cmd) || "-refreshNodes".equals(cmd) || "-refreshServiceAcl".equals(cmd) || "-refreshUserToGroupsMappings".equals(cmd) || "-refreshSuperUserGroupsConfiguration".equals(cmd) || "-showlabels".equals(cmd) || "-refreshlabels".equals(cmd)) && args.length != 1) {
            RMAdminCLI.printUsage(cmd, isHAEnabled);
            return exitCode;
        }
        try {
            if ("-refreshQueues".equals(cmd)) {
                exitCode = this.refreshQueues();
            } else if ("-refreshNodes".equals(cmd)) {
                exitCode = this.refreshNodes();
            } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
                exitCode = this.refreshUserToGroupsMappings();
            } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
                exitCode = this.refreshSuperUserGroupsConfiguration();
            } else if ("-refreshAdminAcls".equals(cmd)) {
                exitCode = this.refreshAdminAcls();
            } else if ("-refreshServiceAcl".equals(cmd)) {
                exitCode = this.refreshServiceAcls();
            } else if ("-showLabels".equals(cmd)) {
                exitCode = this.showLabels();
            } else if ("-refreshLabels".equals(cmd)) {
                exitCode = this.refreshLabels();
            } else if ("-getGroups".equals(cmd)) {
                String[] usernames = Arrays.copyOfRange(args, i, args.length);
                exitCode = this.getGroups(usernames);
            } else if ("-addToClusterNodeLabels".equals(cmd)) {
                if (i >= args.length) {
                    System.err.println(NO_LABEL_ERR_MSG);
                    exitCode = -1;
                } else {
                    exitCode = this.addToClusterNodeLabels(args[i]);
                }
            } else if ("-removeFromClusterNodeLabels".equals(cmd)) {
                if (i >= args.length) {
                    System.err.println(NO_LABEL_ERR_MSG);
                    exitCode = -1;
                } else {
                    exitCode = this.removeFromClusterNodeLabels(args[i]);
                }
            } else if ("-replaceLabelsOnNode".equals(cmd)) {
                if (i >= args.length) {
                    System.err.println(NO_MAPPING_ERR_MSG);
                    exitCode = -1;
                } else {
                    exitCode = this.replaceLabelsOnNodes(args[i]);
                }
            } else {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": Unknown command");
                RMAdminCLI.printUsage("", isHAEnabled);
            }
        }
        catch (IllegalArgumentException arge) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            RMAdminCLI.printUsage(cmd, isHAEnabled);
        }
        catch (RemoteException e) {
            exitCode = -1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
        }
        if (null != localNodeLabelsManager) {
            localNodeLabelsManager.stop();
        }
        return exitCode;
    }

    public void setConf(Configuration conf) {
        if (conf != null) {
            conf = RMAdminCLI.addSecurityConfiguration(conf);
        }
        super.setConf(conf);
    }

    private static Configuration addSecurityConfiguration(Configuration conf) {
        conf = new YarnConfiguration(conf);
        conf.set("hadoop.security.service.user.name.key", conf.get("yarn.resourcemanager.principal", ""));
        return conf;
    }

    protected HAServiceTarget resolveTarget(String rmId) {
        Collection<String> rmIds = HAUtil.getRMHAIds(this.getConf());
        if (!rmIds.contains(rmId)) {
            StringBuilder msg = new StringBuilder();
            msg.append(rmId + " is not a valid serviceId. It should be one of ");
            for (String id : rmIds) {
                msg.append(id + " ");
            }
            throw new IllegalArgumentException(msg.toString());
        }
        try {
            YarnConfiguration conf = new YarnConfiguration(this.getConf());
            conf.set("yarn.resourcemanager.ha.id", rmId);
            return new RMHAServiceTarget(conf);
        }
        catch (IllegalArgumentException iae) {
            throw new YarnRuntimeException("Could not connect to " + rmId + "; the configuration for it might be missing");
        }
        catch (IOException ioe) {
            throw new YarnRuntimeException("Could not connect to RM HA Admin for node " + rmId);
        }
    }

    protected String getUsageString() {
        return "Usage: rmadmin";
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new RMAdminCLI(), (String[])args);
        System.exit(result);
    }
}

