/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.SCMAdminProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.RunSharedCacheCleanerTaskRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RunSharedCacheCleanerTaskResponse;

public class SCMAdmin
extends Configured
implements Tool {
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public SCMAdmin() {
    }

    public SCMAdmin(Configuration conf) {
        super(conf);
    }

    private static void printHelp(String cmd) {
        String summary = "scmadmin is the command to execute shared cache manageradministrative commands.\nThe full syntax is: \n\nhadoop scmadmin [-runCleanerTask] [-help [cmd]]\n";
        String runCleanerTask = "-runCleanerTask: Run cleaner task right away.\n";
        String help = "-help [cmd]: \tDisplays help for the given command or all commands if none\n\t\tis specified.\n";
        if ("runCleanerTask".equals(cmd)) {
            System.out.println(runCleanerTask);
        } else if ("help".equals(cmd)) {
            System.out.println(help);
        } else {
            System.out.println(summary);
            System.out.println(runCleanerTask);
            System.out.println(help);
            System.out.println();
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        }
    }

    private static void printUsage(String cmd) {
        if ("-runCleanerTask".equals(cmd)) {
            System.err.println("Usage: yarn scmadmin [-runCleanerTask]");
        } else {
            System.err.println("Usage: yarn scmadmin");
            System.err.println("           [-runCleanerTask]");
            System.err.println("           [-help [cmd]]");
            System.err.println();
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
        }
    }

    protected SCMAdminProtocol createSCMAdminProtocol() throws IOException {
        YarnConfiguration conf = new YarnConfiguration(this.getConf());
        InetSocketAddress addr = conf.getSocketAddr("yarn.sharedcache.admin.address", "0.0.0.0:8047", 8047);
        YarnRPC rpc = YarnRPC.create(conf);
        SCMAdminProtocol scmAdminProtocol = (SCMAdminProtocol)rpc.getProxy(SCMAdminProtocol.class, addr, conf);
        return scmAdminProtocol;
    }

    private int runCleanerTask() throws YarnException, IOException {
        RunSharedCacheCleanerTaskRequest request;
        SCMAdminProtocol scmAdminProtocol = this.createSCMAdminProtocol();
        RunSharedCacheCleanerTaskResponse response = scmAdminProtocol.runCleanerTask(request = this.recordFactory.newRecordInstance(RunSharedCacheCleanerTaskRequest.class));
        if (response.getAccepted()) {
            System.out.println("request accepted by shared cache manager");
            return 0;
        }
        System.out.println("request rejected by shared cache manager");
        return 1;
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1) {
            SCMAdmin.printUsage("");
            return -1;
        }
        int i = 0;
        String cmd = args[i++];
        try {
            if ("-runCleanerTask".equals(cmd)) {
                if (args.length != 1) {
                    SCMAdmin.printUsage(cmd);
                    return -1;
                }
                return this.runCleanerTask();
            }
            if ("-help".equals(cmd)) {
                if (i < args.length) {
                    SCMAdmin.printUsage(args[i]);
                } else {
                    SCMAdmin.printHelp("");
                }
                return 0;
            }
            System.err.println(cmd.substring(1) + ": Unknown command");
            SCMAdmin.printUsage("");
            return -1;
        }
        catch (IllegalArgumentException arge) {
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            SCMAdmin.printUsage(cmd);
        }
        catch (RemoteException e) {
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new SCMAdmin(), (String[])args);
        System.exit(result);
    }
}

