/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DefaultResourceCalculatorWithDisk
extends DefaultResourceCalculator {
    @Override
    public Resource divideAndCeil(Resource numerator, int denominator) {
        return Resources.createResource(DefaultResourceCalculatorWithDisk.divideAndCeil(numerator.getMemory(), denominator), numerator.getVirtualCores(), numerator.getDisks());
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource, Resource stepFactor) {
        int normalizedMemory = Math.min(DefaultResourceCalculatorWithDisk.roundUp(Math.max(r.getMemory(), minimumResource.getMemory()), stepFactor.getMemory()), maximumResource.getMemory());
        return Resources.createResource(normalizedMemory, r.getVirtualCores(), r.getDisks());
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource) {
        return this.normalize(r, minimumResource, maximumResource, minimumResource);
    }

    @Override
    public Resource roundUp(Resource r, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculatorWithDisk.roundUp(r.getMemory(), stepFactor.getMemory()), r.getVirtualCores(), r.getDisks());
    }

    @Override
    public Resource roundDown(Resource r, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculatorWithDisk.roundDown(r.getMemory(), stepFactor.getMemory()), r.getVirtualCores(), r.getDisks());
    }

    @Override
    public Resource multiplyAndNormalizeUp(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculatorWithDisk.roundUp((int)((double)r.getMemory() * by + 0.5), stepFactor.getMemory()), r.getVirtualCores(), r.getDisks());
    }

    @Override
    public Resource multiplyAndNormalizeDown(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculatorWithDisk.roundDown((int)((double)r.getMemory() * by), stepFactor.getMemory()), r.getVirtualCores(), r.getDisks());
    }
}

