/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.yarn.util.ProcfsBasedProcessTree;
import org.apache.hadoop.yarn.util.WindowsBasedProcessTree;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class ResourceCalculatorProcessTree
extends Configured {
    static final Log LOG = LogFactory.getLog(ResourceCalculatorProcessTree.class);
    public static final int UNAVAILABLE = -1;

    public ResourceCalculatorProcessTree(String root2) {
    }

    public abstract void updateProcessTree();

    public abstract String getProcessTreeDump();

    public long getVirtualMemorySize() {
        return this.getVirtualMemorySize(0);
    }

    @Deprecated
    public long getCumulativeVmem() {
        return this.getCumulativeVmem(0);
    }

    public long getRssMemorySize() {
        return this.getRssMemorySize(0);
    }

    @Deprecated
    public long getCumulativeRssmem() {
        return this.getCumulativeRssmem(0);
    }

    public long getVirtualMemorySize(int olderThanAge) {
        return -1L;
    }

    @Deprecated
    public long getCumulativeVmem(int olderThanAge) {
        return -1L;
    }

    public long getRssMemorySize(int olderThanAge) {
        return -1L;
    }

    @Deprecated
    public long getCumulativeRssmem(int olderThanAge) {
        return -1L;
    }

    public long getCumulativeCpuTime() {
        return -1L;
    }

    public float getCpuUsagePercent() {
        return -1.0f;
    }

    public abstract boolean checkPidPgrpidForMatch();

    public static ResourceCalculatorProcessTree getResourceCalculatorProcessTree(String pid, Class<? extends ResourceCalculatorProcessTree> clazz, Configuration conf) {
        if (clazz != null) {
            try {
                Constructor<? extends ResourceCalculatorProcessTree> c = clazz.getConstructor(String.class);
                ResourceCalculatorProcessTree rctree = c.newInstance(pid);
                rctree.setConf(conf);
                return rctree;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (ProcfsBasedProcessTree.isAvailable()) {
            return new ProcfsBasedProcessTree(pid);
        }
        if (WindowsBasedProcessTree.isAvailable()) {
            return new WindowsBasedProcessTree(pid);
        }
        return null;
    }
}

