/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.IOException;
import java.util.Arrays;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;

class ArrayAccessor {
    ArrayAccessor() {
    }

    static void writeArray(boolean[] data, Encoder out) throws IOException {
        int size2 = data.length;
        out.setItemCount(size2);
        for (int i = 0; i < size2; ++i) {
            out.startItem();
            out.writeBoolean(data[i]);
        }
    }

    static void writeArray(short[] data, Encoder out) throws IOException {
        int size2 = data.length;
        out.setItemCount(size2);
        for (int i = 0; i < size2; ++i) {
            out.startItem();
            out.writeInt(data[i]);
        }
    }

    static void writeArray(char[] data, Encoder out) throws IOException {
        int size2 = data.length;
        out.setItemCount(size2);
        for (int i = 0; i < size2; ++i) {
            out.startItem();
            out.writeInt(data[i]);
        }
    }

    static void writeArray(int[] data, Encoder out) throws IOException {
        int size2 = data.length;
        out.setItemCount(size2);
        for (int i = 0; i < size2; ++i) {
            out.startItem();
            out.writeInt(data[i]);
        }
    }

    static void writeArray(long[] data, Encoder out) throws IOException {
        int size2 = data.length;
        out.setItemCount(size2);
        for (int i = 0; i < size2; ++i) {
            out.startItem();
            out.writeLong(data[i]);
        }
    }

    static void writeArray(float[] data, Encoder out) throws IOException {
        int size2 = data.length;
        out.setItemCount(size2);
        for (int i = 0; i < size2; ++i) {
            out.startItem();
            out.writeFloat(data[i]);
        }
    }

    static void writeArray(double[] data, Encoder out) throws IOException {
        int size2 = data.length;
        out.setItemCount(size2);
        for (int i = 0; i < size2; ++i) {
            out.startItem();
            out.writeDouble(data[i]);
        }
    }

    static Object readArray(Object array, Class<?> elementType, long l, ResolvingDecoder in) throws IOException {
        if (elementType == Integer.TYPE) {
            return ArrayAccessor.readArray((int[])array, l, in);
        }
        if (elementType == Long.TYPE) {
            return ArrayAccessor.readArray((long[])array, l, in);
        }
        if (elementType == Float.TYPE) {
            return ArrayAccessor.readArray((float[])array, l, in);
        }
        if (elementType == Double.TYPE) {
            return ArrayAccessor.readArray((double[])array, l, in);
        }
        if (elementType == Boolean.TYPE) {
            return ArrayAccessor.readArray((boolean[])array, l, in);
        }
        if (elementType == Character.TYPE) {
            return ArrayAccessor.readArray((char[])array, l, in);
        }
        if (elementType == Short.TYPE) {
            return ArrayAccessor.readArray((short[])array, l, in);
        }
        return null;
    }

    static boolean[] readArray(boolean[] array, long l, ResolvingDecoder in) throws IOException {
        int index2 = 0;
        do {
            int limit;
            if (array.length < (limit = index2 + (int)l)) {
                array = Arrays.copyOf(array, limit);
            }
            while (index2 < limit) {
                array[index2] = in.readBoolean();
                ++index2;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array;
    }

    static int[] readArray(int[] array, long l, ResolvingDecoder in) throws IOException {
        int index2 = 0;
        do {
            int limit;
            if (array.length < (limit = index2 + (int)l)) {
                array = Arrays.copyOf(array, limit);
            }
            while (index2 < limit) {
                array[index2] = in.readInt();
                ++index2;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array;
    }

    static short[] readArray(short[] array, long l, ResolvingDecoder in) throws IOException {
        int index2 = 0;
        do {
            int limit;
            if (array.length < (limit = index2 + (int)l)) {
                array = Arrays.copyOf(array, limit);
            }
            while (index2 < limit) {
                array[index2] = (short)in.readInt();
                ++index2;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array;
    }

    static char[] readArray(char[] array, long l, ResolvingDecoder in) throws IOException {
        int index2 = 0;
        do {
            int limit;
            if (array.length < (limit = index2 + (int)l)) {
                array = Arrays.copyOf(array, limit);
            }
            while (index2 < limit) {
                array[index2] = (char)in.readInt();
                ++index2;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array;
    }

    static long[] readArray(long[] array, long l, ResolvingDecoder in) throws IOException {
        int index2 = 0;
        do {
            int limit;
            if (array.length < (limit = index2 + (int)l)) {
                array = Arrays.copyOf(array, limit);
            }
            while (index2 < limit) {
                array[index2] = in.readLong();
                ++index2;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array;
    }

    static float[] readArray(float[] array, long l, ResolvingDecoder in) throws IOException {
        int index2 = 0;
        do {
            int limit;
            if (array.length < (limit = index2 + (int)l)) {
                array = Arrays.copyOf(array, limit);
            }
            while (index2 < limit) {
                array[index2] = in.readFloat();
                ++index2;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array;
    }

    static double[] readArray(double[] array, long l, ResolvingDecoder in) throws IOException {
        int index2 = 0;
        do {
            int limit;
            if (array.length < (limit = index2 + (int)l)) {
                array = Arrays.copyOf(array, limit);
            }
            while (index2 < limit) {
                array[index2] = in.readDouble();
                ++index2;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array;
    }
}

