/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.Configurables;
import org.apache.flume.source.AbstractSource;
import org.apache.flume.source.SyslogUtils;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.AdaptiveReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.oio.OioDatagramChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.annotations.VisibleForTesting;

public class SyslogUDPSource
extends AbstractSource
implements EventDrivenSource,
Configurable {
    private int port;
    private int maxsize = 65536;
    private String host = null;
    private Channel nettyChannel;
    private Map<String, String> formaterProp;
    private Set<String> keepFields;
    private static final Logger logger = LoggerFactory.getLogger(SyslogUDPSource.class);
    private CounterGroup counterGroup = new CounterGroup();
    public static final int DEFAULT_MIN_SIZE = 2048;
    public static final int DEFAULT_INITIAL_SIZE = 2048;

    @Override
    public void start() {
        ConnectionlessBootstrap serverBootstrap = new ConnectionlessBootstrap((ChannelFactory)new OioDatagramChannelFactory((Executor)Executors.newCachedThreadPool()));
        final syslogHandler handler = new syslogHandler();
        handler.setFormater(this.formaterProp);
        handler.setKeepFields(this.keepFields);
        serverBootstrap.setOption("receiveBufferSizePredictorFactory", (Object)new AdaptiveReceiveBufferSizePredictorFactory(2048, 2048, this.maxsize));
        serverBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{handler});
            }
        });
        this.nettyChannel = this.host == null ? serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.port)) : serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.host, this.port));
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        logger.info("Syslog UDP Source stopping...");
        logger.info("Metrics:{}", (Object)this.counterGroup);
        if (this.nettyChannel != null) {
            this.nettyChannel.close();
            try {
                this.nettyChannel.getCloseFuture().await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("netty server stop interrupted", (Throwable)e);
            }
            finally {
                this.nettyChannel = null;
            }
        }
        super.stop();
    }

    @Override
    public void configure(Context context) {
        Configurables.ensureRequiredNonNull(context, "port");
        this.port = context.getInteger("port");
        this.host = context.getString("host");
        this.formaterProp = context.getSubProperties("format.");
        this.keepFields = SyslogUtils.chooseFieldsToKeep(context.getString("keepFields", "none"));
    }

    @VisibleForTesting
    public int getSourcePort() {
        SocketAddress localAddress = this.nettyChannel.getLocalAddress();
        if (localAddress instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)localAddress;
            return addr.getPort();
        }
        return 0;
    }

    public class syslogHandler
    extends SimpleChannelHandler {
        private SyslogUtils syslogUtils = new SyslogUtils(2048, null, true);

        public void setFormater(Map<String, String> prop) {
            this.syslogUtils.addFormats(prop);
        }

        public void setKeepFields(Set<String> keepFields) {
            this.syslogUtils.setKeepFields(keepFields);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent mEvent) {
            try {
                this.syslogUtils.setEventSize(SyslogUDPSource.this.maxsize);
                Event e = this.syslogUtils.extractEvent((ChannelBuffer)mEvent.getMessage());
                if (e == null) {
                    return;
                }
                SyslogUDPSource.this.getChannelProcessor().processEvent(e);
                SyslogUDPSource.this.counterGroup.incrementAndGet("events.success");
            }
            catch (ChannelException ex) {
                SyslogUDPSource.this.counterGroup.incrementAndGet("events.dropped");
                logger.error("Error writting to channel", (Throwable)ex);
                return;
            }
        }
    }
}

