/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.PollableSource;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.source.BasicSourceSemantics;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractPollableSource
extends BasicSourceSemantics
implements PollableSource {
    @Override
    public PollableSource.Status process() throws EventDeliveryException {
        Exception exception = this.getStartException();
        if (exception != null) {
            throw new FlumeException("Source had error configuring or starting", exception);
        }
        if (!this.isStarted()) {
            throw new EventDeliveryException("Source is not started");
        }
        return this.doProcess();
    }

    protected abstract PollableSource.Status doProcess() throws EventDeliveryException;
}

