/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.serialization;

import java.io.OutputStream;
import java.util.Locale;
import org.apache.flume.Context;
import org.apache.flume.FlumeException;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.serialization.EventSerializer;
import org.apache.flume.serialization.EventSerializerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class EventSerializerFactory {
    private static final Logger logger = LoggerFactory.getLogger(EventSerializerFactory.class);

    public static EventSerializer getInstance(String serializerType, Context context, OutputStream out) {
        EventSerializer.Builder builder;
        EventSerializerType type;
        Preconditions.checkNotNull((Object)serializerType, (Object)"serializer type must not be null");
        try {
            type = EventSerializerType.valueOf(serializerType.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            logger.debug("Not in enum, loading builder class: {}", (Object)serializerType);
            type = EventSerializerType.OTHER;
        }
        Class<EventSerializer.Builder> builderClass = type.getBuilderClass();
        if (builderClass == null) {
            try {
                Class<?> c = Class.forName(serializerType);
                if (c == null || !EventSerializer.Builder.class.isAssignableFrom(c)) {
                    String errMessage = "Unable to instantiate Builder from " + serializerType + ": does not appear to implement " + EventSerializer.Builder.class.getName();
                    throw new FlumeException(errMessage);
                }
                builderClass = c;
            }
            catch (ClassNotFoundException ex) {
                logger.error("Class not found: " + serializerType, (Throwable)ex);
                throw new FlumeException(ex);
            }
        }
        try {
            builder = builderClass.newInstance();
        }
        catch (InstantiationException ex) {
            String errMessage = "Cannot instantiate builder: " + serializerType;
            logger.error(errMessage, (Throwable)ex);
            throw new FlumeException(errMessage, ex);
        }
        catch (IllegalAccessException ex) {
            String errMessage = "Cannot instantiate builder: " + serializerType;
            logger.error(errMessage, (Throwable)ex);
            throw new FlumeException(errMessage, ex);
        }
        return builder.build(context, out);
    }
}

